/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import jline.internal.Log;

public class Configuration {
    public static final String JLINE_INPUTRC = "jline.inputrc";
    public static final String JLINE_RC = ".jline.rc";
    public static final String INPUT_RC = ".inputrc";
    private static Configuration configuration;
    private final Properties props;
    private final URL jlinercUrl;

    public static Configuration getConfig() {
        return Configuration.getConfig((URL)null);
    }

    public static Configuration getConfig(String fileOrUrl) {
        return Configuration.getConfig(Configuration.getUrlFrom(fileOrUrl));
    }

    public static Configuration getConfig(URL url) {
        if (url == null) {
            url = Configuration.getUrlFrom(new File(Configuration.getUserHome(), JLINE_RC));
        }
        if (configuration == null || !url.equals(Configuration.configuration.jlinercUrl)) {
            configuration = new Configuration(url);
        }
        return configuration;
    }

    public Configuration() {
        this(Configuration.getUrlFrom(new File(Configuration.getUserHome(), JLINE_RC)));
    }

    public Configuration(File inputRc) {
        this(Configuration.getUrlFrom(inputRc));
    }

    public Configuration(String fileOrUrl) {
        this(Configuration.getUrlFrom(fileOrUrl));
    }

    public Configuration(URL jlinercUrl) {
        this.jlinercUrl = jlinercUrl;
        this.props = this.loadProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProps() {
        Properties props = new Properties();
        try {
            InputStream input = this.jlinercUrl.openStream();
            try {
                props.load(new BufferedInputStream(input));
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            if (this.jlinercUrl.getProtocol().equals("file")) {
                File file = new File(this.jlinercUrl.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", this.jlinercUrl, e);
                }
            }
            Log.warn("Unable to read user configuration: ", this.jlinercUrl, e);
        }
        return props;
    }

    public static URL getUrlFrom(String fileOrUrl) {
        if (fileOrUrl == null) {
            return null;
        }
        try {
            return new URL(fileOrUrl);
        }
        catch (MalformedURLException e) {
            return Configuration.getUrlFrom(new File(fileOrUrl));
        }
    }

    public static URL getUrlFrom(File inputRc) {
        try {
            return inputRc != null ? inputRc.toURI().toURL() : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public String string(String name, String defaultValue) {
        assert (name != null);
        String value = System.getProperty(name);
        if (value == null && (value = this.props.getProperty(name)) == null) {
            value = defaultValue;
        }
        return value;
    }

    public String string(String name) {
        return this.string(name, null);
    }

    public boolean bool(String name, boolean defaultValue) {
        String value = this.string(name, null);
        if (value == null) {
            return defaultValue;
        }
        return value.length() == 0 || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true");
    }

    public boolean bool(String name) {
        return this.bool(name, false);
    }

    public static String getString(String name, String defaultValue) {
        return Configuration.getConfig().string(name, defaultValue);
    }

    public static String getString(String name) {
        return Configuration.getString(name, null);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        return Configuration.getConfig().bool(name, defaultValue);
    }

    public static boolean getBoolean(String name) {
        return Configuration.getBoolean(name, false);
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getEncoding() {
        String ctype = System.getenv("LC_CTYPE");
        if (ctype != null && ctype.indexOf(46) > 0) {
            return ctype.substring(ctype.indexOf(46) + 1);
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }
}

