/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.functions.GenericIterableFactory;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
        Loader.instance().preinitializeMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public File getSavesDirectory() {
        return ((ayr)this.server.S()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            FMLLog.warning("%s", query.getText());
            query.finish();
        } else {
            String text = query.getText() + "\n\nRun the command /fml confirm or or /fml cancel to proceed." + "\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
            FMLLog.warning("%s", text);
            if (!query.isSynchronous()) {
                return;
            }
            boolean done = false;
            while (!done && this.server.q()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                lt dedServer = (lt)this.server;
                List list = dedServer.j;
                synchronized (list) {
                    Iterator<le> it = GenericIterableFactory.newCastingIterable(dedServer.j, le.class).iterator();
                    while (it.hasNext()) {
                        String cmd = it.next().a.trim().toLowerCase();
                        if (cmd.equals("/fml confirm")) {
                            FMLLog.info("confirmed", new Object[0]);
                            query.setResult(true);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (cmd.equals("/fml cancel")) {
                            FMLLog.info("cancelled", new Object[0]);
                            query.setResult(false);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (!cmd.equals("/stop")) continue;
                        StartupQuery.abort();
                    }
                }
                Thread.sleep(10L);
            }
            query.finish();
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    @Override
    public void addModAsResource(ModContainer container) {
        LanguageRegistry.instance().loadLanguagesFor(container, Side.SERVER);
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public ej getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }

    @Override
    public fb getClientPlayHandler() {
        return null;
    }

    @Override
    public void waitForPlayClient() {
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, ej manager, Set<String> channelSet, String channel, Side side) {
        bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<nh>(manager, channelSet, channel, side, nh.class));
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return lt.allowPlayerLogins;
    }

    @Override
    public void allowLogins() {
        lt.allowPlayerLogins = true;
    }

    @Override
    public void processWindowMessages() {
    }
}

