/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.component;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mantle.world.CoordTuple;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockMasterBaseLogic;

public class SignalBusMasterLogic
extends MultiblockMasterBaseLogic {
    private boolean forceUpdate = false;
    private boolean forceSouthboundUpdates = false;
    private boolean signalUpdate = false;
    private byte[] masterSignals = new byte[16];
    private CoordTuple[] signalProviderCoords = new CoordTuple[16];
    private Map<CoordTuple, byte[]> tetheredBuses = new HashMap<CoordTuple, byte[]>();

    public SignalBusMasterLogic(World world) {
        super(world);
        for (int i = 0; i < 16; ++i) {
            this.masterSignals[i] = 0;
        }
    }

    @Override
    public boolean doUpdate() {
        if (this.worldObj.field_72995_K || !this.forceUpdate) {
            return false;
        }
        this.forceUpdate = false;
        byte[] oldSignals = this.masterSignals;
        this.masterSignals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (byte[] signals : this.tetheredBuses.values()) {
            this.calcSignals(signals);
        }
        if (this.forceSouthboundUpdates || !Arrays.equals(oldSignals, this.masterSignals)) {
            for (CoordTuple coord : this.tetheredBuses.keySet()) {
                TileEntity te;
                if (!this.worldObj.func_72863_F().func_73149_a(coord.x >> 4, coord.z >> 4) || !((te = this.worldObj.func_147438_o(coord.x, coord.y, coord.z)) instanceof SignalBusLogic)) continue;
                ((SignalBusLogic)te).updateLocalSignals(this.masterSignals);
                ((SignalBusLogic)te).multiBlockTick();
            }
        }
        return true;
    }

    public void updateBusSignals(CoordTuple bus, byte[] signals) {
        if (!Arrays.equals(this.tetheredBuses.get(bus), signals)) {
            this.tetheredBuses.put(bus, signals);
            this.forceUpdate = true;
        }
    }

    public byte[] getSignals() {
        return (byte[])this.masterSignals.clone();
    }

    @Override
    protected void onBlockAdded(IMultiblockMember newMember) {
    }

    @Override
    protected void onBlockRemoved(IMultiblockMember oldMember) {
        if (this.tetheredBuses.containsKey(oldMember.getCoordInWorld())) {
            this.tetheredBuses.remove(oldMember.getCoordInWorld());
            this.forceUpdate = true;
        }
    }

    @Override
    protected void onDataMerge(MultiblockMasterBaseLogic newMaster) {
        if (this.tetheredBuses.size() > 0) {
            ((SignalBusMasterLogic)newMaster).mergeTethered(this.tetheredBuses);
        }
        ((SignalBusMasterLogic)newMaster).calcSignals(this.masterSignals);
        ((SignalBusMasterLogic)newMaster).forceUpdate();
    }

    @Override
    public void endMerging() {
        this.forceSouthboundUpdates = true;
    }

    protected void calcSignals(byte[] signals) {
        for (int idx = 0; idx < 16; ++idx) {
            if (signals[idx] <= this.masterSignals[idx]) continue;
            this.masterSignals[idx] = signals[idx];
        }
    }

    protected void mergeTethered(Map<CoordTuple, byte[]> oldMasterTethered) {
        this.tetheredBuses.putAll(oldMasterTethered);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }
}

