/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import cpw.mods.fml.common.Optional;
import java.util.HashMap;
import java.util.Map;
import magicbees.api.bees.AuraChargeType;
import magicbees.api.bees.IMagicApiaryAuraProvider;
import magicbees.bees.AuraCharge;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import vazkii.botania.api.mana.IManaReceiver;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.botania.api.mana.IManaReceiver", modid="Botania")})
public class TileEntityManaAuraProvider
extends TileEntity
implements IMagicApiaryAuraProvider,
IManaReceiver {
    public static final String tileEntityName = "magicbees.manaAuraProvider";
    private static final int MAX_CHARGES = 4;
    private static final int MANA_PER_CHARGE = 4000;
    private static final int MAX_MANA = 16000;
    private final Map<AuraCharge, ManaAuraCharge> currentCharges;
    private int currentMana;

    public TileEntityManaAuraProvider() {
        AuraCharge[] auraChargeTypes = AuraCharge.values();
        this.currentCharges = new HashMap<AuraCharge, ManaAuraCharge>(auraChargeTypes.length);
        for (AuraCharge auraChargeType : auraChargeTypes) {
            this.currentCharges.put(auraChargeType, new ManaAuraCharge());
        }
    }

    public void func_145845_h() {
        long tick = this.field_145850_b.func_82737_E();
        int manaForCharge = this.currentMana / 5;
        if (manaForCharge > 0) {
            for (Map.Entry<AuraCharge, ManaAuraCharge> currentCharge : this.currentCharges.entrySet()) {
                AuraCharge type = currentCharge.getKey();
                ManaAuraCharge auraCharge = currentCharge.getValue();
                if (auraCharge.charges >= 4 || tick % (long)type.tickRate != 0L || this.currentMana <= 0) continue;
                auraCharge.mana += manaForCharge;
                if (auraCharge.mana <= 4000) continue;
                auraCharge.mana -= 4000;
                ++auraCharge.charges;
            }
        }
    }

    @Override
    public boolean getMutationCharge() {
        return this.getCharge(AuraChargeType.MUTATION);
    }

    @Override
    public boolean getDeathRateCharge() {
        return this.getCharge(AuraChargeType.DEATH);
    }

    @Override
    public boolean getProductionCharge() {
        return this.getCharge(AuraChargeType.PRODUCTION);
    }

    @Override
    public boolean getCharge(AuraChargeType auraChargeType) {
        ManaAuraCharge charge = this.currentCharges.get((Object)AuraCharge.fromChargeType(auraChargeType));
        if (charge == null) {
            return false;
        }
        if (charge.charges > 0) {
            --charge.charges;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Botania")
    public int getCurrentMana() {
        return this.currentMana;
    }

    @Optional.Method(modid="Botania")
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Optional.Method(modid="Botania")
    public boolean isFull() {
        return this.currentMana == 16000;
    }

    @Optional.Method(modid="Botania")
    public void recieveMana(int amount) {
        this.currentMana = this.currentMana + amount > 16000 ? 16000 : this.currentMana + amount;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (Map.Entry<AuraCharge, ManaAuraCharge> charge : this.currentCharges.entrySet()) {
            String auraName = charge.getKey().toString();
            int[] array = tag.func_74759_k(auraName);
            ManaAuraCharge auraCharge = charge.getValue();
            auraCharge.fromArray(array);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (Map.Entry<AuraCharge, ManaAuraCharge> charge : this.currentCharges.entrySet()) {
            String auraName = charge.getKey().toString();
            ManaAuraCharge auraCharge = charge.getValue();
            int[] array = auraCharge.toArray();
            tag.func_74783_a(auraName, array);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, compound);
    }

    private static class ManaAuraCharge {
        int charges;
        int mana;

        private ManaAuraCharge() {
        }

        public int[] toArray() {
            return new int[]{this.charges, this.mana};
        }

        public void fromArray(int[] array) {
            if (array.length == 2) {
                this.charges = array[0];
                this.mana = array[1];
            }
        }
    }
}

