/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.entity.living.EntityDrone;

public class PathFinderDrone {
    private final EntityDrone drone;
    private final IBlockAccess worldMap;
    private final Path path = new Path();
    private final IntHashMap pointMap = new IntHashMap();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private boolean isPathingInWater;
    private final boolean canEntityDrown;

    public PathFinderDrone(EntityDrone drone, IBlockAccess world, boolean pathFindThroughWoodenDoor, boolean movementBlockAllowed, boolean pathFindThroughWater, boolean canDrown) {
        this.drone = drone;
        this.worldMap = world;
        this.isPathingInWater = pathFindThroughWater;
        this.canEntityDrown = canDrown;
    }

    public PathEntity createEntityPathTo(Entity par1Entity, Entity par2Entity, float par3) {
        return this.createEntityPathTo(par1Entity, par2Entity.field_70165_t, par2Entity.field_70121_D.field_72338_b, par2Entity.field_70161_v, par3);
    }

    public PathEntity createEntityPathTo(Entity par1Entity, int par2, int par3, int par4, float par5) {
        return this.createEntityPathTo(par1Entity, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, par5);
    }

    private PathEntity createEntityPathTo(Entity par1Entity, double par2, double par4, double par6, float par8) {
        this.path.func_75848_a();
        this.pointMap.func_76046_c();
        boolean flag = this.isPathingInWater;
        int i = MathHelper.func_76128_c((double)(par1Entity.field_70121_D.field_72338_b + 0.5));
        if (this.canEntityDrown && par1Entity.func_70090_H()) {
            i = (int)par1Entity.field_70121_D.field_72338_b;
            Block j = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)par1Entity.field_70165_t), i, MathHelper.func_76128_c((double)par1Entity.field_70161_v));
            while (j == Blocks.field_150355_j || j == Blocks.field_150358_i) {
                j = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)par1Entity.field_70165_t), ++i, MathHelper.func_76128_c((double)par1Entity.field_70161_v));
            }
            flag = this.isPathingInWater;
            this.isPathingInWater = false;
        } else {
            i = MathHelper.func_76128_c((double)(par1Entity.field_70121_D.field_72338_b + 0.5));
        }
        PathPoint pathpoint = this.openPoint(MathHelper.func_76128_c((double)par1Entity.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)par1Entity.field_70121_D.field_72339_c));
        PathPoint pathpoint1 = this.openPoint(MathHelper.func_76128_c((double)(par2 - (double)(par1Entity.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)par4), MathHelper.func_76128_c((double)(par6 - (double)(par1Entity.field_70130_N / 2.0f))));
        PathPoint pathpoint2 = new PathPoint(MathHelper.func_76141_d((float)(par1Entity.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(par1Entity.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(par1Entity.field_70130_N + 1.0f)));
        PathEntity pathentity = this.addToPath(par1Entity, pathpoint, pathpoint1, pathpoint2, par8);
        this.isPathingInWater = flag;
        return pathentity;
    }

    private PathEntity addToPath(Entity par1Entity, PathPoint par2PathPoint, PathPoint par3PathPoint, PathPoint par4PathPoint, float par5) {
        par2PathPoint.field_75836_e = 0.0f;
        par2PathPoint.field_75834_g = par2PathPoint.field_75833_f = par2PathPoint.func_75829_a(par3PathPoint);
        this.path.func_75848_a();
        this.path.func_75849_a(par2PathPoint);
        PathPoint pathpoint3 = par2PathPoint;
        while (!this.path.func_75845_e()) {
            PathPoint pathpoint4 = this.path.func_75844_c();
            if (pathpoint4.equals((Object)par3PathPoint)) {
                return this.createEntityPath(par2PathPoint, par3PathPoint);
            }
            if (pathpoint4.func_75829_a(par3PathPoint) < pathpoint3.func_75829_a(par3PathPoint)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.field_75842_i = true;
            int i = this.findPathOptions(par1Entity, pathpoint4, par4PathPoint, par3PathPoint, par5);
            for (int j = 0; j < i; ++j) {
                PathPoint pathpoint5 = this.pathOptions[j];
                float f1 = pathpoint4.field_75836_e + pathpoint4.func_75829_a(pathpoint5);
                if (pathpoint5.func_75831_a() && !(f1 < pathpoint5.field_75836_e)) continue;
                pathpoint5.field_75841_h = pathpoint4;
                pathpoint5.field_75836_e = f1;
                pathpoint5.field_75833_f = pathpoint5.func_75829_a(par3PathPoint);
                if (pathpoint5.func_75831_a()) {
                    this.path.func_75850_a(pathpoint5, pathpoint5.field_75836_e + pathpoint5.field_75833_f);
                    continue;
                }
                pathpoint5.field_75834_g = pathpoint5.field_75836_e + pathpoint5.field_75833_f;
                this.path.func_75849_a(pathpoint5);
            }
        }
        if (pathpoint3 == par2PathPoint) {
            return null;
        }
        return this.createEntityPath(par2PathPoint, pathpoint3);
    }

    private int findPathOptions(Entity par1Entity, PathPoint par2PathPoint, PathPoint par3PathPoint, PathPoint par4PathPoint, float par5) {
        int i = 0;
        int b0 = 0;
        if (this.getVerticalOffset(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b + 1, par2PathPoint.field_75838_c, par3PathPoint) == 1) {
            b0 = 1;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PathPoint safePoint = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a + dir.offsetX, par2PathPoint.field_75837_b + dir.offsetY, par2PathPoint.field_75838_c + dir.offsetZ, par3PathPoint, b0);
            if (safePoint == null || safePoint.field_75842_i || !(safePoint.func_75829_a(par4PathPoint) < par5)) continue;
            this.pathOptions[i++] = safePoint;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint, int par6) {
        PathPoint pathpoint1 = null;
        if (this.drone.isBlockValidPathfindBlock(par2, par3, par4)) {
            pathpoint1 = this.openPoint(par2, par3, par4);
        }
        return pathpoint1;
    }

    private final PathPoint openPoint(int par1, int par2, int par3) {
        int l = PathPoint.func_75830_a((int)par1, (int)par2, (int)par3);
        PathPoint pathpoint = (PathPoint)this.pointMap.func_76041_a(l);
        if (pathpoint == null) {
            pathpoint = new PathPoint(par1, par2, par3);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    public int getVerticalOffset(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint) {
        return 1;
    }

    private PathEntity createEntityPath(PathPoint par1PathPoint, PathPoint par2PathPoint) {
        int i = 1;
        PathPoint pathpoint2 = par2PathPoint;
        while (pathpoint2.field_75841_h != null) {
            ++i;
            pathpoint2 = pathpoint2.field_75841_h;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        pathpoint2 = par2PathPoint;
        apathpoint[--i] = par2PathPoint;
        while (pathpoint2.field_75841_h != null) {
            pathpoint2 = pathpoint2.field_75841_h;
            apathpoint[--i] = pathpoint2;
        }
        return new PathEntity(apathpoint);
    }
}

