/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;
import pneumaticCraft.client.gui.GuiButtonSpecial;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.inventory.Container4UpgradeSlots;
import pneumaticCraft.common.tileentity.TileEntityAerialInterface;
import pneumaticCraft.common.util.PneumaticCraftUtils;

@SideOnly(value=Side.CLIENT)
public class GuiAerialInterface
extends GuiPneumaticContainerBase<TileEntityAerialInterface> {
    private final GuiButtonSpecial[] modeButtons = new GuiButtonSpecial[3];

    public GuiAerialInterface(InventoryPlayer player, TileEntityAerialInterface te) {
        super(new Container4UpgradeSlots<TileEntityAerialInterface>(player, te), te, "pneumaticcraft:textures/gui/GuiPressureChamber.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (PneumaticCraftAPIHandler.getInstance().liquidXPs.size() > 0) {
            this.addAnimatedStat("gui.tab.info.aerialInterface.liquidXp.info.title", new ItemStack(Items.field_151131_as), -11141291, false).setText(this.getLiquidXPText());
        }
        if (Loader.isModLoaded((String)"CoFHCore")) {
            this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingRF.info.title", new ItemStack(Items.field_151114_aO), -56798, false).setText("gui.tab.info.aerialInterface.interfacingRF.info");
        }
        if (((TileEntityAerialInterface)this.te).getUpgrades(1) > 0) {
            GuiAnimatedStat optionStat = this.addAnimatedStat("gui.tab.aerialInterface.feedMode", new ItemStack(Items.field_151082_bd), -13312, false);
            ArrayList<String> text = new ArrayList<String>();
            for (int i = 0; i < 4; ++i) {
                text.add("                 ");
            }
            optionStat.setTextWithoutCuttingString(text);
            GuiButtonSpecial button = new GuiButtonSpecial(1, 5, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151082_bd));
            button.setTooltipText(I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.feedFullyUtilize", (Object[])new Object[0]));
            optionStat.addWidget(button);
            this.modeButtons[0] = button;
            button = new GuiButtonSpecial(2, 30, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151034_e));
            button.setTooltipText(I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.feedWhenPossible", (Object[])new Object[0]));
            optionStat.addWidget(button);
            this.modeButtons[1] = button;
            button = new GuiButtonSpecial(3, 55, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151153_ao));
            button.setTooltipText(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.utilizeFullHealthElsePossible", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
            optionStat.addWidget(button);
            this.modeButtons[2] = button;
        } else {
            for (int i = 0; i < this.modeButtons.length; ++i) {
                this.modeButtons[i] = null;
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (((TileEntityAerialInterface)this.te).getUpgrades(1) > 0) {
            if (this.modeButtons[0] != null) {
                for (int i = 0; i < this.modeButtons.length; ++i) {
                    this.modeButtons[i].field_146124_l = ((TileEntityAerialInterface)this.te).feedMode != i;
                }
            } else {
                this.refreshScreen();
            }
        } else if (this.modeButtons[0] != null) {
            this.refreshScreen();
        }
    }

    private List<String> getLiquidXPText() {
        ArrayList<String> liquidXpText = new ArrayList<String>();
        liquidXpText.add("gui.tab.info.aerialInterface.liquidXp.info");
        for (Fluid fluid : PneumaticCraftAPIHandler.getInstance().liquidXPs.keySet()) {
            liquidXpText.add(EnumChatFormatting.DARK_AQUA + new FluidStack(fluid, 1).getLocalizedName() + " (" + fluid.getName() + ")");
        }
        return liquidXpText;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 53, 19, 0x404040);
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        return ((TileEntityAerialInterface)this.te).redstoneMode == 0 ? "gui.tab.redstoneBehaviour.button.never" : "gui.tab.redstoneBehaviour.aerialInterface.button.playerConnected";
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityAerialInterface)this.te).getPressure(ForgeDirection.UNKNOWN) > 10.0f && ((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            pressureStatText.add(EnumChatFormatting.GRAY + "Usage:");
            pressureStatText.add(EnumChatFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(1.0f, 1) + " mL/tick.");
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityAerialInterface)this.te).playerName.equals("")) {
            textList.add("\u00a77There isn't a player set!");
            textList.add(EnumChatFormatting.BLACK + "Replace the machine.");
        } else if (!((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            textList.add(EnumChatFormatting.GRAY + ((TileEntityAerialInterface)this.te).playerName + " can not be found on the server!");
            textList.add(EnumChatFormatting.BLACK + "Insists he/she comes back.");
        }
        if (textList.size() == 0) {
            textList.add("gui.tab.problems.noProblems");
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.aerialInterface.linked", (Object[])new Object[]{((TileEntityAerialInterface)this.te).playerName}));
        }
    }
}

