/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.gui.GuiButtonSpecial;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetAmadronOffer;
import pneumaticCraft.client.gui.widget.WidgetTextField;
import pneumaticCraft.client.gui.widget.WidgetVerticalScrollbar;
import pneumaticCraft.common.inventory.ContainerAmadron;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketAmadronOrderUpdate;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class GuiAmadron
extends GuiPneumaticContainerBase {
    private WidgetTextField searchBar;
    private WidgetVerticalScrollbar scrollbar;
    private int page;
    private final List<WidgetAmadronOffer> widgetOffers = new ArrayList<WidgetAmadronOffer>();
    private boolean needsRefreshing;
    private boolean hadProblem = false;
    private GuiButtonSpecial addTradeButton;

    public GuiAmadron(InventoryPlayer playerInventory) {
        super(new ContainerAmadron(playerInventory.field_70458_d), null, "pneumaticcraft:textures/gui/GuiAmadron.png");
        this.field_146999_f = 176;
        this.field_147000_g = 202;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String amadron = I18n.func_135052_a((String)"gui.amadron", (Object[])new Object[0]);
        this.addLabel(amadron, this.field_147003_i + this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(amadron) / 2, this.field_147009_r + 5);
        this.addLabel(I18n.func_135052_a((String)"gui.search", (Object[])new Object[0]), this.field_147003_i + 76 - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.search", (Object[])new Object[0])), this.field_147009_r + 41);
        this.addInfoTab(I18n.func_135052_a((String)"gui.tooltip.item.amadronTablet", (Object[])new Object[0]));
        this.addAnimatedStat("gui.tab.info.ghostSlotInteraction.title", new ItemStack((Block)Blocks.field_150438_bZ), -16733441, true).setText("gui.tab.info.ghostSlotInteraction");
        this.addAnimatedStat("gui.tab.amadron.disclaimer.title", new ItemStack(Items.field_151099_bA), -16776961, true).setText("gui.tab.amadron.disclaimer");
        this.searchBar = new WidgetTextField(this.field_146297_k.field_71466_p, this.field_147003_i + 79, this.field_147009_r + 40, 73, this.field_146297_k.field_71466_p.field_78288_b);
        this.addWidget(this.searchBar);
        this.scrollbar = new WidgetVerticalScrollbar(-1, this.field_147003_i + 156, this.field_147009_r + 54, 142);
        this.scrollbar.setStates(1);
        this.scrollbar.setListening(true);
        this.addWidget(this.scrollbar);
        List<String> tooltip = PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.amadron.button.order.tooltip", (Object[])new Object[0]), 40);
        this.addWidget(new GuiButtonSpecial(1, this.field_147003_i + 6, this.field_147009_r + 15, 72, 20, I18n.func_135052_a((String)"gui.amadron.button.order", (Object[])new Object[0])).setTooltipText(tooltip));
        this.addTradeButton = new GuiButtonSpecial(2, this.field_147003_i + 80, this.field_147009_r + 15, 72, 20, I18n.func_135052_a((String)"gui.amadron.button.addTrade", (Object[])new Object[0]));
        this.addWidget(this.addTradeButton);
        this.updateVisibleOffers();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        ContainerAmadron container = (ContainerAmadron)this.field_147002_h;
        if (this.needsRefreshing || this.page != this.scrollbar.getState()) {
            this.setPage(this.scrollbar.getState());
        }
        for (WidgetAmadronOffer offer : this.widgetOffers) {
            offer.setCanBuy(container.buyableOffers[container.offers.indexOf(offer.getOffer())]);
            offer.setShoppingAmount(container.getShoppingCartAmount(offer.getOffer()));
        }
        if (!this.hadProblem && container.problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            this.problemTab.openWindow();
        }
        this.hadProblem = container.problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS;
        this.addTradeButton.field_146124_l = container.currentOffers < container.maxOffers;
        List<String> tooltip = PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.amadron.button.addTrade.tooltip", (Object[])new Object[0]), 40);
        tooltip.add((this.addTradeButton.field_146124_l ? EnumChatFormatting.GRAY : EnumChatFormatting.RED) + I18n.func_135052_a((String)"gui.amadron.button.addTrade.tooltip.offerCount", (Object[])new Object[]{container.currentOffers, container.maxOffers == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(container.maxOffers)}));
        this.addTradeButton.setTooltipText(tooltip);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateVisibleOffers();
    }

    public void updateVisibleOffers() {
        this.needsRefreshing = false;
        final ContainerAmadron container = (ContainerAmadron)this.field_147002_h;
        int invSize = 8;
        container.clearStacks();
        List<AmadronOffer> offers = container.offers;
        ArrayList<AmadronOffer> visibleOffers = new ArrayList<AmadronOffer>();
        int skippedOffers = 0;
        int applicableOffers = 0;
        for (AmadronOffer offer : offers) {
            if (!offer.passesQuery(this.searchBar.func_146179_b())) continue;
            ++applicableOffers;
            if (skippedOffers < this.page * invSize) {
                ++skippedOffers;
                continue;
            }
            if (visibleOffers.size() >= invSize) continue;
            visibleOffers.add(offer);
        }
        this.scrollbar.setStates(Math.max(1, (applicableOffers + invSize - 1) / invSize - 1));
        this.widgets.removeAll(this.widgetOffers);
        for (int i = 0; i < visibleOffers.size(); ++i) {
            AmadronOffer offer;
            offer = (AmadronOffer)visibleOffers.get(i);
            if (offer.getInput() instanceof ItemStack) {
                container.setStack(i * 2, (ItemStack)offer.getInput());
            }
            if (offer.getOutput() instanceof ItemStack) {
                container.setStack(i * 2 + 1, (ItemStack)offer.getOutput());
            }
            WidgetAmadronOffer widget = new WidgetAmadronOffer(i, this.field_147003_i + 6 + 73 * (i % 2), this.field_147009_r + 55 + 35 * (i / 2), offer){

                @Override
                public void onMouseClicked(int mouseX, int mouseY, int button) {
                    NetworkHandler.sendToServer(new PacketAmadronOrderUpdate(container.offers.indexOf(this.getOffer()), button, PneumaticCraft.proxy.isSneakingInGui()));
                }
            };
            this.addWidget(widget);
            this.widgetOffers.add(widget);
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        super.onKeyTyped(widget);
        this.needsRefreshing = true;
        this.scrollbar.setCurrentState(0);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    protected void addProblems(List curInfo) {
        super.addProblems(curInfo);
        ContainerAmadron.EnumProblemState problemState = ((ContainerAmadron)this.field_147002_h).problemState;
        if (problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            curInfo.add(problemState.getLocalizationKey());
        }
    }
}

