/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import pneumaticCraft.client.gui.GuiButtonSpecial;
import pneumaticCraft.client.gui.GuiPneumaticScreenBase;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetTextField;
import pneumaticCraft.common.util.JsonToNBTConverter;
import pneumaticCraft.common.util.NBTToJsonConverter;
import pneumaticCraft.common.util.PastebinHandler;
import pneumaticCraft.lib.Textures;

public class GuiPastebin
extends GuiPneumaticScreenBase {
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private final String pastingString;
    public NBTTagCompound outputTag;
    private final GuiScreen parentScreen;
    public String errorMessage;
    private EnumState state = EnumState.NONE;

    public GuiPastebin(GuiScreen parentScreen, String pastingString) {
        this.xSize = 183;
        this.ySize = 202;
        this.pastingString = pastingString;
        this.parentScreen = parentScreen;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public GuiPastebin(GuiScreen parentScreen, NBTTagCompound tag) {
        this(parentScreen, new NBTToJsonConverter(tag).convert());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.field_146289_q, this.guiLeft + 10, this.guiTop + 30, 80, 10);
            this.addWidget(this.usernameBox);
            this.passwordBox = new WidgetTextField(this.field_146289_q, this.guiLeft + 10, this.guiTop + 56, 80, 10).setAsPasswordBox();
            this.addWidget(this.passwordBox);
            GuiButtonSpecial loginButton = new GuiButtonSpecial(0, this.guiLeft + 100, this.guiTop + 30, 60, 20, I18n.func_135052_a((String)"gui.pastebin.button.login", (Object[])new Object[0]));
            this.addWidget(loginButton);
            this.addLabel(I18n.func_135052_a((String)"gui.pastebin.username", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel(I18n.func_135052_a((String)"gui.pastebin.password", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            GuiButtonSpecial logoutButton = new GuiButtonSpecial(3, this.guiLeft + 60, this.guiTop + 30, 60, 20, I18n.func_135052_a((String)"gui.pastebin.button.logout", (Object[])new Object[0]));
            this.addWidget(logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this.field_146289_q, this.guiLeft + 10, this.guiTop + 130, 160, 10){

            @Override
            public void onMouseClicked(int mouseX, int mouseY, int button) {
                boolean wasFocused = this.func_146206_l();
                super.onMouseClicked(mouseX, mouseY, button);
                if (this.func_146206_l() && !wasFocused) {
                    this.func_146202_e();
                    this.func_146199_i(0);
                }
            }
        };
        this.addWidget(this.pastebinBox);
        GuiButtonSpecial pasteButton = new GuiButtonSpecial(1, this.guiLeft + 31, this.guiTop + 78, 120, 20, I18n.func_135052_a((String)"gui.pastebin.button.upload", (Object[])new Object[0]));
        this.addWidget(pasteButton);
        GuiButtonSpecial getButton = new GuiButtonSpecial(2, this.guiLeft + 31, this.guiTop + 167, 120, 20, I18n.func_135052_a((String)"gui.pastebin.button.get", (Object[])new Object[0]));
        this.addWidget(getButton);
        GuiButtonSpecial putInClipBoard = new GuiButtonSpecial(4, this.guiLeft + 8, this.guiTop + 78, 20, 20, "");
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText(I18n.func_135052_a((String)"gui.pastebin.button.copyToClipboard", (Object[])new Object[0]));
        this.addWidget(putInClipBoard);
        GuiButtonSpecial retrieveFromClipboard = new GuiButtonSpecial(5, this.guiLeft + 8, this.guiTop + 167, 20, 20, "");
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText(I18n.func_135052_a((String)"gui.pastebin.button.loadFromClipboard", (Object[])new Object[0]));
        this.addWidget(retrieveFromClipboard);
        this.addLabel(I18n.func_135052_a((String)"gui.pastebin.pastebinLink", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.func_73866_w_();
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.errorMessage = "";
            switch (this.state) {
                case GETTING: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.invalidPastebin", (Object[])new Object[0]);
                    break;
                }
                case PUTTING: {
                    if (PastebinHandler.getException() != null) {
                        this.errorMessage = PastebinHandler.getException().getMessage();
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.func_146180_a(pastebinText);
                        break;
                    }
                    this.errorMessage = pastebinText;
                    break;
                }
                case LOGIN: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.invalidLogin", (Object[])new Object[0]);
                    }
                    this.func_73866_w_();
                }
            }
            this.state = EnumState.NONE;
        }
    }

    private void readFromString(String string) {
        try {
            this.outputTag = new JsonToNBTConverter(string).convert();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.invalidFormattedPastebin", (Object[])new Object[0]);
        }
    }

    @Override
    public void func_73863_a(int x, int y, float partialTicks) {
        super.func_73863_a(x, y, partialTicks);
        if (this.errorMessage != null) {
            this.field_146289_q.func_78276_b(this.errorMessage, this.guiLeft + 5, this.guiTop + 5, -65536);
        }
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.func_147108_a(this.parentScreen);
            this.func_146281_b();
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        this.errorMessage = "";
        if (widget.getID() == 0) {
            PastebinHandler.login(this.usernameBox.func_146179_b(), this.passwordBox.func_146179_b());
            this.state = EnumState.LOGIN;
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.loggingIn", (Object[])new Object[0]);
        } else if (widget.getID() == 1) {
            PastebinHandler.put(this.pastingString);
            this.state = EnumState.PUTTING;
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.uploadingToPastebin", (Object[])new Object[0]);
        } else if (widget.getID() == 2) {
            PastebinHandler.get(this.pastebinBox.func_146179_b());
            this.state = EnumState.GETTING;
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.retrievingFromPastebin", (Object[])new Object[0]);
        } else if (widget.getID() == 3) {
            PastebinHandler.logout();
            this.state = EnumState.LOGOUT;
        } else if (widget.getID() == 4) {
            GuiScreen.func_146275_d((String)this.pastingString);
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.clipboardSetToContents", (Object[])new Object[0]);
        } else if (widget.getID() == 5) {
            this.errorMessage = I18n.func_135052_a((String)"gui.pastebin.retrievedFromClipboard", (Object[])new Object[0]);
            this.readFromString(GuiScreen.func_146277_j());
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean func_73868_f() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

