/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import codechicken.nei.VisiblityData;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import igwmod.gui.GuiWiki;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.gui.GuiButtonSpecial;
import pneumaticCraft.client.gui.GuiPastebin;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.GuiUnitProgrammer;
import pneumaticCraft.client.gui.widget.GuiCheckBox;
import pneumaticCraft.client.gui.widget.GuiRadioButton;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetTextField;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.inventory.ContainerProgrammer;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketGuiButton;
import pneumaticCraft.common.network.PacketProgrammerUpdate;
import pneumaticCraft.common.network.PacketUpdateTextfield;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetCoordinate;
import pneumaticCraft.common.progwidgets.ProgWidgetCoordinateOperator;
import pneumaticCraft.common.progwidgets.ProgWidgetStart;
import pneumaticCraft.common.progwidgets.WidgetRegistrator;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

@SideOnly(value=Side.CLIENT)
public class GuiProgrammer
extends GuiPneumaticContainerBase<TileEntityProgrammer> {
    private final EntityPlayer player;
    private GuiPastebin pastebinGui;
    private GuiButtonSpecial importButton;
    private GuiButtonSpecial exportButton;
    private GuiButtonSpecial allWidgetsButton;
    private List<GuiRadioButton> difficultyButtons;
    private GuiCheckBox showInfo;
    private GuiCheckBox showFlow;
    private WidgetTextField nameField;
    private GuiButtonSpecial undoButton;
    private GuiButtonSpecial redoButton;
    private GuiButtonSpecial convertToRelativeButton;
    private final List<IProgWidget> visibleSpawnWidgets = new ArrayList<IProgWidget>();
    private GuiUnitProgrammer programmerUnit;
    private boolean wasClicking;
    private boolean wasFocused;
    private IProgWidget draggingWidget;
    private int lastMouseX;
    private int lastMouseY;
    private int dragMouseStartX;
    private int dragMouseStartY;
    private int dragWidgetStartX;
    private int dragWidgetStartY;
    private static final int FAULT_MARGIN = 4;
    private int widgetPage;
    private int maxPage;
    private boolean showingAllWidgets;
    private int showingWidgetProgress;
    private int oldShowingWidgetProgress;
    private static final int PROGRAMMING_START_Y = 17;
    private static final int PROGRAMMING_START_X = 5;
    private static final int PROGRAMMING_WIDTH = 294;
    private static final int PROGRAMMING_HEIGHT = 154;

    public GuiProgrammer(InventoryPlayer player, TileEntityProgrammer te) {
        super(new ContainerProgrammer(player, te), te, "pneumaticcraft:textures/gui/GuiProgrammer.png");
        this.field_147000_g = 256;
        this.field_146999_f = 350;
        this.player = FMLClientHandler.instance().getClient().field_71439_g;
    }

    private void updateVisibleProgWidgets() {
        int y = 0;
        int page = 0;
        int xSpacing = 22;
        int x = 322 - this.maxPage * xSpacing;
        boolean showAllWidgets = this.showingWidgetProgress == xSpacing * this.maxPage && this.showingAllWidgets;
        this.maxPage = 0;
        this.visibleSpawnWidgets.clear();
        int difficulty = 0;
        for (int i = 0; i < this.difficultyButtons.size(); ++i) {
            if (!this.difficultyButtons.get((int)i).checked) continue;
            difficulty = i;
            break;
        }
        for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
            if (difficulty < widget.getDifficulty().ordinal()) continue;
            widget.setY(y + 40);
            widget.setX(showAllWidgets ? x : 322);
            int widgetHeight = widget.getHeight() / 2 + (widget.hasStepOutput() ? 5 : 0) + 1;
            y += widgetHeight;
            if (showAllWidgets || page == this.widgetPage) {
                this.visibleSpawnWidgets.add(widget);
            }
            if (y <= this.field_147000_g - 160) continue;
            y = 0;
            x += xSpacing;
            ++page;
            ++this.maxPage;
        }
        if (this.widgetPage > this.maxPage) {
            this.widgetPage = this.maxPage;
            this.updateVisibleProgWidgets();
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            ((TileEntityProgrammer)this.te).readProgWidgetsFromNBT(this.pastebinGui.outputTag);
            this.pastebinGui = null;
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
        }
        super.func_73866_w_();
        if (this.programmerUnit != null) {
            ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
            ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
            ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        }
        this.programmerUnit = new GuiUnitProgrammer(((TileEntityProgrammer)this.te).progWidgets, this.field_146289_q, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_146294_l, this.field_146295_m, 5, 17, 294, 154, ((TileEntityProgrammer)this.te).translatedX, ((TileEntityProgrammer)this.te).translatedY, ((TileEntityProgrammer)this.te).zoomState);
        this.addWidget(this.programmerUnit.getScrollBar());
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.importButton = new GuiButtonSpecial(1, xStart + 301, yStart + 3, 20, 15, "<--");
        this.importButton.setTooltipText("Import program");
        this.field_146292_n.add(this.importButton);
        this.exportButton = new GuiButtonSpecial(2, xStart + 301, yStart + 20, 20, 15, "-->");
        this.field_146292_n.add(this.exportButton);
        this.field_146292_n.add(new GuiButton(3, xStart + 294, yStart + 174, 10, 10, "-"));
        this.field_146292_n.add(new GuiButton(4, xStart + 335, yStart + 174, 10, 10, "+"));
        this.allWidgetsButton = new GuiButtonSpecial(8, xStart + 321, yStart + 159, 10, 10, "<");
        this.allWidgetsButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.openPanel.tooltip", (Object[])new Object[0]));
        this.addWidget(this.allWidgetsButton);
        this.difficultyButtons = new ArrayList<GuiRadioButton>();
        for (int i = 0; i < IProgWidget.WidgetDifficulty.values().length; ++i) {
            GuiRadioButton radioButton = new GuiRadioButton(i, xStart + 263, yStart + 200 + i * 12, -16777216, IProgWidget.WidgetDifficulty.values()[i].getLocalizedName());
            radioButton.checked = Config.getProgrammerDifficulty() == i;
            this.addWidget(radioButton);
            this.difficultyButtons.add(radioButton);
            radioButton.otherChoices = this.difficultyButtons;
            if (i == 1) {
                radioButton.setTooltip(I18n.func_135052_a((String)"gui.programmer.difficulty.medium.tooltip", (Object[])new Object[0]));
            }
            if (i != 2) continue;
            radioButton.setTooltip(I18n.func_135052_a((String)"gui.programmer.difficulty.advanced.tooltip", (Object[])new Object[0]));
        }
        this.field_146292_n.add(new GuiButton(5, xStart + 5, yStart + 175, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showStart", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(6, xStart + 5, yStart + 197, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showLatest", (Object[])new Object[0])));
        this.showInfo = new GuiCheckBox(-1, xStart + 5, yStart + 220, -16777216, "gui.programmer.checkbox.showInfo").setChecked(((TileEntityProgrammer)this.te).showInfo);
        this.addWidget(this.showInfo);
        this.showFlow = new GuiCheckBox(-1, xStart + 5, yStart + 232, -16777216, "gui.programmer.checkbox.showFlow").setChecked(((TileEntityProgrammer)this.te).showFlow);
        this.addWidget(this.showFlow);
        GuiButtonSpecial pastebinButton = new GuiButtonSpecial(7, this.field_147003_i - 24, this.field_147009_r + 44, 20, 20, "");
        pastebinButton.setTooltipText(I18n.func_135052_a((String)"gui.remote.button.pastebinButton", (Object[])new Object[0]));
        pastebinButton.setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        this.field_146292_n.add(pastebinButton);
        this.undoButton = new GuiButtonSpecial(9, this.field_147003_i - 24, this.field_147009_r + 2, 20, 20, "");
        this.redoButton = new GuiButtonSpecial(10, this.field_147003_i - 24, this.field_147009_r + 23, 20, 20, "");
        GuiButtonSpecial clearAllButton = new GuiButtonSpecial(11, this.field_147003_i - 24, this.field_147009_r + 65, 20, 20, "");
        this.convertToRelativeButton = new GuiButtonSpecial(12, this.field_147003_i - 24, this.field_147009_r + 86, 20, 20, "Rel");
        this.undoButton.setRenderedIcon(Textures.GUI_UNDO_ICON_LOCATION);
        this.redoButton.setRenderedIcon(Textures.GUI_REDO_ICON_LOCATION);
        clearAllButton.setRenderedIcon(Textures.GUI_DELETE_ICON_LOCATION);
        this.undoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.undoButton.tooltip", (Object[])new Object[0]));
        this.redoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.redoButton.tooltip", (Object[])new Object[0]));
        clearAllButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.clearAllButton.tooltip", (Object[])new Object[0]));
        this.field_146292_n.add(this.undoButton);
        this.field_146292_n.add(this.redoButton);
        this.field_146292_n.add(clearAllButton);
        this.field_146292_n.add(this.convertToRelativeButton);
        String containerName = ((TileEntityProgrammer)this.te).func_145818_k_() ? ((TileEntityProgrammer)this.te).func_145825_b() : StatCollector.func_74838_a((String)(((TileEntityProgrammer)this.te).func_145825_b() + ".name"));
        this.addLabel(containerName, this.field_147003_i + 7, this.field_147009_r + 5);
        this.nameField = new WidgetTextField(this.field_146289_q, this.field_147003_i + 200, this.field_147009_r + 5, 98, this.field_146289_q.field_78288_b);
        this.addWidget(this.nameField);
        String name = I18n.func_135052_a((String)"gui.programmer.name", (Object[])new Object[0]);
        this.addLabel(name, this.field_147003_i + 197 - this.field_146289_q.func_78256_a(name), this.field_147009_r + 5);
        this.updateVisibleProgWidgets();
    }

    @Override
    protected Point getInvNameOffset() {
        return null;
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        boolean igwLoaded = Loader.isModLoaded((String)"IGWMod");
        this.field_146289_q.func_78276_b(this.widgetPage + 1 + "/" + (this.maxPage + 1), 305, 175, -16777216);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.programmer.difficulty", (Object[])new Object[0]), 263, 190, -16777216);
        if (this.showingWidgetProgress == 0) {
            this.programmerUnit.renderForeground(x, y, this.draggingWidget);
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            widget.getTooltip(tooltip);
            if (igwLoaded) {
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.pressIForInfo", (Object[])new Object[0]));
            }
            if (tooltip.size() <= 0) continue;
            this.drawHoveringString(tooltip, x - this.field_147003_i, y - this.field_147009_r, this.field_146289_q);
        }
    }

    @Override
    protected void func_73869_a(char key, int keyCode) {
        IProgWidget widget;
        super.func_73869_a(key, keyCode);
        if (23 == keyCode && Loader.isModLoaded((String)"IGWMod")) {
            this.onIGWAction();
        }
        if (19 == keyCode && this.exportButton.getBounds().contains(this.lastMouseX, this.lastMouseY)) {
            NetworkHandler.sendToServer(new PacketGuiButton(0));
        }
        if (57 == keyCode) {
            this.toggleShowWidgets();
        }
        if (211 == keyCode && (widget = this.programmerUnit.getHoveredWidget(this.lastMouseX, this.lastMouseY)) != null) {
            ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
        }
        if (44 == keyCode) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.undoButton.field_146127_k));
        }
        if (21 == keyCode) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.redoButton.field_146127_k));
        }
    }

    @Optional.Method(modid="IGWMod")
    private void onIGWAction() {
        int x = this.lastMouseX;
        int y = this.lastMouseY;
        IProgWidget hoveredWidget = this.programmerUnit.getHoveredWidget(x, y);
        if (hoveredWidget != null) {
            GuiWiki gui = new GuiWiki();
            FMLClientHandler.instance().showGuiScreen((Object)gui);
            gui.setCurrentFile("pneumaticcraft:progwidget/" + hoveredWidget.getWidgetString(), new Object[0]);
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2) continue;
            GuiWiki gui = new GuiWiki();
            FMLClientHandler.instance().showGuiScreen((Object)gui);
            gui.setCurrentFile("pneumaticcraft:progwidget/" + widget.getWidgetString(), new Object[0]);
        }
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected void func_146976_a(float partialTicks, int x, int y) {
        IProgWidget widget;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiProgrammer.func_146110_a((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
        this.programmerUnit.getScrollBar().setEnabled(this.showingWidgetProgress == 0);
        super.func_146976_a(partialTicks, x, y);
        if (this.showingWidgetProgress > 0) {
            this.programmerUnit.getScrollBar().setCurrentState(this.programmerUnit.getLastZoom());
        }
        this.programmerUnit.render(x, y, this.showFlow.checked, this.showInfo.checked && this.showingWidgetProgress == 0, this.draggingWidget == null);
        int origX = x;
        int origY = y;
        x -= this.programmerUnit.getTranslatedX();
        y -= this.programmerUnit.getTranslatedY();
        float scale = this.programmerUnit.getScale();
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        if (this.showingWidgetProgress > 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int width = this.oldShowingWidgetProgress + (int)((float)(this.showingWidgetProgress - this.oldShowingWidgetProgress) * partialTicks);
            for (int i = 0; i < width; ++i) {
                GuiProgrammer.func_146110_a((int)(xStart + 320 - i), (int)(yStart + 36), (float)323.0f, (float)36.0f, (int)1, (int)136, (float)this.field_146999_f, (float)this.field_147000_g);
            }
            GuiProgrammer.func_146110_a((int)(xStart + 319 - width), (int)(yStart + 36), (float)319.0f, (float)36.0f, (int)2, (int)136, (float)this.field_146999_f, (float)this.field_147000_g);
            if (this.showingAllWidgets && this.draggingWidget != null) {
                this.toggleShowWidgets();
            }
        }
        GL11.glEnable((int)3553);
        for (IProgWidget widget2 : this.visibleSpawnWidgets) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(widget2.getX() + this.field_147003_i), (double)(widget2.getY() + this.field_147009_r), (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            widget2.render();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.programmerUnit.getTranslatedX(), (double)this.programmerUnit.getTranslatedY(), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        if (this.draggingWidget != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.draggingWidget.getX() + this.field_147003_i), (double)(this.draggingWidget.getY() + this.field_147009_r), (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            this.draggingWidget.render();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        boolean isLeftClicking = Mouse.isButtonDown((int)0);
        boolean isMiddleClicking = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74322_I);
        if (this.draggingWidget != null) {
            this.setConnectingWidgetsToXY(this.draggingWidget, x - this.dragMouseStartX + this.dragWidgetStartX - this.field_147003_i, y - this.dragMouseStartY + this.dragWidgetStartY - this.field_147009_r);
        }
        if (isLeftClicking && !this.wasClicking) {
            IProgWidget widget3;
            for (IProgWidget widget4 : this.visibleSpawnWidgets) {
                if (origX < widget4.getX() + this.field_147003_i || origY < widget4.getY() + this.field_147009_r || origX > widget4.getX() + this.field_147003_i + widget4.getWidth() / 2 || origY > widget4.getY() + this.field_147009_r + widget4.getHeight() / 2) continue;
                this.draggingWidget = widget4.copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                this.dragMouseStartX = x - (int)((float)this.field_147003_i / scale);
                this.dragMouseStartY = y - (int)((float)this.field_147009_r / scale);
                this.dragWidgetStartX = (int)((float)(widget4.getX() - this.programmerUnit.getTranslatedX()) / scale);
                this.dragWidgetStartY = (int)((float)(widget4.getY() - this.programmerUnit.getTranslatedY()) / scale);
                break;
            }
            if (this.draggingWidget == null && this.showingWidgetProgress == 0 && (widget3 = this.programmerUnit.getHoveredWidget(origX, origY)) != null) {
                this.draggingWidget = widget3;
                this.dragMouseStartX = x - this.field_147003_i;
                this.dragMouseStartY = y - this.field_147009_r;
                this.dragWidgetStartX = widget3.getX();
                this.dragWidgetStartY = widget3.getY();
            }
        } else if (isMiddleClicking && !this.wasClicking && this.showingWidgetProgress == 0 && (widget = this.programmerUnit.getHoveredWidget(origX, origY)) != null) {
            this.draggingWidget = widget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
            this.dragMouseStartX = 0;
            this.dragMouseStartY = 0;
            this.dragWidgetStartX = widget.getX() - (x - this.field_147003_i);
            this.dragWidgetStartY = widget.getY() - (y - this.field_147009_r);
            if (PneumaticCraft.proxy.isSneakingInGui()) {
                this.copyAndConnectConnectingWidgets(widget, this.draggingWidget);
            }
        }
        if (!isLeftClicking && !isMiddleClicking && this.draggingWidget != null) {
            if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                this.deleteConnectingWidgets(this.draggingWidget);
            } else {
                this.handlePuzzleMargins();
                if (!this.isValidPlaced(this.draggingWidget)) {
                    this.setConnectingWidgetsToXY(this.draggingWidget, this.dragWidgetStartX, this.dragWidgetStartY);
                    if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                        this.deleteConnectingWidgets(this.draggingWidget);
                    }
                }
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            this.draggingWidget = null;
        }
        this.wasClicking = isLeftClicking || isMiddleClicking;
        this.lastMouseX = origX;
        this.lastMouseY = origY;
    }

    private boolean isValidPlaced(IProgWidget widget1) {
        IProgWidget iProgWidget;
        Rectangle draggingRect = new Rectangle(widget1.getX(), widget1.getY(), widget1.getWidth() / 2, widget1.getHeight() / 2);
        for (IProgWidget iProgWidget2 : ((TileEntityProgrammer)this.te).progWidgets) {
            if (iProgWidget2 == widget1 || !draggingRect.intersects(iProgWidget2.getX(), iProgWidget2.getY(), iProgWidget2.getWidth() / 2, iProgWidget2.getHeight() / 2)) continue;
            return false;
        }
        IProgWidget[] parameters = widget1.getConnectedParameters();
        if (parameters != null) {
            for (IProgWidget widget : parameters) {
                if (widget == null || this.isValidPlaced(widget)) continue;
                return false;
            }
        }
        return (iProgWidget = widget1.getOutputWidget()) == null || this.isValidPlaced(iProgWidget);
    }

    private void handlePuzzleMargins() {
        Class<? extends IProgWidget>[] parameters;
        Class<? extends IProgWidget> returnValue = this.draggingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                Class<? extends IProgWidget>[] parameters2;
                if (widget == this.draggingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - this.draggingWidget.getX()) > 4 || (parameters2 = widget.getParameters()) == null) continue;
                for (int i = 0; i < parameters2.length; ++i) {
                    if (!widget.canSetParameter(i) || parameters2[i] != returnValue || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if ((parameters = this.draggingWidget.getParameters()) != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                IProgWidget outerPiece = this.draggingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == this.draggingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        if (!this.draggingWidget.canSetParameter(i) || parameters[i] != widget.returnType() || Math.abs(this.draggingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                Class<? extends IProgWidget>[] checkingPieceParms = widget.getParameters();
                if (checkingPieceParms == null) continue;
                for (int i = 0; i < checkingPieceParms.length; ++i) {
                    if (!widget.canSetParameter(i + parameters.length) || checkingPieceParms[i] != parameters[0] || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() + i * 11);
                }
            }
        }
        if (this.draggingWidget.hasStepInput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - this.draggingWidget.getY()) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (this.draggingWidget.hasStepOutput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() - this.draggingWidget.getY() - this.draggingWidget.getHeight() / 2) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() - this.draggingWidget.getHeight() / 2);
            }
        }
    }

    private void setConnectingWidgetsToXY(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setX(x);
        widget.setY(y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    this.setConnectingWidgetsToXY(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                this.setConnectingWidgetsToXY(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.setConnectingWidgetsToXY(outputWidget, x, y + widget.getHeight() / 2);
        }
    }

    private void copyAndConnectConnectingWidgets(IProgWidget original, IProgWidget copy) {
        IProgWidget outputWidget;
        IProgWidget c;
        IProgWidget[] connectingWidgets = original.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                c = connectingWidgets[i].copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(c);
                copy.setParameter(i, c);
                this.copyAndConnectConnectingWidgets(connectingWidgets[i], c);
            }
        }
        if ((outputWidget = original.getOutputWidget()) != null) {
            c = outputWidget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(c);
            copy.setOutputWidget(c);
            this.copyAndConnectConnectingWidgets(outputWidget, c);
        }
    }

    private void deleteConnectingWidgets(IProgWidget widget) {
        IProgWidget outputWidget;
        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (IProgWidget widg : connectingWidgets) {
                if (widg == null) continue;
                this.deleteConnectingWidgets(widg);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.deleteConnectingWidgets(outputWidget);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        block0 : switch (button.field_146127_k) {
            case 0: {
                break;
            }
            case 3: {
                if (--this.widgetPage < 0) {
                    this.widgetPage = this.maxPage;
                }
                this.updateVisibleProgWidgets();
                return;
            }
            case 4: {
                if (++this.widgetPage > this.maxPage) {
                    this.widgetPage = 0;
                }
                this.updateVisibleProgWidgets();
                return;
            }
            case 5: {
                for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                    if (!(widget instanceof ProgWidgetStart)) continue;
                    this.programmerUnit.gotoPiece(widget);
                    break;
                }
                return;
            }
            case 6: {
                if (((TileEntityProgrammer)this.te).progWidgets.size() > 0) {
                    this.programmerUnit.gotoPiece(((TileEntityProgrammer)this.te).progWidgets.get(((TileEntityProgrammer)this.te).progWidgets.size() - 1));
                }
                return;
            }
            case 7: {
                NBTTagCompound mainTag = new NBTTagCompound();
                ((TileEntityProgrammer)this.te).writeProgWidgetsToNBT(mainTag);
                this.pastebinGui = new GuiPastebin((GuiScreen)this, mainTag);
                FMLClientHandler.instance().showGuiScreen((Object)this.pastebinGui);
                break;
            }
            case 11: {
                ((TileEntityProgrammer)this.te).progWidgets.clear();
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                break;
            }
            case 12: {
                for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                    if (!(widget instanceof ProgWidgetStart)) continue;
                    this.generateRelativeOperators((ProgWidgetCoordinateOperator)widget.getOutputWidget(), null, false);
                    break block0;
                }
                break;
            }
        }
        NetworkHandler.sendToServer(new PacketGuiButton(button.field_146127_k));
    }

    private void toggleShowWidgets() {
        this.showingAllWidgets = !this.showingAllWidgets;
        this.allWidgetsButton.field_146126_j = this.showingAllWidgets ? ">" : "<";
        this.updateVisibleProgWidgets();
    }

    @Override
    public void actionPerformed(IGuiWidget button) {
        if (button == this.allWidgetsButton) {
            this.toggleShowWidgets();
        } else {
            for (int i = 0; i < this.difficultyButtons.size(); ++i) {
                if (!this.difficultyButtons.get((int)i).checked) continue;
                Config.setProgrammerDifficulty(i);
                break;
            }
            if (this.showingAllWidgets) {
                this.toggleShowWidgets();
            }
            this.updateVisibleProgWidgets();
        }
    }

    @Override
    public void func_73876_c() {
        boolean isDeviceInserted;
        super.func_73876_c();
        this.undoButton.field_146124_l = ((TileEntityProgrammer)this.te).canUndo;
        this.redoButton.field_146124_l = ((TileEntityProgrammer)this.te).canRedo;
        this.updateConvertRelativeState();
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).func_70301_a(0);
        this.oldShowingWidgetProgress = this.showingWidgetProgress;
        if (this.showingAllWidgets) {
            int maxProgress = this.maxPage * 22;
            if (this.showingWidgetProgress < maxProgress) {
                this.showingWidgetProgress += 30;
                if (this.showingWidgetProgress >= maxProgress) {
                    this.showingWidgetProgress = maxProgress;
                    this.updateVisibleProgWidgets();
                }
            }
        } else {
            this.showingWidgetProgress -= 30;
            if (this.showingWidgetProgress < 0) {
                this.showingWidgetProgress = 0;
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        for (IProgWidget w : ((TileEntityProgrammer)this.te).progWidgets) {
            w.addErrors(errors, ((TileEntityProgrammer)this.te).progWidgets);
            w.addWarnings(warnings, ((TileEntityProgrammer)this.te).progWidgets);
        }
        this.importButton.field_146124_l = isDeviceInserted = programmedItem != null;
        this.exportButton.field_146124_l = isDeviceInserted && errors.size() == 0;
        ArrayList<String> exportButtonTooltip = new ArrayList<String>();
        exportButtonTooltip.add("Export program");
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.programmingWhen", (Object[])new Object[]{I18n.func_135052_a((String)("gui.programmer.button.export." + (((TileEntityProgrammer)this.te).redstoneMode == 0 ? "pressingButton" : "onItemInsert")), (Object[])new Object[0])}));
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.pressRToChange", (Object[])new Object[0]));
        if (programmedItem != null) {
            List<ItemStack> requiredPieces = ((TileEntityProgrammer)this.te).getRequiredPuzzleStacks();
            List<ItemStack> returnedPieces = ((TileEntityProgrammer)this.te).getReturnedPuzzleStacks();
            if (!requiredPieces.isEmpty() || !returnedPieces.isEmpty()) {
                exportButtonTooltip.add("");
            }
            if (!requiredPieces.isEmpty()) {
                exportButtonTooltip.add("Required Programming Puzzles:");
                if (this.player.field_71075_bZ.field_75098_d) {
                    exportButtonTooltip.add("(Creative mode, so the following is free)");
                }
                for (ItemStack stack : requiredPieces) {
                    String prefix;
                    if (((TileEntityProgrammer)this.te).hasEnoughPuzzleStacks(this.player, stack)) {
                        prefix = EnumChatFormatting.GREEN.toString();
                    } else {
                        prefix = EnumChatFormatting.RED.toString();
                        this.exportButton.field_146124_l = this.player.field_71075_bZ.field_75098_d && errors.size() == 0;
                    }
                    exportButtonTooltip.add(prefix + "-" + stack.field_77994_a + "x " + stack.func_82833_r());
                }
            }
            if (!returnedPieces.isEmpty()) {
                exportButtonTooltip.add("Returned Programming Puzzles:");
                if (this.player.field_71075_bZ.field_75098_d) {
                    exportButtonTooltip.add("(Creative mode, nothing's given)");
                }
                for (ItemStack stack : returnedPieces) {
                    exportButtonTooltip.add("-" + stack.field_77994_a + "x " + stack.func_82833_r());
                }
            }
        } else {
            exportButtonTooltip.add("No programmable item inserted.");
        }
        if (errors.size() > 0) {
            exportButtonTooltip.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"gui.programmer.errorCount", (Object[])new Object[]{errors.size()}));
        }
        if (warnings.size() > 0) {
            exportButtonTooltip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.programmer.warningCount", (Object[])new Object[]{warnings.size()}));
        }
        this.exportButton.setTooltipText(exportButtonTooltip);
        if (programmedItem != null) {
            this.nameField.func_146184_c(true);
            if (!this.nameField.func_146206_l()) {
                if (this.wasFocused) {
                    programmedItem.func_151001_c(this.nameField.func_146179_b());
                    NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
                }
                this.nameField.func_146180_a(programmedItem.func_82833_r());
                this.wasFocused = false;
            } else {
                this.wasFocused = true;
            }
        } else {
            this.nameField.func_146184_c(false);
            this.nameField.func_146180_a("");
            this.wasFocused = false;
        }
    }

    private void updateConvertRelativeState() {
        this.convertToRelativeButton.field_146124_l = false;
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("gui.programmer.button.convertToRelative.desc");
        boolean startFound = false;
        for (IProgWidget startWidget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(startWidget instanceof ProgWidgetStart)) continue;
            startFound = true;
            IProgWidget widget = startWidget.getOutputWidget();
            if (widget instanceof ProgWidgetCoordinateOperator) {
                ProgWidgetCoordinateOperator operatorWidget = (ProgWidgetCoordinateOperator)widget;
                if (!operatorWidget.getVariable().equals("")) {
                    try {
                        if (this.generateRelativeOperators(operatorWidget, tooltip, true)) {
                            this.convertToRelativeButton.field_146124_l = true;
                            continue;
                        }
                        tooltip.add("gui.programmer.button.convertToRelative.notEnoughRoom");
                    }
                    catch (NullPointerException e) {
                        tooltip.add("gui.programmer.button.convertToRelative.cantHaveVariables");
                    }
                    continue;
                }
                tooltip.add("gui.programmer.button.convertToRelative.noVariableName");
                continue;
            }
            tooltip.add("gui.programmer.button.convertToRelative.noBaseCoordinate");
        }
        if (!startFound) {
            tooltip.add("gui.programmer.button.convertToRelative.noStartPiece");
        }
        ArrayList<String> localizedTooltip = new ArrayList<String>();
        for (String s : tooltip) {
            localizedTooltip.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)s, (Object[])new Object[0]), 40));
        }
        this.convertToRelativeButton.setTooltipText(localizedTooltip);
    }

    private boolean generateRelativeOperators(ProgWidgetCoordinateOperator baseWidget, List<String> tooltip, boolean simulate) {
        ChunkPosition baseCoord = ProgWidgetCoordinateOperator.calculateCoordinate(baseWidget, 0, baseWidget.getOperator());
        HashMap<ChunkPosition, String> offsetToVariableNames = new HashMap<ChunkPosition, String>();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            ProgWidgetCoordinate coordinate;
            if (widget instanceof ProgWidgetArea) {
                String var;
                ChunkPosition offset;
                ProgWidgetArea area = (ProgWidgetArea)widget;
                if (area.getCoord1Variable().equals("") && (area.x1 != 0 || area.y1 != 0 || area.z1 != 0)) {
                    offset = new ChunkPosition(area.x1 - baseCoord.field_151329_a, area.y1 - baseCoord.field_151327_b, area.z1 - baseCoord.field_151328_c);
                    var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                    if (!simulate) {
                        area.setCoord1Variable(var);
                    }
                }
                if (!area.getCoord2Variable().equals("") || area.x2 == 0 && area.y2 == 0 && area.z2 == 0) continue;
                offset = new ChunkPosition(area.x2 - baseCoord.field_151329_a, area.y2 - baseCoord.field_151327_b, area.z2 - baseCoord.field_151328_c);
                var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                if (simulate) continue;
                area.setCoord2Variable(var);
                continue;
            }
            if (!(widget instanceof ProgWidgetCoordinate) || baseWidget.getConnectedParameters()[0] == widget || (coordinate = (ProgWidgetCoordinate)widget).isUsingVariable()) continue;
            ChunkPosition c = coordinate.getCoordinate();
            String chunkString = "(" + c.field_151329_a + ", " + c.field_151327_b + ", " + c.field_151328_c + ")";
            if (PneumaticCraftUtils.distBetween(c, 0.0, 0.0, 0.0) < 64.0) {
                if (tooltip == null) continue;
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsNotChangedWarning", (Object[])new Object[]{chunkString}));
                continue;
            }
            if (tooltip != null) {
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsChangedWarning", (Object[])new Object[]{chunkString}));
            }
            if (simulate) continue;
            ChunkPosition offset = new ChunkPosition(c.field_151329_a - baseCoord.field_151329_a, c.field_151327_b - baseCoord.field_151327_b, c.field_151328_c - baseCoord.field_151328_c);
            String var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
            if (simulate) continue;
            coordinate.setVariable(var);
            coordinate.setUsingVariable(true);
        }
        if (offsetToVariableNames.size() > 0) {
            ProgWidgetCoordinateOperator firstOperator = null;
            ProgWidgetCoordinateOperator prevOperator = baseWidget;
            int x = baseWidget.getX();
            for (Map.Entry entry : offsetToVariableNames.entrySet()) {
                ProgWidgetCoordinateOperator operator = new ProgWidgetCoordinateOperator();
                operator.setVariable((String)entry.getValue());
                int y = prevOperator.getY() + prevOperator.getHeight() / 2;
                operator.setX(x);
                operator.setY(y);
                if (!this.isValidPlaced(operator)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece1 = new ProgWidgetCoordinate();
                coordinatePiece1.setX(x + prevOperator.getWidth() / 2);
                coordinatePiece1.setY(y);
                coordinatePiece1.setVariable(baseWidget.getVariable());
                coordinatePiece1.setUsingVariable(true);
                if (!this.isValidPlaced(coordinatePiece1)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece2 = new ProgWidgetCoordinate();
                coordinatePiece2.setX(x + prevOperator.getWidth() / 2 + coordinatePiece1.getWidth() / 2);
                coordinatePiece2.setY(y);
                coordinatePiece2.setCoordinate((ChunkPosition)entry.getKey());
                if (!this.isValidPlaced(coordinatePiece2)) {
                    return false;
                }
                if (!simulate) {
                    ((TileEntityProgrammer)this.te).progWidgets.add(operator);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece1);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece2);
                }
                if (firstOperator == null) {
                    firstOperator = operator;
                }
                prevOperator = operator;
            }
            if (!simulate) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            }
            return true;
        }
        return true;
    }

    private String getOffsetVariable(Map<ChunkPosition, String> offsetToVariableNames, String baseVariable, ChunkPosition offset) {
        if (offset.equals((Object)new ChunkPosition(0, 0, 0))) {
            return baseVariable;
        }
        String var = offsetToVariableNames.get(offset);
        if (var == null) {
            var = "var" + (offsetToVariableNames.size() + 1);
            offsetToVariableNames.put(offset, var);
        }
        return var;
    }

    @Override
    protected void func_73864_a(int x, int y, int par3) {
        GuiScreen screen;
        IProgWidget widget;
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).func_70301_a(0);
        if (this.nameField.func_146206_l() && programmedItem != null) {
            programmedItem.func_151001_c(this.nameField.func_146179_b());
            NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
        }
        super.func_73864_a(x, y, par3);
        if (par3 == 1 && this.showingWidgetProgress == 0 && (widget = this.programmerUnit.getHoveredWidget(x, y)) != null && (screen = widget.getOptionWindow(this)) != null) {
            this.field_146297_k.func_147108_a(screen);
        }
    }

    public void func_146281_b() {
        ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
        ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
        ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        ((TileEntityProgrammer)this.te).showFlow = this.showFlow.checked;
        ((TileEntityProgrammer)this.te).showInfo = this.showInfo.checked;
        super.func_146281_b();
    }

    @Override
    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showNEI = false;
        return currentVisibility;
    }
}

