/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import cpw.mods.fml.common.Loader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.gui.widget.WidgetVerticalScrollbar;
import pneumaticCraft.common.progwidgets.IJump;
import pneumaticCraft.common.progwidgets.ILabel;
import pneumaticCraft.common.progwidgets.IProgWidget;

public class GuiUnitProgrammer
extends GuiScreen {
    private final FontRenderer fontRendererObj;
    private final List<IProgWidget> progWidgets;
    private final int guiLeft;
    private final int guiTop;
    private final int startX;
    private final int startY;
    private final int areaWidth;
    private final int areaHeight;
    private final int xSize;
    private int translatedX;
    private int translatedY;
    private int lastMouseX;
    private int lastMouseY;
    private int lastZoom;
    private boolean wasClicking;
    private final WidgetVerticalScrollbar scaleScroll;
    private static final float SCALE_PER_STEP = 0.2f;

    public GuiUnitProgrammer(List<IProgWidget> progWidgets, FontRenderer fontRendererObj, int guiLeft, int guiTop, int width, int height, int xSize, int startX, int startY, int areaWidth, int areaHeight, int translatedX, int translatedY, int lastZoom) {
        this.fontRendererObj = fontRendererObj;
        this.progWidgets = progWidgets;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.field_146294_l = width;
        this.field_146295_m = height;
        this.xSize = xSize;
        this.startX = startX;
        this.startY = startY;
        this.areaWidth = areaWidth;
        this.areaHeight = areaHeight;
        this.translatedX = translatedX;
        this.translatedY = translatedY;
        this.lastZoom = lastZoom;
        this.scaleScroll = new WidgetVerticalScrollbar(guiLeft + 302, guiTop + 40, 129).setStates(9).setCurrentState(lastZoom).setListening(true);
    }

    public WidgetVerticalScrollbar getScrollBar() {
        return this.scaleScroll;
    }

    public int getLastZoom() {
        return this.lastZoom;
    }

    public int getTranslatedX() {
        return this.translatedX;
    }

    public int getTranslatedY() {
        return this.translatedY;
    }

    public void renderForeground(int x, int y, IProgWidget tooltipExcludingWidget) {
        IProgWidget widget = this.getHoveredWidget(x, y);
        if (widget != null && widget != tooltipExcludingWidget) {
            ArrayList<String> tooltip = new ArrayList<String>();
            widget.getTooltip(tooltip);
            ArrayList<String> errors = new ArrayList<String>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                tooltip.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"gui.programmer.errors", (Object[])new Object[0]));
                for (String s : errors) {
                    String[] lines;
                    for (String line : lines = WordUtils.wrap((String)("-" + I18n.func_135052_a((String)s, (Object[])new Object[0])), (int)30).split(System.getProperty("line.separator"))) {
                        tooltip.add(EnumChatFormatting.RED + "   " + line);
                    }
                }
            }
            ArrayList<String> warnings = new ArrayList<String>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() > 0) {
                tooltip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.programmer.warnings", (Object[])new Object[0]));
                for (String s : warnings) {
                    String[] lines;
                    for (String line : lines = WordUtils.wrap((String)("-" + I18n.func_135052_a((String)s, (Object[])new Object[0])), (int)30).split(System.getProperty("line.separator"))) {
                        tooltip.add(EnumChatFormatting.YELLOW + "   " + line);
                    }
                }
            }
            this.addAdditionalInfoToTooltip(widget, tooltip);
            if (tooltip.size() > 0) {
                this.drawHoveringText(tooltip, x - this.guiLeft, y - this.guiTop, this.fontRendererObj);
            }
        }
    }

    public IProgWidget getHoveredWidget(int x, int y) {
        float scale = this.getScale();
        for (IProgWidget widget : this.progWidgets) {
            if (this.isOutsideProgrammingArea(widget) || !((float)(x - this.translatedX) / scale - (float)this.guiLeft >= (float)widget.getX()) || !((float)(y - this.translatedY) / scale - (float)this.guiTop >= (float)widget.getY()) || !((float)(x - this.translatedX) / scale - (float)this.guiLeft <= (float)(widget.getX() + widget.getWidth() / 2)) || !((float)(y - this.translatedY) / scale - (float)this.guiTop <= (float)(widget.getY() + widget.getHeight() / 2))) continue;
            return widget;
        }
        return null;
    }

    protected void addAdditionalInfoToTooltip(IProgWidget widget, List<String> tooltip) {
        if (widget.getOptionWindow(null) != null) {
            tooltip.add(EnumChatFormatting.GOLD + "Right click for options");
        }
        if (Loader.isModLoaded((String)"IGWMod")) {
            tooltip.add(I18n.func_135052_a((String)"gui.programmer.pressIForInfo", (Object[])new Object[0]));
        }
    }

    public void render(int x, int y, boolean showFlow, boolean showInfo, boolean translate) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int origX = x;
        int origY = y;
        x -= this.translatedX;
        y -= this.translatedY;
        float scale = this.getScale();
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        if (this.scaleScroll.getState() != this.lastZoom) {
            float shift = 0.2f * (float)(this.scaleScroll.getState() - this.lastZoom);
            if (new Rectangle(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).contains(origX, origY)) {
                this.translatedX = (int)((float)this.translatedX + shift * (float)x);
                this.translatedY = (int)((float)this.translatedY + shift * (float)y);
            } else {
                this.translatedX = (int)((float)this.translatedX + (float)(this.areaWidth / 2) * shift);
                this.translatedY = (int)((float)this.translatedY + (float)(this.areaHeight / 2) * shift);
            }
        }
        this.lastZoom = this.scaleScroll.getState();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        GL11.glScissor((int)((this.guiLeft + this.startX) * sr.func_78325_e()), (int)((sr.func_78328_b() - this.areaHeight - (this.guiTop + this.startY)) * sr.func_78325_e()), (int)(this.areaWidth * sr.func_78325_e()), (int)(this.areaHeight * sr.func_78325_e()));
        GL11.glEnable((int)3089);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.translatedX, (double)this.translatedY, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        if (showFlow) {
            this.showFlow();
        }
        GL11.glEnable((int)3553);
        for (IProgWidget widget : this.progWidgets) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            widget.render();
            GL11.glPopMatrix();
        }
        for (IProgWidget widget : this.progWidgets) {
            ArrayList<String> errors = new ArrayList<String>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                this.drawBorder(widget, -65536);
                continue;
            }
            ArrayList<String> warnings = new ArrayList<String>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() <= 0) continue;
            this.drawBorder(widget, -256);
        }
        this.renderAdditionally();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        if (showInfo) {
            for (IProgWidget widget : this.progWidgets) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                widget.renderExtraInfo();
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
        boolean isLeftClicking = Mouse.isButtonDown((int)0);
        if (translate && isLeftClicking && this.wasClicking && new Rectangle(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).contains(origX, origY)) {
            this.translatedX += origX - this.lastMouseX;
            this.translatedY += origY - this.lastMouseY;
        }
        this.wasClicking = isLeftClicking;
        this.lastMouseX = origX;
        this.lastMouseY = origY;
    }

    protected void renderAdditionally() {
    }

    protected void drawBorder(IProgWidget widget, int color) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
        GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
        this.func_73728_b(0, 0, widget.getHeight(), color);
        this.func_73728_b(widget.getWidth(), 0, widget.getHeight(), color);
        this.func_73730_a(widget.getWidth(), 0, 0, color);
        this.func_73730_a(widget.getWidth(), 0, widget.getHeight(), color);
        GL11.glPopMatrix();
    }

    private void showFlow() {
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        for (IProgWidget widget : this.progWidgets) {
            List<String> jumpLocations;
            if (!(widget instanceof IJump) || (jumpLocations = ((IJump)((Object)widget)).getPossibleJumpLocations()) == null) continue;
            for (String jumpLocation : jumpLocations) {
                if (jumpLocation == null) continue;
                for (IProgWidget w : this.progWidgets) {
                    String label;
                    if (!(w instanceof ILabel) || (label = ((ILabel)((Object)w)).getLabel()) == null || !jumpLocation.equals(label)) continue;
                    int x1 = widget.getX() + widget.getWidth() / 4;
                    int y1 = widget.getY() + widget.getHeight() / 4;
                    int x2 = w.getX() + w.getWidth() / 4;
                    int y2 = w.getY() + w.getHeight() / 4;
                    double midX = (double)(x2 + x1) / 2.0;
                    double midY = (double)(y2 + y1) / 2.0;
                    GL11.glVertex3d((double)(this.guiLeft + x1), (double)(this.guiTop + y1), (double)this.field_73735_i);
                    GL11.glVertex3d((double)(this.guiLeft + x2), (double)(this.guiTop + y2), (double)this.field_73735_i);
                    Vec3 arrowVec = Vec3.func_72443_a((double)(x1 - x2), (double)(y1 - y2), (double)0.0).func_72432_b();
                    float arrowAngle = (float)Math.toRadians(30.0);
                    float arrowSize = 5.0f;
                    arrowVec.field_72450_a *= (double)arrowSize;
                    arrowVec.field_72448_b *= (double)arrowSize;
                    arrowVec.func_72446_c(arrowAngle);
                    GL11.glVertex3d((double)((double)this.guiLeft + midX), (double)((double)this.guiTop + midY), (double)this.field_73735_i);
                    GL11.glVertex3d((double)((double)this.guiLeft + midX + arrowVec.field_72450_a), (double)((double)this.guiTop + midY + arrowVec.field_72448_b), (double)this.field_73735_i);
                    arrowVec.func_72446_c(-2.0f * arrowAngle);
                    GL11.glVertex3d((double)((double)this.guiLeft + midX), (double)((double)this.guiTop + midY), (double)this.field_73735_i);
                    GL11.glVertex3d((double)((double)this.guiLeft + midX + arrowVec.field_72450_a), (double)((double)this.guiTop + midY + arrowVec.field_72448_b), (double)this.field_73735_i);
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public float getScale() {
        return 2.0f - (float)this.scaleScroll.getState() * 0.2f;
    }

    public boolean isOutsideProgrammingArea(IProgWidget widget) {
        float scale = this.getScale();
        int x = (int)((float)(widget.getX() + this.guiLeft) * scale);
        int y = (int)((float)(widget.getY() + this.guiTop) * scale);
        return (x += this.translatedX - this.guiLeft) < this.startX || (float)x + (float)widget.getWidth() * scale / 2.0f > (float)(this.startX + this.areaWidth) || (y += this.translatedY - this.guiTop) < this.startY || (float)y + (float)widget.getHeight() * scale / 2.0f > (float)(this.startY + this.areaHeight);
    }

    public void gotoPiece(IProgWidget widget) {
        this.scaleScroll.currentScroll = 0.0f;
        this.lastZoom = 0;
        this.translatedX = -widget.getX() * 2 + this.areaWidth / 2 - this.guiLeft;
        this.translatedY = -widget.getY() * 2 + this.areaHeight / 2 - this.guiTop;
    }
}

