/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.pneumaticHelmet;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import pneumaticCraft.api.client.pneumaticHelmet.IGuiScreen;
import pneumaticCraft.api.client.pneumaticHelmet.IOptionPage;
import pneumaticCraft.client.render.pneumaticArmor.ArmorMessage;
import pneumaticCraft.client.render.pneumaticArmor.CoordTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;

@SideOnly(value=Side.CLIENT)
public class GuiCoordinateTrackerOptions
implements IOptionPage {
    private GuiButton wirePath;
    private GuiButton pathEnabled;
    private GuiButton xRayEnabled;
    private GuiButton pathUpdateRate;

    @Override
    public String getPageName() {
        return "Coordinate Tracker Upgrade";
    }

    @Override
    public void initGui(IGuiScreen gui) {
        gui.getButtonList().add(new GuiButton(10, 30, 40, 150, 20, "Select Target..."));
        gui.getButtonList().add(new GuiButton(11, 30, 62, 150, 20, "Navigate to Surface..."));
        this.pathEnabled = new GuiButton(12, 30, 128, 150, 20, "");
        this.wirePath = new GuiButton(13, 30, 150, 150, 20, "");
        this.xRayEnabled = new GuiButton(14, 30, 172, 150, 20, "");
        this.pathUpdateRate = new GuiButton(15, 30, 194, 150, 20, "");
        gui.getButtonList().add(this.pathEnabled);
        gui.getButtonList().add(this.wirePath);
        gui.getButtonList().add(this.xRayEnabled);
        gui.getButtonList().add(this.pathUpdateRate);
        this.updateButtonTexts();
    }

    @Override
    public void actionPerformed(GuiButton button) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        CoordTrackUpgradeHandler coordHandler = HUDHandler.instance().getSpecificRenderer(CoordTrackUpgradeHandler.class);
        switch (button.field_146127_k) {
            case 10: {
                mc.func_147108_a((GuiScreen)null);
                mc.func_71381_h();
                coordHandler.isListeningToCoordTrackerSetting = true;
                HUDHandler.instance().addMessage(new ArmorMessage("Changing Coordinate Tracker coordinate...", Arrays.asList("Right-click the desired coordinate"), 90, 0x7000AA00));
                break;
            }
            case 11: {
                mc.func_147108_a((GuiScreen)null);
                mc.func_71381_h();
                switch (coordHandler.navigateToSurface((EntityPlayer)mc.field_71439_g)) {
                    case EASY_PATH: {
                        HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.coordinateTracker.routeFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 0x7000AA00));
                        break;
                    }
                    case DRONE_PATH: {
                        HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.coordinateTracker.harderRouteFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 1883548160));
                        break;
                    }
                    case NO_PATH: {
                        HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.coordinateTracker.noRouteFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 0x70FF0000));
                    }
                }
                break;
            }
            case 12: {
                coordHandler.pathEnabled = !coordHandler.pathEnabled;
                break;
            }
            case 13: {
                coordHandler.wirePath = !coordHandler.wirePath;
                break;
            }
            case 14: {
                coordHandler.xRayEnabled = !coordHandler.xRayEnabled;
                break;
            }
            case 15: {
                ++coordHandler.pathUpdateSetting;
                if (coordHandler.pathUpdateSetting <= 2) break;
                coordHandler.pathUpdateSetting = 0;
            }
        }
        this.updateButtonTexts();
        coordHandler.saveToConfig();
    }

    @Override
    public void drawPreButtons(int x, int y, float partialTicks) {
    }

    @Override
    public void drawScreen(int x, int y, float partialTicks) {
    }

    private void updateButtonTexts() {
        CoordTrackUpgradeHandler coordHandler = HUDHandler.instance().getSpecificRenderer(CoordTrackUpgradeHandler.class);
        this.pathEnabled.field_146126_j = coordHandler.pathEnabled ? "Navigation Enabled" : "Navigation Disabled";
        this.wirePath.field_146126_j = coordHandler.wirePath ? "Wire Navigation" : "Tile Navigation";
        this.xRayEnabled.field_146126_j = coordHandler.xRayEnabled ? "X-Ray Enabled" : "X-Ray Disabled";
        switch (coordHandler.pathUpdateSetting) {
            case 0: {
                this.pathUpdateRate.field_146126_j = "Path update rate: Low";
                break;
            }
            case 1: {
                this.pathUpdateRate.field_146126_j = "Path update rate: Normal";
                break;
            }
            case 2: {
                this.pathUpdateRate.field_146126_j = "Path update rate: Fast";
            }
        }
        this.wirePath.field_146124_l = coordHandler.pathEnabled;
        this.xRayEnabled.field_146124_l = coordHandler.pathEnabled;
        this.pathUpdateRate.field_146124_l = coordHandler.pathEnabled;
    }

    @Override
    public void keyTyped(char ch, int key) {
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
    }

    @Override
    public void handleMouseInput() {
    }

    @Override
    public boolean canBeTurnedOff() {
        return true;
    }

    @Override
    public boolean displaySettingsText() {
        return true;
    }
}

