/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.widget;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.client.IGuiAnimatedStat;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.IWidgetListener;
import pneumaticCraft.client.gui.widget.WidgetVerticalScrollbar;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class GuiAnimatedStat
implements IGuiAnimatedStat,
IGuiWidget,
IWidgetListener {
    public static final int ANIMATED_STAT_SPEED = 10;
    private IGuiAnimatedStat affectingStat;
    private ItemStack iStack;
    private String texture = "";
    private final GuiScreen gui;
    private final List<String> textList = new ArrayList<String>();
    private final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private int baseX;
    private int baseY;
    private int affectedY;
    private int width;
    private int height;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private final int backGroundColor;
    private String title;
    private boolean leftSided;
    private boolean doneExpanding;
    private RenderItem itemRenderer;
    private float textSize;
    private float textScale = 1.0f;
    private IWidgetListener listener;
    private int curScroll;
    private static final int MAX_LINES = 12;
    private int lastMouseX;
    private int lastMouseY;

    public GuiAnimatedStat(GuiScreen gui, String title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        ScaledResolution sr;
        this.gui = gui;
        this.baseX = xPos;
        this.baseY = yPos;
        this.affectingStat = affectingStat;
        this.width = this.minWidth;
        this.height = this.minHeight;
        this.backGroundColor = backGroundColor;
        this.setTitle(title);
        this.texture = "";
        this.leftSided = leftSided;
        this.textSize = gui != null ? ((sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d)).func_78326_a() < 520 ? (float)(sr.func_78326_a() - 220) * 0.0033f : 1.0f) : 1.0f;
        this.affectedY = this.baseY;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getHeight();
        }
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor) {
        this(gui, "", 0, 0, backgroundColor, null, false);
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.iStack = icon;
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.texture = texture;
    }

    public GuiAnimatedStat(GuiScreen gui, String title, ItemStack icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.iStack = icon;
    }

    public GuiAnimatedStat(GuiScreen gui, String title, String texture, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.texture = texture;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    public void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    @Override
    public Rectangle getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)origX * this.textSize);
        int scaledY = (int)((float)origY * this.textSize);
        return new Rectangle(scaledX, scaledY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
        for (IGuiWidget widget : this.widgets) {
            if (widget.getID() != -1000) continue;
            this.widgets.remove(widget);
            break;
        }
        this.onTextChange();
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        }
        this.onTextChange();
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        this.textList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)text, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        this.onTextChange();
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
        this.onTextChange();
    }

    public void onTextChange() {
        if (this.textList.size() > 12) {
            for (IGuiWidget widget : this.widgets) {
                if (widget.getID() != -1000) continue;
                return;
            }
            this.curScroll = 0;
            this.addWidget(new WidgetVerticalScrollbar(-1000, this.leftSided ? -16 : 2, 20, (int)(100.0f * this.textSize)).setStates(this.textList.size() - 12));
        } else {
            Iterator<IGuiWidget> iterator = this.widgets.iterator();
            while (iterator.hasNext()) {
                IGuiWidget widget = iterator.next();
                if (widget.getID() != -1000) continue;
                iterator.remove();
                this.curScroll = 0;
            }
        }
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void update() {
        this.oldBaseX = this.baseX;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.doneExpanding = true;
        if (this.isClicked) {
            int maxWidth = fontRenderer.func_78256_a(this.title);
            int maxHeight = 12;
            if (this.textList.size() > 0) {
                maxHeight += 4 + Math.min(12, this.textList.size()) * 10;
            }
            maxHeight = (int)((float)maxHeight * this.textSize);
            for (String line : this.textList) {
                if (fontRenderer.func_78256_a(line) <= maxWidth) continue;
                maxWidth = fontRenderer.func_78256_a(line);
            }
            maxWidth = (int)((float)maxWidth * this.textSize);
            maxWidth += 20;
            for (int i = 0; i < 10; ++i) {
                if (this.width < maxWidth) {
                    ++this.width;
                    this.doneExpanding = false;
                }
                if (this.height < maxHeight) {
                    ++this.height;
                    this.doneExpanding = false;
                }
                if (this.width > maxWidth) {
                    --this.width;
                }
                if (this.height <= maxHeight) continue;
                --this.height;
            }
            if (this.doneExpanding) {
                for (IGuiWidget widget : this.widgets) {
                    if (widget.getID() != -1000) continue;
                    this.curScroll = ((WidgetVerticalScrollbar)widget).getState();
                }
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                if (this.width > this.minWidth) {
                    --this.width;
                }
                if (this.height <= this.minHeight) continue;
                --this.height;
            }
            this.doneExpanding = false;
        }
        this.affectedY = this.baseY;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getHeight();
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        float zLevel = 0.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.baseX - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.width - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.height - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        Gui.func_73734_a((int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)3.0f);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(2);
        tess.func_78377_a((double)renderBaseX, (double)renderAffectedY, (double)zLevel);
        tess.func_78377_a((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel);
        tess.func_78377_a((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel);
        tess.func_78377_a((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, (double)0.0);
            GL11.glScaled((double)this.textSize, (double)this.textSize, (double)this.textSize);
            GL11.glTranslated((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), (double)0.0);
            fontRenderer.func_78261_a(this.title, renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + 2, 0xFFFF00);
            for (int i = this.curScroll; i < this.textList.size() && i < this.curScroll + 12; ++i) {
                if (this.textList.get(i).contains("\u00a70") || this.textList.get(i).contains(EnumChatFormatting.DARK_RED.toString())) {
                    fontRenderer.func_78276_b(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + (i - this.curScroll) * 10 + 12, 0xFFFFFF);
                    continue;
                }
                fontRenderer.func_78261_a(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + (i - this.curScroll) * 10 + 12, 0xFFFFFF);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)renderBaseX, (double)renderAffectedY, (double)0.0);
            GL11.glEnable((int)3553);
            for (IGuiWidget widget : this.widgets) {
                widget.render(mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks);
            }
            GL11.glPopMatrix();
        }
        if (renderHeight > 16 && renderWidth > 16) {
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.iStack == null) {
                if (this.texture.contains("pneumaticcraft:textures/gui/")) {
                    GuiPneumaticContainerBase.drawTexture(this.texture, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY);
                } else {
                    fontRenderer.func_78276_b(this.texture, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY, -1);
                }
            } else if (this.gui != null || !(this.iStack.func_77973_b() instanceof ItemBlock)) {
                if (this.itemRenderer == null) {
                    this.itemRenderer = new RenderItem();
                }
                this.itemRenderer.field_77023_b = 1.0f;
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)-50.0);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                this.itemRenderer.func_82406_b(fontRenderer, FMLClientHandler.instance().getClient().field_71446_o, this.iStack, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY);
                GL11.glEnable((int)3008);
                RenderHelper.func_74518_a();
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.isClicked = !this.isClicked;
            this.listener.actionPerformed(this);
        }
        mouseX -= this.baseX;
        mouseY -= this.affectedY;
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(mouseX, mouseY)) continue;
            widget.onMouseClicked(mouseX, mouseY, button);
            this.isClicked = true;
        }
    }

    @Override
    public void onMouseClickedOutsideBounds(int mouseX, int mouseY, int button) {
    }

    @Override
    public void closeWindow() {
        this.isClicked = false;
    }

    @Override
    public void openWindow() {
        this.isClicked = true;
    }

    @Override
    public boolean isClicked() {
        return this.isClicked;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.baseX;
    }

    @Override
    public int getBaseY() {
        return this.baseY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setBaseY(int y) {
        this.baseY = y;
    }

    @Override
    public void setTitle(String title) {
        this.title = I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.baseX = x;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.baseX - (this.leftSided ? this.width : 0), this.affectedY, this.width, this.height);
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public int getID() {
        return -1;
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        this.isClicked = !this.isClicked;
        this.listener.actionPerformed(widget);
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        this.listener.onKeyTyped(widget);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.title);
        }
        for (IGuiWidget widget : this.widgets) {
            if (!this.isMouseOverWidget(widget, mouseX, mouseY)) continue;
            widget.addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    private boolean mouseIsHoveringOverIcon(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - 16 && y >= this.affectedY && y <= this.affectedY + 16;
        }
        return x >= this.baseX && x <= this.baseX + 16 && y >= this.affectedY && y <= this.affectedY + 16;
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.onKey(key, keyCode)) continue;
            return true;
        }
        return false;
    }

    private boolean isMouseOverWidget(IGuiWidget widget, int mouseX, int mouseY) {
        Rectangle rect = this.getBounds();
        return widget.getBounds().contains(mouseX -= rect.x, mouseY -= rect.y);
    }

    @Override
    public void handleMouseInput() {
        if (this.getBounds().contains(this.lastMouseX, this.lastMouseY)) {
            this.handleMouseWheel(Mouse.getDWheel());
        }
    }

    public boolean handleMouseWheel(int mouseWheel) {
        for (IGuiWidget widget : this.widgets) {
            widget.handleMouseInput();
            if (widget.getID() != -1000) continue;
            int wheel = -mouseWheel;
            wheel = MathHelper.func_76125_a((int)wheel, (int)-1, (int)1);
            ((WidgetVerticalScrollbar)widget).currentScroll += (float)wheel / (float)(this.textList.size() - 12);
            return true;
        }
        return false;
    }

    @Override
    public void postRender(int mouseX, int mouseY, float partialTick) {
    }
}

