/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.widget;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.IWidgetListener;

@SideOnly(value=Side.CLIENT)
public class GuiRadioButton
extends Gui
implements IGuiWidget {
    public boolean checked;
    public boolean enabled = true;
    public int x;
    public int y;
    public int color;
    private final int id;
    public String text;
    public FontRenderer fontRenderer;
    private List<String> tooltip;
    public List<GuiRadioButton> otherChoices;
    private IWidgetListener listener;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;

    public GuiRadioButton(int id, int x, int y, int color, String text) {
        this.fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.tooltip = new ArrayList<String>();
        this.id = id;
        this.x = x;
        this.y = y;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.drawCircle(this.x + 5, this.y + 5, 5, this.enabled ? -6250336 : -6710887);
        this.drawCircle(this.x + 5, this.y + 5, 4, this.enabled ? -16777216 : -5592406);
        if (this.checked) {
            this.drawCircle(this.x + 5, this.y + 5, 1, this.enabled ? -1 : -5592406);
        }
        this.fontRenderer.func_78276_b(I18n.func_135052_a((String)this.text, (Object[])new Object[0]), this.x + 1 + 10, this.y + 5 - this.fontRenderer.field_78288_b / 2, this.enabled ? this.color : -7829368);
    }

    private void drawCircle(int x, int y, int radius, int color) {
        Tessellator t = Tessellator.field_78398_a;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        t.func_78371_b(6);
        int points = 20;
        for (int i = 0; i < points; ++i) {
            double sin = Math.sin((double)i / (double)points * Math.PI * 2.0);
            double cos = Math.cos((double)i / (double)points * Math.PI * 2.0);
            t.func_78377_a((double)x + sin * (double)radius, (double)y + cos * (double)radius, (double)this.field_73735_i);
        }
        t.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, 10 + this.fontRenderer.func_78256_a(this.text), 10);
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (this.enabled) {
            if (this.otherChoices != null) {
                for (GuiRadioButton radioButton : this.otherChoices) {
                    radioButton.checked = false;
                }
            } else {
                throw new IllegalArgumentException("A radio button needs more than one choice! You need to set the GuiRadioButton#otherChoices field!");
            }
            this.checked = true;
            this.listener.actionPerformed(this);
        }
    }

    @Override
    public void onMouseClickedOutsideBounds(int mouseX, int mouseY, int button) {
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Arrays.asList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        curTooltip.addAll(this.tooltip);
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        return false;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public void update() {
    }

    @Override
    public void handleMouseInput() {
    }

    @Override
    public void postRender(int mouseX, int mouseY, float partialTick) {
    }
}

