/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.model;

import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.model.BaseModel;
import pneumaticCraft.common.tileentity.TileEntityCompressedIronBlock;
import pneumaticCraft.common.tileentity.TileEntityVortexTube;

public class ModelVortexTube
extends BaseModel {
    public ModelVortexTube() {
        super("vortexTube.obj");
    }

    @Override
    protected void applyRenderPreps(TileEntity te) {
        if (te instanceof TileEntityVortexTube) {
            int roll = ((TileEntityVortexTube)te).getRoll();
            GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
            GL11.glRotated((double)(roll * -90), (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)0.0, (double)8.0, (double)0.0);
        }
        super.applyRenderPreps(te);
        GL11.glScaled((double)0.025, (double)0.025, (double)0.025);
    }

    @Override
    public void renderStatic(float size, TileEntity te) {
        super.renderStatic(size, te);
        if (te instanceof TileEntityVortexTube && ((TileEntityVortexTube)te).shouldVisualize()) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glScaled((double)14.0, (double)14.0, (double)16.0);
            GL11.glTranslated((double)-0.5, (double)-1.0625, (double)-0.5);
            this.renderBox(19);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.875625);
            this.renderBox(0);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    protected void renderAll(TileEntity te) {
        if (te instanceof TileEntityVortexTube) {
            TileEntityVortexTube tube = (TileEntityVortexTube)te;
            int coldHeat = tube.getColdHeatLevel();
            int hotHeat = tube.getHotHeatLevel();
            this.model.renderAllExcept(new String[]{"Cold", "Hot_1", "Hot_2"});
            double[] color = TileEntityCompressedIronBlock.getColorForHeatLevel(coldHeat);
            GL11.glColor4d((double)color[0], (double)color[1], (double)color[2], (double)1.0);
            this.model.renderOnly(new String[]{"Cold"});
            color = TileEntityCompressedIronBlock.getColorForHeatLevel(hotHeat);
            GL11.glColor4d((double)color[0], (double)color[1], (double)color[2], (double)1.0);
            this.model.renderOnly(new String[]{"Hot_1", "Hot_2"});
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        } else {
            super.renderAll(te);
        }
    }

    private void renderBox(int heatLevel) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 0.125;
        double[] color = TileEntityCompressedIronBlock.getColorForHeatLevel(heatLevel);
        GL11.glColor4d((double)color[0], (double)color[1], (double)color[2], (double)((1.0 - color[1]) / 2.0));
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)minX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)maxX, (double)minY, (double)maxZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)maxZ);
        GL11.glEnd();
    }
}

