/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

@SideOnly(value=Side.CLIENT)
public class RenderLaser {
    private int ticksExisted;
    private final int coreColor;
    private final int glowColor;

    public RenderLaser(int color) {
        this(color, color);
    }

    public RenderLaser(int coreColor, int glowColor) {
        this.coreColor = coreColor;
        this.glowColor = glowColor;
    }

    public void update() {
        ++this.ticksExisted;
    }

    public void render(float partialTicks, double x1, double y1, double z1, double x2, double y2, double z2) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        TextureManager textureManager = mc.field_71446_o;
        double laserLength = PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        double laserSize = 0.4;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)x1, (double)y1, (double)z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double rotYaw = Math.atan2(dx, dz) * 180.0 / Math.PI;
        double rotPitch = 90.0f - (float)(Math.atan2(dy, f3) * 180.0 / Math.PI);
        GL11.glRotated((double)rotYaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotPitch, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)laserSize, (double)laserSize, (double)laserSize);
        GL11.glTranslated((double)0.0, (double)0.6, (double)0.0);
        GL11.glRotated((double)(((float)this.ticksExisted + partialTicks) * 200.0f), (double)0.0, (double)1.0, (double)0.0);
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)(laserLength / laserSize), (double)1.0);
        textureManager.func_110577_a(Textures.RENDER_LASER);
        this.renderQuad(this.glowColor);
        textureManager.func_110577_a(Textures.RENDER_LASER_OVERLAY);
        this.renderQuad(this.coreColor);
        GL11.glPopMatrix();
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        textureManager.func_110577_a(Textures.RENDER_LASER_START);
        this.renderQuad(this.glowColor);
        textureManager.func_110577_a(Textures.RENDER_LASER_START_OVERLAY);
        this.renderQuad(this.coreColor);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    private void renderQuad(int color) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78378_d(color);
        t.func_78374_a(-0.5, 0.0, 0.0, 0.0, 0.0);
        t.func_78374_a(-0.5, 1.0, 0.0, 0.0, 1.0);
        t.func_78374_a(0.5, 1.0, 0.0, 1.0, 1.0);
        t.func_78374_a(0.5, 0.0, 0.0, 1.0, 0.0);
        t.func_78381_a();
    }
}

