/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.semiblock.ClientSemiBlockManager;
import pneumaticCraft.client.semiblock.ISemiBlockRenderer;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockManager;

@SideOnly(value=Side.CLIENT)
public class RenderItemSemiBlock
implements IItemRenderer {
    private final ISemiBlock renderSemiBlock;

    public RenderItemSemiBlock(String key) {
        this.renderSemiBlock = SemiBlockManager.getSemiBlockForKey(key);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.render(-0.5f, 0.0f, 0.5f, 0.5f);
                return;
            }
            case EQUIPPED: {
                this.render(-0.1f, 0.0f, 1.0f, 1.0f);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.render(0.5f, 0.7f, 1.9f, 0.5f);
                return;
            }
            case INVENTORY: {
                this.render(0.0f, -0.08f, 1.0f, 1.0f);
                return;
            }
        }
    }

    private void render(float x, float y, float z, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ISemiBlockRenderer renderer = ClientSemiBlockManager.getRenderer(this.renderSemiBlock);
        if (renderer != null) {
            renderer.render(this.renderSemiBlock, 0.0f);
        }
        GL11.glPopMatrix();
    }
}

