/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import pneumaticCraft.api.client.pneumaticHelmet.EntityTrackEvent;
import pneumaticCraft.api.client.pneumaticHelmet.IOptionPage;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.client.gui.pneumaticHelmet.GuiEntityTrackOptions;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.render.pneumaticArmor.ArmorMessage;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.client.render.pneumaticArmor.RenderTarget;
import pneumaticCraft.common.CommonHUDHandler;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class EntityTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private final List<RenderTarget> targets = new ArrayList<RenderTarget>();
    private final Map<Entity, Integer> targetingEntities = new HashMap<Entity, Integer>();
    private boolean shouldStopSpamOnEntityTracking = false;
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    public boolean gaveNotAbleToTrackEntityWarning;
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat entityTrackInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;
    public static String UPGRADE_NAME = "entityTracker";

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return UPGRADE_NAME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        ItemStack helmetStack = player.func_82169_q(3);
        String entityFilter = "";
        if (helmetStack != null) {
            entityFilter = NBTUtil.getString(helmetStack, "entityFilter");
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 5);
        AxisAlignedBB bbBox = EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades);
        List mobs = player.field_70170_p.func_72872_a(EntityLivingBase.class, bbBox);
        if (mobs.contains(player)) {
            mobs.remove(player);
        }
        for (int i = 0; i < mobs.size(); ++i) {
            if ((double)player.func_70032_d((Entity)mobs.get(i)) > entityTrackRange || !PneumaticCraftUtils.isEntityValidForFilter(entityFilter, (Entity)mobs.get(i)) || MinecraftForge.EVENT_BUS.post((Event)new EntityTrackEvent((Entity)mobs.get(i)))) continue;
            boolean inList = false;
            for (int j = 0; j < this.targets.size(); ++j) {
                if (this.targets.get((int)j).entity != mobs.get(i)) continue;
                inList = true;
                this.targets.get((int)j).ticksExisted = Math.abs(this.targets.get((int)j).ticksExisted);
                break;
            }
            if (inList) continue;
            this.targets.add(new RenderTarget((Entity)mobs.get(i)));
            if (mobs.get(i) instanceof EntityMob && this.isEntityWithinPlayerFOV(player, (Entity)mobs.get(i))) continue;
        }
        for (int j = 0; j < this.targets.size(); ++j) {
            RenderTarget target = this.targets.get(j);
            if (!target.entity.field_70128_L && !((double)player.func_70032_d(target.entity) > entityTrackRange + 5.0) && PneumaticCraftUtils.isEntityValidForFilter(entityFilter, target.entity)) continue;
            if (target.ticksExisted > 0) {
                target.ticksExisted = -60;
                continue;
            }
            if (target.ticksExisted != -1) continue;
            this.targets.remove(target);
            --j;
        }
        if (this.targets.size() > 7) {
            if (!this.shouldStopSpamOnEntityTracking) {
                this.shouldStopSpamOnEntityTracking = true;
                HUDHandler.instance().addMessage(new ArmorMessage("Stopped spam on Entity Tracker", new ArrayList<String>(), 60, 0x7700AA00));
            }
        } else {
            this.shouldStopSpamOnEntityTracking = false;
        }
        ArrayList<String> text = new ArrayList<String>();
        for (RenderTarget target : this.targets) {
            boolean wasNegative = target.ticksExisted < 0;
            target.ticksExisted += CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
            if (target.ticksExisted >= 0 && wasNegative) {
                target.ticksExisted = -1;
            }
            target.update();
            if (!target.isLookingAtTarget) continue;
            if (target.isInitialized()) {
                text.add(EnumChatFormatting.GRAY + target.entity.func_70005_c_());
                text.addAll(target.getEntityText());
                continue;
            }
            text.add(EnumChatFormatting.GRAY + "Acquiring target...");
        }
        if (text.size() == 0) {
            text.add("Filter mode: " + (entityFilter.equals("") ? "None" : entityFilter));
        }
        this.entityTrackInfo.setText(text);
        Iterator<Map.Entry<Entity, Integer>> iterator = this.targetingEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity entity = entry.getKey();
            if (entry.getValue() >= 0) {
                entry.setValue(entry.getValue() + 1);
            }
            if (!entity.field_70128_L && player.field_70170_p.func_72910_y().contains(entity) && entry.getValue() <= 50) continue;
            iterator.remove();
        }
    }

    public void warnIfNecessary(Entity entity) {
        if (!this.targetingEntities.containsKey(entity)) {
            HUDHandler.instance().addMessage(new ArmorMessage("A mob is targeting you!", new ArrayList<String>(), 60, 0x70FF0000));
        }
        this.targetingEntities.put(entity, -1);
    }

    public void removeTargetingEntity(Entity entity) {
        if (this.targetingEntities.containsKey(entity)) {
            this.targetingEntities.put(entity, 0);
        }
    }

    public static AxisAlignedBB getAABBFromRange(EntityPlayer player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(10, rangeUpgrades) * 5);
        return AxisAlignedBB.func_72330_a((double)(player.field_70165_t - entityTrackRange), (double)(player.field_70163_u - entityTrackRange), (double)(player.field_70161_v - entityTrackRange), (double)(player.field_70165_t + entityTrackRange), (double)(player.field_70163_u + entityTrackRange), (double)(player.field_70161_v + entityTrackRange));
    }

    private boolean isEntityWithinPlayerFOV(EntityPlayer player, Entity entity) {
        Vec3 vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t - player.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(entity.field_70161_v - player.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 2.5 / d0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        for (RenderTarget target : this.targets) {
            target.render(partialTicks, this.shouldStopSpamOnEntityTracking);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public boolean isEnabled(ItemStack[] upgradeStacks) {
        for (ItemStack stack : upgradeStacks) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != 3) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.targets.clear();
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(10, rangeUpgrades) * 5.0f / 16.0f) * (float)CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiEntityTrackOptions(this);
    }

    @Override
    public void initConfig(Configuration config) {
        this.statX = config.get("Helmet_Options.Entity_Tracker", "stat X", -1).getInt();
        this.statY = config.get("Helmet_Options.Entity_Tracker", "stat Y", 90).getInt();
        this.statLeftSided = config.get("Helmet_Options.Entity_Tracker", "stat leftsided", true).getBoolean(true);
    }

    @Override
    public void saveToConfig() {
        Configuration config = Config.config;
        config.load();
        config.get("Helmet_Options.Entity_Tracker", "stat X", -1).set(this.entityTrackInfo.getBaseX());
        config.get("Helmet_Options.Entity_Tracker", "stat Y", 90).set(this.entityTrackInfo.getBaseY());
        config.get("Helmet_Options.Entity_Tracker", "stat leftsided", true).set(this.entityTrackInfo.isLeftSided());
        this.statX = this.entityTrackInfo.getBaseX();
        this.statY = this.entityTrackInfo.getBaseY();
        this.statLeftSided = this.entityTrackInfo.isLeftSided();
        config.save();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
            this.entityTrackInfo = new GuiAnimatedStat(null, "Current tracked entities:", new ItemStack(Itemss.machineUpgrade, 1, 3), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.entityTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.entityTrackInfo;
    }

    public List<RenderTarget> getTargets() {
        return this.targets;
    }

    public RenderTarget getTargetForEntity(Entity entity) {
        for (RenderTarget target : this.targets) {
            if (target.entity != entity) continue;
            return target;
        }
        return null;
    }

    public void hack() {
        for (RenderTarget target : this.targets) {
            target.hack();
        }
    }

    public void selectAsDebuggingTarget() {
        for (RenderTarget target : this.targets) {
            target.selectAsDebuggingTarget();
        }
    }

    public boolean scroll(MouseEvent event) {
        for (RenderTarget target : this.targets) {
            if (!target.scroll(event)) continue;
            return true;
        }
        return false;
    }
}

