/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.block.IPneumaticWrenchable;
import pneumaticCraft.api.client.pneumaticHelmet.EntityTrackEvent;
import pneumaticCraft.api.client.pneumaticHelmet.InventoryTrackEvent;
import pneumaticCraft.api.drone.AmadronRetrievalEvent;
import pneumaticCraft.api.drone.DroneConstructingEvent;
import pneumaticCraft.api.drone.DroneSuicideEvent;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.client.gui.widget.GuiKeybindCheckBox;
import pneumaticCraft.client.render.pneumaticArmor.EntityTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.client.render.pneumaticArmor.hacking.HackableHandler;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableEnderman;
import pneumaticCraft.common.AchievementHandler;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.block.pneumaticPlants.BlockPlants;
import pneumaticCraft.common.block.pneumaticPlants.BlockPneumaticPlantBase;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.entity.EntityProgrammableController;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.ItemAmadronTablet;
import pneumaticCraft.common.item.ItemPlasticPlants;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketPlaySound;
import pneumaticCraft.common.network.PacketSetMobTarget;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.common.recipes.AmadronOfferManager;
import pneumaticCraft.common.remote.GlobalVariableManager;
import pneumaticCraft.common.thirdparty.ModInteractionUtilImplementation;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class EventHandlerPneumaticCraft {
    private static ItemStack IRON_INGOT = new ItemStack(Items.field_151042_j);
    private static ItemStack IRON_BLOCK = new ItemStack(Blocks.field_150339_S);

    @SubscribeEvent
    public void handleIronExplosions(ExplosionEvent.Detonate event) {
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof EntityItem) || ((stack = ((EntityItem)entity).func_92059_d()) == null || entity.field_70128_L || !PneumaticCraftUtils.isSameOreDictStack(stack, IRON_INGOT)) && !PneumaticCraftUtils.isSameOreDictStack(stack, IRON_BLOCK)) continue;
            Random rand = new Random();
            if (stack.field_77994_a < 3 && !(rand.nextDouble() >= (double)Config.configCompressedIngotLossRate / 100.0)) continue;
            Item newItem = PneumaticCraftUtils.isSameOreDictStack(stack, IRON_INGOT) ? Itemss.ingotIronCompressed : Item.func_150898_a((Block)Blockss.compressedIron);
            ItemStack newStack = new ItemStack(newItem, stack.field_77994_a, stack.func_77960_j());
            if (stack.field_77994_a >= 3) {
                newStack.field_77994_a = (int)((double)stack.field_77994_a * (rand.nextDouble() * Math.min((double)Config.configCompressedIngotLossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)Config.configCompressedIngotLossRate * 0.01) - (double)Config.configCompressedIngotLossRate * 0.01)));
            }
            ((EntityItem)entity).func_92058_a(newStack);
            iterator.remove();
            for (EntityPlayer player : event.world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(event.explosion.field_77284_b - 32.0), (double)(event.explosion.field_77285_c - 32.0), (double)(event.explosion.field_77282_d - 32.0), (double)(event.explosion.field_77284_b + 32.0), (double)(event.explosion.field_77285_c + 32.0), (double)(event.explosion.field_77282_d + 32.0)))) {
                AchievementHandler.giveAchievement(player, newStack);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        HackableHandler.onEntityConstruction(event.entity);
        ItemPlasticPlants.onEntityConstruction(event.entity);
        if (event.entity instanceof IDroneBase) {
            MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent((IDroneBase)event.entity));
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (event.item != null && event.entityPlayer != null) {
            AchievementHandler.giveAchievement(event.entityPlayer, event.item.func_92059_d());
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            if (Config.enableSlimeSeedDrop && event.entity instanceof EntitySlime && Math.random() < 0.1) {
                ItemPlasticPlants.markInactive(event.entity.func_70099_a(new ItemStack(Itemss.plasticPlant, 1, 3), 0.0f));
            } else if (Config.enableCreeperSeedDrop && event.entity instanceof EntityCreeper && Math.random() < 0.05) {
                if (Config.enableCreeperDropExplosion) {
                    event.entity.field_70170_p.func_72876_a(event.entity, event.entity.field_70165_t, event.entity.field_70163_u + (double)event.entityLiving.field_70131_O / 2.0, event.entity.field_70161_v, 0.5f, event.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                int dropAmount = (int)(Math.random() * 3.0) + 1;
                for (int i = 0; i < dropAmount; ++i) {
                    ItemPlasticPlants.markInactive(event.entity.func_70099_a(new ItemStack(Itemss.plasticPlant, 1, 2), 0.0f));
                }
            } else if (Config.enableSquidSeedDrop && event.entity instanceof EntitySquid && Math.random() < 0.05) {
                ItemPlasticPlants.markInactive(event.entity.func_70099_a(new ItemStack(Itemss.plasticPlant, 1, 0), 0.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (!HackableEnderman.onEndermanTeleport(event.entity)) {
            event.setCanceled(true);
        } else if (Config.enableEndermanSeedDrop && Math.random() < 0.05 && !event.entity.field_70170_p.field_72995_K) {
            ItemPlasticPlants.markInactive(event.entity.func_70099_a(new ItemStack(Itemss.plasticPlant, 1, 5), 0.0f));
        }
    }

    @SubscribeEvent
    public void onFertilization(BonemealEvent event) {
        boolean onGrass;
        if (event.world.field_72995_K) {
            return;
        }
        if ((event.block == Blocks.field_150424_aL || event.block == Blocks.field_150377_bs || event.block.canSustainPlant((IBlockAccess)event.world, event.x, event.y, event.z, ForgeDirection.UP, (IPlantable)Blocks.field_150328_O)) && ((onGrass = event.block instanceof BlockGrass) && Config.includePlantsOnBonemeal || !onGrass && Config.allowDirtBonemealing)) {
            for (int x = event.x - 2; x < event.x + 3; ++x) {
                for (int z = event.z - 2; z < event.z + 3; ++z) {
                    BlockPneumaticPlantBase trySpawn;
                    if (!event.world.func_147437_c(x, event.y + 1, z) || event.world.field_73012_v.nextInt(8) != 1 || !(trySpawn = BlockPlants.allPlants.get(event.world.field_73012_v.nextInt(BlockPlants.allPlants.size() - 1))).canPlantGrowOnThisBlock(event.world.func_147439_a(x, event.y, z), event.world, x, event.y, z)) continue;
                    event.world.func_147449_b(x, event.y + (trySpawn.isPlantHanging() ? -1 : 1), z, (Block)trySpawn);
                }
                if (onGrass) continue;
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void FillBucket(FillBucketEvent event) {
        MovingObjectPosition p = event.target;
        if (event.current == null || event.current.func_77973_b() != Items.field_151133_ar || event.world.func_72805_g(p.field_72311_b, p.field_72312_c, p.field_72309_d) != 0) {
            return;
        }
        ItemStack result = this.attemptFill(event.world, event.target);
        if (result != null) {
            event.result = result;
            AchievementHandler.giveAchievement(event.entityPlayer, result);
            event.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack attemptFill(World world, MovingObjectPosition p) {
        Block id = world.func_147439_a(p.field_72311_b, p.field_72312_c, p.field_72309_d);
        for (Map.Entry<Block, Item> entry : Fluids.fluidBlockToBucketMap.entrySet()) {
            if (id != entry.getKey()) continue;
            world.func_147449_b(p.field_72311_b, p.field_72312_c, p.field_72309_d, Blocks.field_150350_a);
            return new ItemStack(entry.getValue());
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        ItemStack heldItem;
        boolean tryingToPlaceSecurityStation;
        int blockingStations;
        Block interactedBlock = event.world.func_147439_a(event.x, event.y, event.z);
        if (!(event.entityPlayer.field_71075_bZ.field_75098_d && event.entityPlayer.func_70003_b(2, "securityStation") || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.world == null || event.world.field_72995_K || interactedBlock == Blockss.securityStation && event.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || (blockingStations = PneumaticCraftUtils.getProtectingSecurityStations(event.entity.field_70170_p, event.x, event.y, event.z, event.entityPlayer, true, tryingToPlaceSecurityStation = (heldItem = event.entityPlayer.func_71045_bC()) != null && heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).field_150939_a == Blockss.securityStation)) <= 0)) {
            event.setCanceled(true);
            event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)(tryingToPlaceSecurityStation ? "message.securityStation.stationPlacementPrevented" : "message.securityStation.accessPrevented"), (Object[])new Object[]{blockingStations})));
        }
        if (!event.isCanceled() && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !event.world.field_72995_K) {
            if (event.entityPlayer.func_70093_af() && (interactedBlock == Blockss.elevatorCaller || interactedBlock == Blockss.chargingStation)) {
                event.setCanceled(interactedBlock.func_149727_a(event.world, event.x, event.y, event.z, event.entityPlayer, event.face, 0.0f, 0.0f, 0.0f));
            } else if (event.entityPlayer.func_71045_bC() != null && ModInteractionUtilImplementation.getInstance().isModdedWrench(event.entityPlayer.func_71045_bC().func_77973_b()) && interactedBlock instanceof IPneumaticWrenchable) {
                ((IPneumaticWrenchable)interactedBlock).rotateBlock(event.world, event.entityPlayer, event.x, event.y, event.z, ForgeDirection.getOrientation((int)event.face));
            }
        }
        if (!event.isCanceled() && interactedBlock == Blocks.field_150347_e) {
            AchievementHandler.checkFor9x9(event.entityPlayer, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onMobTargetSet(LivingSetAttackTargetEvent event) {
        if (event.entity instanceof EntityCreature) {
            if (!event.entity.field_70170_p.field_72995_K) {
                NetworkHandler.sendToAllAround(new PacketSetMobTarget((EntityCreature)event.entity, event.target), new NetworkRegistry.TargetPoint(event.entity.field_70170_p.field_73011_w.field_76574_g, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 64.0));
            } else {
                this.warnPlayerIfNecessary(event);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void warnPlayerIfNecessary(LivingSetAttackTargetEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (event.target == player && (event.entityLiving instanceof EntityGolem || event.entityLiving instanceof EntityMob)) {
            ItemStack helmetStack = player.func_82169_q(3);
            if (helmetStack != null && helmetStack.func_77973_b() == Itemss.pneumaticHelmet && ((IPressurizable)helmetStack.func_77973_b()).getPressure(helmetStack) > 0.0f && ItemPneumaticArmor.getUpgrades(3, helmetStack) > 0 && GuiKeybindCheckBox.trackedCheckboxes.get((Object)"pneumaticHelmet.upgrade.coreComponents").checked && GuiKeybindCheckBox.trackedCheckboxes.get((Object)new StringBuilder().append((String)"pneumaticHelmet.upgrade.").append((String)EntityTrackUpgradeHandler.UPGRADE_NAME).toString()).checked) {
                HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).warnIfNecessary((Entity)event.entityLiving);
            }
        } else {
            HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).removeTargetingEntity((Entity)event.entityLiving);
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        if (event.username.equals("Quetzz") && event.message.equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendTo(new PacketPlaySound("mob.cow.say", event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, 1.0f, 1.0f, true), event.player);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            GlobalVariableManager.overworld = event.world;
            event.world.func_72943_a(GlobalVariableManager.class, "PneumaticCraftGlobalVariables");
        }
    }

    @SubscribeEvent
    public void onEntityTracking(EntityTrackEvent event) {
        if (event.trackingEntity instanceof EntityProgrammableController) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof TileEntityProgrammer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        EntityDrone drone;
        AmadronOffer offer;
        if (event.drone instanceof EntityDrone && (offer = (drone = (EntityDrone)event.drone).getHandlingOffer()) != null) {
            int times = drone.getOfferTimes();
            if (offer.getInput() instanceof ItemStack) {
                int i;
                int requiredCount = ((ItemStack)offer.getInput()).field_77994_a * times;
                for (i = 0; i < drone.getInventory().func_70302_i_(); ++i) {
                    if (drone.getInventory().func_70301_a(i) == null) continue;
                    requiredCount -= drone.getInventory().func_70301_a((int)i).field_77994_a;
                }
                if (requiredCount <= 0) {
                    for (i = 0; i < drone.getInventory().func_70302_i_(); ++i) {
                        drone.getInventory().func_70299_a(i, null);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                }
            } else {
                int requiredCount = ((FluidStack)offer.getInput()).amount * times;
                if (drone.getTank().getFluidAmount() >= requiredCount) {
                    MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                }
            }
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        EntityDrone drone = (EntityDrone)event.drone;
        AmadronOffer offer = drone.getHandlingOffer();
        boolean shouldDeliver = false;
        if (offer instanceof AmadronOfferCustom) {
            AmadronOffer realOffer = AmadronOfferManager.getInstance().get(offer);
            if (realOffer != null) {
                ((AmadronOfferCustom)realOffer).addPayment(drone.getOfferTimes());
                ((AmadronOfferCustom)realOffer).addStock(-drone.getOfferTimes());
                realOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                shouldDeliver = true;
            }
            if ((realOffer = AmadronOfferManager.getInstance().get(((AmadronOfferCustom)offer).copy().invert())) != null) {
                ((AmadronOfferCustom)realOffer).addStock(drone.getOfferTimes());
            }
        } else {
            shouldDeliver = true;
        }
        if (shouldDeliver) {
            ItemStack usedTablet = drone.getUsedTablet();
            if (offer.getOutput() instanceof ItemStack) {
                ItemStack stack;
                ItemStack offeringItems = (ItemStack)offer.getOutput();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int producedItems = offeringItems.field_77994_a * drone.getOfferTimes(); producedItems > 0; producedItems -= stack.field_77994_a) {
                    stack = offeringItems.func_77946_l();
                    stack.field_77994_a = Math.min(producedItems, stack.func_77976_d());
                    stacks.add(stack);
                }
                ChunkPosition pos = ItemAmadronTablet.getItemProvidingLocation(usedTablet);
                if (pos != null) {
                    World world = PneumaticCraftUtils.getWorldForDimension(ItemAmadronTablet.getItemProvidingDimension(usedTablet));
                    PneumaticRegistry.getInstance().deliverItemsAmazonStyle(world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, stacks.toArray(new ItemStack[stacks.size()]));
                }
            } else {
                FluidStack offeringFluid = ((FluidStack)offer.getOutput()).copy();
                offeringFluid.amount *= drone.getOfferTimes();
                ChunkPosition pos = ItemAmadronTablet.getLiquidProvidingLocation(usedTablet);
                if (pos != null) {
                    World world = PneumaticCraftUtils.getWorldForDimension(ItemAmadronTablet.getLiquidProvidingDimension(usedTablet));
                    PneumaticRegistry.getInstance().deliverFluidAmazonStyle(world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, offeringFluid);
                }
            }
        }
    }
}

