/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import pneumaticCraft.common.ai.DroneAIBlockInteraction;
import pneumaticCraft.common.ai.DroneAIDig;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IBlockRightClicker;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetPlace;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class DroneAIBlockInteract
extends DroneAIBlockInteraction {
    private final List<ChunkPosition> visitedPositions = new ArrayList<ChunkPosition>();

    public DroneAIBlockInteract(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        drone.getFakePlayer().func_70095_a(((IBlockRightClicker)((Object)widget)).isSneaking());
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        return !this.visitedPositions.contains(pos) && (this.widget.isItemFilterEmpty() || DroneAIDig.isBlockValidForFilter((IBlockAccess)this.drone.getWorld(), this.drone, pos, this.widget));
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        this.visitedPositions.add(pos);
        boolean result = this.rightClick(pos);
        if (this.drone.getFakePlayer().func_71045_bC() != null && this.drone.getFakePlayer().func_71045_bC().field_77994_a <= 0) {
            this.drone.getFakePlayer().func_70062_b(0, null);
        }
        DroneAIBlockInteract.transferToDroneFromFakePlayer(this.drone);
        return result;
    }

    public static void transferToDroneFromFakePlayer(IDroneBase drone) {
        for (int j = 1; j < drone.getFakePlayer().field_71071_by.field_70462_a.length; ++j) {
            ItemStack excessStack = drone.getFakePlayer().field_71071_by.field_70462_a[j];
            if (excessStack == null) continue;
            ItemStack remainder = PneumaticCraftUtils.exportStackToInventory(drone.getInventory(), excessStack, ForgeDirection.UNKNOWN);
            if (remainder != null) {
                drone.dropItem(remainder);
            }
            drone.getFakePlayer().field_71071_by.field_70462_a[j] = null;
        }
    }

    private boolean rightClick(ChunkPosition pos) {
        int xCoord = pos.field_151329_a;
        int yCoord = pos.field_151327_b;
        int zCoord = pos.field_151328_c;
        ForgeDirection faceDir = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides());
        EntityPlayerMP player = this.drone.getFakePlayer();
        World worldObj = this.drone.getWorld();
        int dx = faceDir.offsetX;
        int dy = faceDir.offsetY;
        int dz = faceDir.offsetZ;
        int x = xCoord;
        int y = yCoord;
        int z = zCoord;
        player.func_70107_b((double)x + 0.5, (double)y + 0.5 - (double)player.eyeHeight, (double)z + 0.5);
        player.field_70125_A = faceDir.offsetY * -90;
        switch (faceDir) {
            case NORTH: {
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70177_z = -90.0f;
            }
        }
        try {
            PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_AIR, (int)x, (int)y, (int)z, (int)faceDir.ordinal(), (World)worldObj);
            if (event.isCanceled()) {
                return false;
            }
            Block block = worldObj.func_147439_a(x, y, z);
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b().onItemUseFirst(stack, (EntityPlayer)player, worldObj, x, y, z, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) {
                return false;
            }
            if (!worldObj.func_147437_c(x, y, z) && block.func_149727_a(worldObj, x, y, z, (EntityPlayer)player, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) {
                return false;
            }
            if (stack != null) {
                int useZ;
                boolean isGoingToShift = false;
                if (stack.func_77973_b() instanceof ItemReed || stack.func_77973_b() instanceof ItemRedstone) {
                    isGoingToShift = true;
                }
                int useX = isGoingToShift ? xCoord : x;
                int useY = isGoingToShift ? yCoord : y;
                int n = useZ = isGoingToShift ? zCoord : z;
                if (stack.func_77973_b().func_77648_a(stack, (EntityPlayer)player, worldObj, useX, useY, useZ, faceDir.ordinal(), (float)dx, (float)dy, (float)dz)) {
                    return false;
                }
                ItemStack copy = stack.func_77946_l();
                player.func_70062_b(0, stack.func_77973_b().func_77659_a(stack, worldObj, (EntityPlayer)player));
                if (!copy.func_77969_a(stack)) {
                    return true;
                }
            }
            return false;
        }
        catch (Throwable e) {
            Log.error("DroneAIBlockInteract crashed! Stacktrace: ");
            e.printStackTrace();
            return false;
        }
    }
}

