/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import pneumaticCraft.common.ai.DroneAIBlockInteraction;
import pneumaticCraft.common.ai.FakePlayerItemInWorldManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class DroneAIDig
extends DroneAIBlockInteraction {
    private static final HashMap<Integer, ItemStack> silkTouchBlocks = new HashMap();

    public DroneAIDig(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        Block block = this.worldCache.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        if (!this.worldCache.func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c) && !DroneAIDig.ignoreBlock(block)) {
            int meta = this.worldCache.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            ArrayList droppedStacks = block.canSilkHarvest(this.drone.getWorld(), (EntityPlayer)this.drone.getFakePlayer(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, meta) ? Arrays.asList(DroneAIDig.getSilkTouchBlock(block, meta)) : block.getDrops(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, meta, 0);
            for (ItemStack droppedStack : droppedStacks) {
                if (!this.widget.isItemValidForFilters(droppedStack, meta)) continue;
                this.swapBestItemToFirstSlot(block, pos);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    private void swapBestItemToFirstSlot(Block block, ChunkPosition pos) {
        int bestSlot = 0;
        float bestSoftness = Float.MIN_VALUE;
        ItemStack oldCurrentStack = this.drone.getInventory().func_70301_a(0);
        for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
            this.drone.getInventory().func_70299_a(0, this.drone.getInventory().func_70301_a(i));
            float softness = block.func_149737_a((EntityPlayer)this.drone.getFakePlayer(), this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            if (!(softness > bestSoftness)) continue;
            bestSlot = i;
            bestSoftness = softness;
        }
        this.drone.getInventory().func_70299_a(0, oldCurrentStack);
        if (bestSlot != 0) {
            ItemStack bestItem = this.drone.getInventory().func_70301_a(bestSlot);
            this.drone.getInventory().func_70299_a(bestSlot, this.drone.getInventory().func_70301_a(0));
            this.drone.getInventory().func_70299_a(0, bestItem);
        }
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        if (!((FakePlayerItemInWorldManager)this.drone.getFakePlayer().field_71134_c).isDigging() || !((FakePlayerItemInWorldManager)this.drone.getFakePlayer().field_71134_c).isAcknowledged()) {
            int x = pos.field_151329_a;
            int y = pos.field_151327_b;
            int z = pos.field_151328_c;
            Block block = this.worldCache.func_147439_a(x, y, z);
            if (!DroneAIDig.ignoreBlock(block) && DroneAIDig.isBlockValidForFilter(this.worldCache, this.drone, pos, this.widget)) {
                if (block.func_149712_f(this.drone.getWorld(), x, y, z) < 0.0f) {
                    this.addToBlacklist(pos);
                    this.drone.addDebugEntry("gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(0, 0, 0);
                    return false;
                }
                FakePlayerItemInWorldManager manager = (FakePlayerItemInWorldManager)this.drone.getFakePlayer().field_71134_c;
                manager.func_73074_a(x, y, z, 0);
                if (!manager.isAccepted) {
                    this.addToBlacklist(pos);
                    this.drone.addDebugEntry("gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(0, 0, 0);
                    return false;
                }
                this.drone.setDugBlock(x, y, z);
                return true;
            }
            this.drone.setDugBlock(0, 0, 0);
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForFilter(IBlockAccess worldCache, IDroneBase drone, ChunkPosition pos, ProgWidgetAreaItemBase widget) {
        int x = pos.field_151329_a;
        int y = pos.field_151327_b;
        int z = pos.field_151328_c;
        Block block = worldCache.func_147439_a(x, y, z);
        if (!block.isAir(worldCache, x, y, z)) {
            int meta = worldCache.func_72805_g(x, y, z);
            ArrayList droppedStacks = block.canSilkHarvest(drone.getWorld(), (EntityPlayer)drone.getFakePlayer(), x, y, z, meta) ? Arrays.asList(DroneAIDig.getSilkTouchBlock(block, meta)) : block.getDrops(drone.getWorld(), x, y, z, meta, 0);
            for (ItemStack droppedStack : droppedStacks) {
                if (!widget.isItemValidForFilters(droppedStack, meta)) continue;
                return true;
            }
        }
        return false;
    }

    private static ItemStack getSilkTouchBlock(Block block, int meta) {
        ItemStack stack = silkTouchBlocks.get(Block.func_149682_b((Block)block));
        if (stack == null) {
            Method method = ReflectionHelper.findMethod(Block.class, (Object)block, (String[])new String[]{"func_149644_j", "createStackedBlock"}, (Class[])new Class[]{Integer.TYPE});
            try {
                stack = (ItemStack)method.invoke((Object)block, meta);
            }
            catch (Exception e) {
                Log.error("Reflection failed when trying to get a silk touch block!");
                e.printStackTrace();
            }
            silkTouchBlocks.put(Block.func_149682_b((Block)block), stack);
        }
        return stack.func_77946_l();
    }

    private static boolean ignoreBlock(Block block) {
        return PneumaticCraftUtils.isBlockLiquid(block);
    }
}

