/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.api.item.IProgrammable;
import pneumaticCraft.common.ai.DroneAIBlockInteraction;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetExternalProgram;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.IOHelper;

public class DroneAIExternalProgram
extends DroneAIBlockInteraction<ProgWidgetExternalProgram> {
    private final DroneAIManager subAI;
    private final DroneAIManager mainAI;
    private final Set<ChunkPosition> traversedPositions = new HashSet<ChunkPosition>();
    private int curSlot;
    private NBTTagCompound curProgramTag;

    public DroneAIExternalProgram(IDroneBase drone, DroneAIManager mainAI, ProgWidgetExternalProgram widget) {
        super(drone, widget);
        this.mainAI = mainAI;
        this.subAI = new DroneAIManager(drone, new ArrayList<IProgWidget>());
    }

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            this.traversedPositions.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean moveToPositions() {
        return false;
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        if (this.traversedPositions.add(pos)) {
            this.curSlot = 0;
            TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            return te instanceof IInventory;
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        IInventory inv = IOHelper.getInventoryForTE(this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
        if (inv == null) {
            return false;
        }
        if (this.curProgramTag != null) {
            if (this.curSlot < inv.func_70302_i_()) {
                ItemStack stack = inv.func_70301_a(this.curSlot);
                if (stack != null && this.curProgramTag.equals((Object)stack.func_77978_p())) {
                    this.subAI.onUpdateTasks();
                    if (this.subAI.isIdling() || this.isRunningSameProgram(this.subAI.getCurrentAI())) {
                        this.curProgramTag = null;
                        ++this.curSlot;
                    }
                } else {
                    this.curProgramTag = null;
                    this.subAI.setWidgets(new ArrayList<IProgWidget>());
                }
            }
            return true;
        }
        while (this.curSlot < inv.func_70302_i_()) {
            IProgrammable programmable;
            ItemStack stack = inv.func_70301_a(this.curSlot);
            if (stack != null && stack.func_77973_b() instanceof IProgrammable && (programmable = (IProgrammable)stack.func_77973_b()).canProgram(stack) && programmable.usesPieces(stack)) {
                List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(stack);
                boolean areWidgetsValid = true;
                for (IProgWidget widget : widgets) {
                    if (this.drone.isProgramApplicable(widget)) continue;
                    areWidgetsValid = false;
                    break;
                }
                if (areWidgetsValid) {
                    if (((ProgWidgetExternalProgram)this.widget).shareVariables) {
                        this.mainAI.connectVariables(this.subAI);
                    }
                    this.subAI.getDrone().getAIManager().setLabel("Main");
                    this.subAI.setWidgets(widgets);
                    this.curProgramTag = stack.func_77978_p();
                    if (!this.subAI.isIdling()) {
                        return true;
                    }
                }
            }
            ++this.curSlot;
        }
        return false;
    }

    private boolean isRunningSameProgram(EntityAIBase ai) {
        return ai instanceof DroneAIExternalProgram && this.curProgramTag.equals((Object)((DroneAIExternalProgram)ai).curProgramTag);
    }

    public DroneAIManager getRunningAI() {
        return this.subAI;
    }
}

