/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.common.ai.DroneAIImExBase;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.IOHelper;

public class DroneEntityAIInventoryExport
extends DroneAIImExBase {
    public DroneEntityAIInventoryExport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        return this.export(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        return this.export(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean export(ChunkPosition pos, boolean simulate) {
        IInventory inv = IOHelper.getInventoryForTE(this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
        if (inv != null) {
            for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                ItemStack droneStack = this.drone.getInventory().func_70301_a(i);
                if (droneStack == null) continue;
                if (this.widget.isItemValidForFilters(droneStack)) {
                    for (int side = 0; side < 6; ++side) {
                        int stackSize;
                        droneStack = this.drone.getInventory().func_70301_a(i);
                        if (!((ISidedWidget)((Object)this.widget)).getSides()[side] || droneStack == null) continue;
                        droneStack = droneStack.func_77946_l();
                        int oldCount = droneStack.field_77994_a;
                        if (((ICountWidget)((Object)this.widget)).useCount()) {
                            droneStack.field_77994_a = Math.min(droneStack.field_77994_a, this.getRemainingCount());
                        }
                        ItemStack remainder = IOHelper.insert(inv, droneStack.func_77946_l(), side, simulate);
                        droneStack.field_77994_a = stackSize = this.drone.getInventory().func_70301_a((int)i).field_77994_a - (remainder == null ? droneStack.field_77994_a : droneStack.field_77994_a - remainder.field_77994_a);
                        int exportedItems = oldCount - stackSize;
                        if (!simulate) {
                            this.drone.getInventory().func_70299_a(i, (ItemStack)(stackSize > 0 ? droneStack : null));
                            this.decreaseCount(exportedItems);
                        }
                        if (simulate && exportedItems > 0) {
                            return true;
                        }
                        if (!(inv instanceof ISidedInventory)) break;
                    }
                    if (droneStack == null && !simulate) {
                        this.drone.addAir(null, -10);
                        continue;
                    }
                    this.drone.addDebugEntry("gui.progWidget.inventoryExport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.addDebugEntry("gui.progWidget.inventoryExport.debug.stackdoesntPassFilter", pos);
            }
        } else {
            this.drone.addDebugEntry("gui.progWidget.inventory.debug.noInventory", pos);
        }
        return false;
    }
}

