/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.common.ai.DroneAIImExBase;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class DroneEntityAIInventoryImport
extends DroneAIImExBase {
    public DroneEntityAIInventoryImport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        return this.importItems(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        return this.importItems(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean importItems(ChunkPosition pos, boolean simulate) {
        IInventory inv = IOHelper.getInventoryForTE(this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
        if (inv != null) {
            Set<Integer> accessibleSlots = PneumaticCraftUtils.getAccessibleSlotsForInventoryAndSides(inv, ((ISidedWidget)((Object)this.widget)).getSides());
            for (Integer i : accessibleSlots) {
                ItemStack stack = inv.func_70301_a(i.intValue());
                if (stack == null || !IOHelper.canExtractItemFromInventory(inv, stack, (int)i, ((ISidedWidget)((Object)this.widget)).getSides())) continue;
                if (this.widget.isItemValidForFilters(stack)) {
                    ItemStack importedStack = stack.func_77946_l();
                    if (((ICountWidget)((Object)this.widget)).useCount()) {
                        importedStack.field_77994_a = Math.min(importedStack.field_77994_a, this.getRemainingCount());
                    }
                    ItemStack remainder = IOHelper.insert(this.drone.getInventory(), importedStack.func_77946_l(), 0, simulate);
                    int removedItems = importedStack.field_77994_a - (remainder != null ? remainder.field_77994_a : 0);
                    if (!simulate) {
                        ItemStack newStack = stack.func_77946_l();
                        newStack.field_77994_a = stack.field_77994_a - removedItems;
                        inv.func_70299_a(i.intValue(), (ItemStack)(newStack.field_77994_a > 0 ? newStack : null));
                        this.decreaseCount(removedItems);
                        this.drone.addAir(null, -10);
                        if (!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() > 0) continue;
                        return false;
                    }
                    if (removedItems > 0) {
                        return true;
                    }
                    this.drone.addDebugEntry("gui.progWidget.inventoryImport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.addDebugEntry("gui.progWidget.inventoryImport.debug.stackdoesntPassFilter", pos);
            }
        } else {
            this.drone.addDebugEntry("gui.progWidget.inventory.debug.noInventory", pos);
        }
        return false;
    }
}

