/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.block.IPneumaticWrenchable;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.IComparatorSupport;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.FluidUtils;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.proxy.CommonProxy;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")
public abstract class BlockPneumaticCraft
extends BlockContainer
implements IPneumaticWrenchable,
IPeripheralProvider {
    protected BlockPneumaticCraft(Material par2Material) {
        super(par2Material);
        this.func_149658_d("pneumaticcraft:BlockPressureTube");
        this.func_149647_a(PneumaticCraft.tabPneumaticCraft);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        try {
            return this.getTileEntityClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Class<? extends TileEntity> getTileEntityClass();

    public CommonProxy.EnumGuiId getGuiID() {
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af() || this.getGuiID() == null || this.isRotatable() && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() == Itemss.manometer || ModInteractionUtils.getInstance().isModdedWrench(player.func_71045_bC().func_77973_b()))) {
            return false;
        }
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            ArrayList<ItemStack> returnedItems = new ArrayList<ItemStack>();
            if (te != null && !FluidUtils.tryInsertingLiquid(te, player.func_71045_bC(), player.field_71075_bZ.field_75098_d, returnedItems)) {
                player.openGui((Object)PneumaticCraft.instance, this.getGuiID().ordinal(), world, x, y, z);
            } else {
                if (player.func_71045_bC() != null && player.func_71045_bC().field_77994_a <= 0) {
                    player.func_70062_b(0, null);
                }
                for (ItemStack returnedItem : returnedItems) {
                    returnedItem = returnedItem.func_77946_l();
                    if (player.func_71045_bC() == null) {
                        player.func_70062_b(0, returnedItem);
                        continue;
                    }
                    player.field_71071_by.func_70441_a(returnedItem);
                }
            }
        }
        return true;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        if (this.isRotatable()) {
            int l = PneumaticCraftUtils.getDirectionFacing(par5EntityLiving, this.canRotateToTopOrBottom()).ordinal();
            par1World.func_72921_c(par2, par3, par4, l, 3);
        }
    }

    public boolean isRotatable() {
        return false;
    }

    protected boolean canRotateToTopOrBottom() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropInventory(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    protected void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        Random rand = new Random();
        for (int i = this.getInventoryDropStartSlot(inventory); i < this.getInventoryDropEndSlot(inventory); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    protected int getInventoryDropStartSlot(IInventory inventory) {
        return 0;
    }

    protected int getInventoryDropEndSlot(IInventory inventory) {
        return inventory.func_70302_i_();
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection side) {
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            world.func_147468_f(x, y, z);
            return true;
        }
        if (this.isRotatable()) {
            TileEntity te;
            int meta = world.func_72805_g(x, y, z);
            if (!this.rotateCustom(world, x, y, z, side, meta)) {
                int newMeta;
                if (this.rotateForgeWay()) {
                    if (!this.canRotateToTopOrBottom()) {
                        side = ForgeDirection.UP;
                    }
                    newMeta = ForgeDirection.getOrientation((int)meta).getRotation(side).ordinal();
                    world.func_72921_c(x, y, z, newMeta, 3);
                } else {
                    newMeta = (meta + 1) % 6;
                    if (!this.canRotateToTopOrBottom() && newMeta == 0) {
                        newMeta = 2;
                    }
                }
                world.func_72921_c(x, y, z, newMeta, 3);
            }
            if ((te = world.func_147438_o(x, y, z)) instanceof TileEntityBase) {
                ((TileEntityBase)te).onBlockRotated();
            }
            return true;
        }
        return false;
    }

    protected boolean rotateForgeWay() {
        return true;
    }

    protected boolean rotateCustom(World world, int x, int y, int z, ForgeDirection side, int meta) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te;
        if (world instanceof World && !((World)world).field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborTileUpdate();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity te;
        if (world instanceof World && !world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborBlockUpdate();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IPeripheral ? (IPeripheral)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List curInfo, boolean extraInfo) {
        String info;
        String translatedInfo;
        TileEntity te;
        if (PneumaticCraft.proxy.isSneakingInGui() && (te = this.func_149915_a(player.field_70170_p, 0)) instanceof TileEntityPneumaticBase) {
            float pressure = ((TileEntityPneumaticBase)te).DANGER_PRESSURE;
            curInfo.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.tooltip.maxPressure", (Object[])new Object[]{Float.valueOf(pressure)}));
        }
        if (!(translatedInfo = I18n.func_135052_a((String)(info = "gui.tab.info." + stack.func_77977_a()), (Object[])new Object[0])).equals(info)) {
            if (PneumaticCraft.proxy.isSneakingInGui()) {
                translatedInfo = EnumChatFormatting.AQUA + translatedInfo.substring(2);
                if (!Loader.isModLoaded((String)"IGWMod")) {
                    translatedInfo = translatedInfo + " \\n \\n" + I18n.func_135052_a((String)"gui.tab.info.assistIGW", (Object[])new Object[0]);
                }
                curInfo.addAll(PneumaticCraftUtils.convertStringIntoList(translatedInfo, 60));
            } else {
                curInfo.add(EnumChatFormatting.AQUA + I18n.func_135052_a((String)"gui.tooltip.sneakForInfo", (Object[])new Object[0]));
            }
        }
    }

    public boolean func_149740_M() {
        return IComparatorSupport.class.isAssignableFrom(this.getTileEntityClass());
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return ((IComparatorSupport)world.func_147438_o(x, y, z)).getComparatorValue(ForgeDirection.getOrientation((int)side));
    }
}

