/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.common.block.BlockPneumaticCraftModeled;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.block.tubes.ModuleRegistrator;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.block.tubes.TubeModuleRedstoneEmitting;
import pneumaticCraft.common.item.ItemTubeModule;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class BlockPressureTube
extends BlockPneumaticCraftModeled {
    public AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[6];
    private final float dangerPressure;
    private final float criticalPressure;
    private final int volume;

    public BlockPressureTube(Material par2Material, float dangerPressure, float criticalPressure, int volume) {
        super(par2Material);
        double width = 0.125;
        double height = 0.375;
        this.boundingBoxes[0] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.375 - height), (double)(0.5 - width), (double)(0.5 + width), (double)0.375, (double)(0.5 + width));
        this.boundingBoxes[1] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)0.625, (double)(0.5 - width), (double)(0.5 + width), (double)(0.625 + height), (double)(0.5 + width));
        this.boundingBoxes[2] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.5 - width), (double)(0.375 - height), (double)(0.5 + width), (double)(0.5 + width), (double)0.375);
        this.boundingBoxes[3] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.5 - width), (double)0.625, (double)(0.5 + width), (double)(0.5 + width), (double)(0.625 + height));
        this.boundingBoxes[4] = AxisAlignedBB.func_72330_a((double)(0.375 - height), (double)(0.5 - width), (double)(0.5 - width), (double)0.375, (double)(0.5 + width), (double)(0.5 + width));
        this.boundingBoxes[5] = AxisAlignedBB.func_72330_a((double)0.625, (double)(0.5 - width), (double)(0.5 - width), (double)(0.625 + height), (double)(0.5 + width), (double)(0.5 + width));
        this.dangerPressure = dangerPressure;
        this.criticalPressure = criticalPressure;
        this.volume = volume;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPressureTube.class;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPressureTube(this.dangerPressure, this.criticalPressure, this.volume);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TubeModule module;
        if (!world.field_72995_K && this.tryPlaceModule(player, world, x, y, z, par6, false)) {
            return true;
        }
        if (!player.func_70093_af() && (module = BlockPressureTube.getLookedModule(world, x, y, z, player)) != null) {
            return module.onActivated(player);
        }
        return false;
    }

    public boolean tryPlaceModule(EntityPlayer player, World world, int x, int y, int z, int par6, boolean simulate) {
        if (player.func_71045_bC() != null) {
            TubeModule module;
            if (player.func_71045_bC().func_77973_b() instanceof ItemTubeModule) {
                TileEntityPressureTube pressureTube = ModInteractionUtils.getInstance().getTube(world.func_147438_o(x, y, z));
                if (pressureTube.modules[par6] == null && ModInteractionUtils.getInstance().occlusionTest(this.boundingBoxes[par6], world.func_147438_o(x, y, z))) {
                    TubeModule module2 = ModuleRegistrator.getModule(((ItemTubeModule)player.func_71045_bC().func_77973_b()).moduleName);
                    if (simulate) {
                        module2.markFake();
                    }
                    pressureTube.setModule(module2, ForgeDirection.getOrientation((int)par6));
                    if (!simulate) {
                        this.func_149695_a(world, x, y, z, (Block)this);
                        world.func_147441_b(x, y, z, (Block)this, ForgeDirection.getOrientation((int)par6).getOpposite().ordinal());
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_71045_bC().field_77994_a;
                        }
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, Block.field_149778_k.func_150498_e(), Block.field_149778_k.func_150497_c() * 5.0f, Block.field_149778_k.func_150494_d() * 0.9f);
                    }
                    return true;
                }
            } else if (player.func_71045_bC().func_77973_b() == Itemss.advancedPCB && !simulate && (module = BlockPressureTube.getLookedModule(world, x, y, z, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
                if (!world.field_72995_K) {
                    module.upgrade();
                    if (!player.field_71075_bZ.field_75098_d) {
                        --player.func_71045_bC().field_77994_a;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static TubeModule getLookedModule(World world, int x, int y, int z, EntityPlayer player) {
        Pair<Vec3, Vec3> vecs = PneumaticCraftUtils.getStartAndEndLookVec((EntityLivingBase)player);
        MovingObjectPosition mop = Blockss.pressureTube.func_149731_a(world, x, y, z, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        if (mop != null && mop.hitInfo instanceof ForgeDirection && (ForgeDirection)mop.hitInfo != ForgeDirection.UNKNOWN) {
            TileEntityPressureTube tube = ModInteractionUtils.getInstance().getTube(world.func_147438_o(x, y, z));
            return tube.modules[((ForgeDirection)mop.hitInfo).ordinal()];
        }
        return null;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        MovingObjectPosition bestMOP = null;
        AxisAlignedBB bestAABB = null;
        this.func_149676_a(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        MovingObjectPosition mop = super.func_149731_a(world, x, y, z, origin, direction);
        if (this.isCloserMOP(origin, bestMOP, mop)) {
            bestMOP = mop;
            bestAABB = AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G);
        }
        TileEntityPressureTube tube = ModInteractionUtils.getInstance().getTube(world.func_147438_o(x, y, z));
        for (int i = 0; i < 6; ++i) {
            if (!tube.sidesConnected[i]) continue;
            this.setBlockBounds(this.boundingBoxes[i]);
            mop = super.func_149731_a(world, x, y, z, origin, direction);
            if (!this.isCloserMOP(origin, bestMOP, mop)) continue;
            bestMOP = mop;
            bestAABB = AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G);
        }
        if (bestMOP != null) {
            bestMOP.hitInfo = ForgeDirection.UNKNOWN;
        }
        TubeModule[] modules = tube.modules;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (modules[dir.ordinal()] == null) continue;
            this.setBlockBounds(modules[dir.ordinal()].boundingBoxes[dir.ordinal()]);
            mop = super.func_149731_a(world, x, y, z, origin, direction);
            if (!this.isCloserMOP(origin, bestMOP, mop)) continue;
            mop.hitInfo = dir;
            bestMOP = mop;
            bestAABB = AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G);
        }
        if (bestAABB != null) {
            this.setBlockBounds(bestAABB);
        }
        return bestMOP;
    }

    private boolean isCloserMOP(Vec3 origin, MovingObjectPosition originalMOP, MovingObjectPosition newMOP) {
        if (newMOP == null) {
            return false;
        }
        if (originalMOP == null) {
            return true;
        }
        return PneumaticCraftUtils.distBetween(origin, newMOP.field_72307_f) < PneumaticCraftUtils.distBetween(origin, originalMOP.field_72307_f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (target.hitInfo == ForgeDirection.UNKNOWN) {
            return super.getPickBlock(target, world, x, y, z);
        }
        TileEntityPressureTube tube = (TileEntityPressureTube)world.func_147438_o(x, y, z);
        return new ItemStack(ModuleRegistrator.getModuleItem(tube.modules[((ForgeDirection)target.hitInfo).ordinal()].getType()));
    }

    private void setBlockBounds(AxisAlignedBB aabb) {
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection side) {
        TileEntityPressureTube tube = ModInteractionUtils.getInstance().getTube(world.func_147438_o(x, y, z));
        if (player.func_70093_af()) {
            TubeModule module = BlockPressureTube.getLookedModule(world, x, y, z, player);
            if (module != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    List<ItemStack> drops = module.getDrops();
                    for (ItemStack drop : drops) {
                        EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                        entity.func_92058_a(drop);
                        world.func_72838_d((Entity)entity);
                        entity.func_70100_b_(player);
                    }
                }
                tube.setModule(null, module.getDirection());
                this.func_149695_a(world, x, y, z, (Block)this);
                world.func_147441_b(x, y, z, (Block)this, module.getDirection().getOpposite().ordinal());
                return true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(tube.maxPressure <= 7.0f ? Blockss.pressureTube : Blockss.advancedPressureTube));
                world.func_72838_d((Entity)entity);
                entity.func_70100_b_(player);
            }
            ModInteractionUtils.getInstance().removeTube(world.func_147438_o(x, y, z));
            return true;
        }
        return super.rotateBlock(world, player, x, y, z, side);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        List<ItemStack> drops = BlockPressureTube.getModuleDrops((TileEntityPressureTube)world.func_147438_o(x, y, z));
        for (ItemStack drop : drops) {
            EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            entity.func_92058_a(drop);
            world.func_72838_d((Entity)entity);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public static List<ItemStack> getModuleDrops(TileEntityPressureTube tube) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (TubeModule module : tube.modules) {
            if (module == null) continue;
            drops.addAll(module.getDrops());
        }
        return drops;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.func_149676_a(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        TileEntity te = world.func_147438_o(x, y, z);
        TileEntityPressureTube tePt = (TileEntityPressureTube)te;
        for (int i = 0; i < 6; ++i) {
            if (tePt.sidesConnected[i]) {
                this.setBlockBounds(this.boundingBoxes[i]);
                super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
                continue;
            }
            if (tePt.modules[i] == null) continue;
            this.setBlockBounds(tePt.modules[i].boundingBoxes[i]);
            super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityPressureTube) {
            TileEntityPressureTube tePt = (TileEntityPressureTube)te;
            tePt.updateConnections(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        if (te instanceof TileEntityPressureTube) {
            TileEntityPressureTube tePt = (TileEntityPressureTube)te;
            int l = 0;
            for (TubeModule module : tePt.modules) {
                if (module == null) continue;
                l = Math.max(l, module.getRedstoneLevel());
            }
            if (l > 0) {
                double d0 = (double)par2 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                double d1 = (double)par3 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                double d2 = (double)par4 + 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                float f = (float)l / 15.0f;
                float f1 = f * 0.6f + 0.4f;
                float f2 = f * f * 0.7f - 0.5f;
                float f3 = f * f * 0.6f - 0.7f;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                if (f3 < 0.0f) {
                    f3 = 0.0f;
                }
                par1World.func_72869_a("reddust", d0, d1, d2, (double)f1, (double)f2, (double)f3);
            }
        }
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return 0;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int side) {
        TileEntity te = par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (te instanceof TileEntityPressureTube) {
            TileEntityPressureTube tePt = (TileEntityPressureTube)te;
            int redstoneLevel = 0;
            for (int i = 0; i < 6; ++i) {
                if (tePt.modules[i] == null || (side ^ 1) != i && (i == side || !tePt.modules[i].isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tePt.modules[i].getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int i;
        if (side < 0 || side > 3) {
            return false;
        }
        TileEntityPressureTube tube = (TileEntityPressureTube)world.func_147438_o(x, y, z);
        ForgeDirection d = ForgeDirection.NORTH;
        for (i = 0; i < side; ++i) {
            d = d.getRotation(ForgeDirection.UP);
        }
        side = d.ordinal();
        for (i = 0; i < 6; ++i) {
            if (tube.modules[i] == null || (side ^ 1) != i && (i == side || !tube.modules[i].isInline()) || !(tube.modules[i] instanceof TubeModuleRedstoneEmitting)) continue;
            return true;
        }
        return false;
    }
}

