/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.pneumaticPlants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.BlockPressureTube;
import pneumaticCraft.common.block.pneumaticPlants.BlockPlants;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.ItemPlasticPlants;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;

public abstract class BlockPneumaticPlantBase
extends BlockFlower
implements IGrowable {
    IIcon[] texture;

    protected BlockPneumaticPlantBase() {
        super(0);
        this.func_149675_a(true);
        float var3 = 0.5f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.25f, 0.5f + var3);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149649_H();
        if (this.isPlantHanging()) {
            this.func_149676_a(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        BlockPlants.allPlants.add(this);
    }

    public void func_149651_a(IIconRegister register) {
        this.texture = new IIcon[7];
        for (int i = 0; i < 7; ++i) {
            this.texture[i] = register.func_94245_a(this.getTextureString() + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 14) {
            return this.texture[6];
        }
        return this.texture[meta % 7];
    }

    protected abstract String getTextureString();

    protected abstract boolean canGrowWithLightValue(int var1);

    protected boolean skipGrowthCheck(World world, int x, int y, int z) {
        return false;
    }

    public boolean isPlantHanging() {
        return false;
    }

    public void executeFullGrownEffect(World world, int x, int y, int z, Random rand) {
    }

    public boolean canPlantGrowOnThisBlock(Block block, World world, int x, int y, int z) {
        return block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (!world.field_72995_K) {
            float var7 = this.getGrowthRate(world, x, y, z);
            if (this.canGrowWithLightValue(world.func_72957_l(x, y, z)) && rand.nextInt((int)(25.0f / var7) + 1) == 0 || this.skipGrowthCheck(world, x, y, z)) {
                int meta = world.func_72805_g(x, y, z);
                if (meta < 13) {
                    if (meta != 6) {
                        world.func_72921_c(x, y, z, ++meta, 3);
                    }
                } else if (meta == 13 && rand.nextInt(5) == 0) {
                    world.func_72921_c(x, y, z, 6, 0);
                } else if (Config.configPlantFullGrownEffect[this.getSeedDamage()] || this.skipGrowthCheck(world, x, y, z)) {
                    this.executeFullGrownEffect(world, x, y, z, rand);
                }
            }
        }
    }

    protected void spawnParticle(String particleName, World world, double spawnX, double spawnY, double spawnZ, double spawnMotX, double spawnMotY, double spawnMotZ) {
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(particleName, spawnX, spawnY, spawnZ, spawnMotX, spawnMotY, spawnMotZ), world);
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        Block soil = par1World.func_147439_a(par2, par3 - (this.isPlantHanging() ? -1 : 1), par4);
        return this.canGrowWithLightValue(par1World.func_72883_k(par2, par3, par4)) && soil != null && this.canPlantGrowOnThisBlock(soil, par1World, par2, par3, par4);
    }

    protected float getGrowthRate(World world, int x, int y, int z) {
        float growthFactor = 1.0f;
        Block var6 = world.func_147439_a(x, y, z - 1);
        Block var7 = world.func_147439_a(x, y, z + 1);
        Block var8 = world.func_147439_a(x - 1, y, z);
        Block var9 = world.func_147439_a(x + 1, y, z);
        Block var10 = world.func_147439_a(x - 1, y, z - 1);
        Block var11 = world.func_147439_a(x + 1, y, z - 1);
        Block var12 = world.func_147439_a(x + 1, y, z + 1);
        Block var13 = world.func_147439_a(x - 1, y, z + 1);
        boolean var14 = var8 == this || var9 == this;
        boolean var15 = var6 == this || var7 == this;
        boolean var16 = var10 == this || var11 == this || var12 == this || var13 == this;
        for (int var17 = x - 1; var17 <= x + 1; ++var17) {
            for (int var18 = z - 1; var18 <= z + 1; ++var18) {
                Block var19 = world.func_147439_a(var17, y - 1, var18);
                float var20 = 0.0f;
                if (var19.canSustainPlant((IBlockAccess)world, var17, y - (this.isPlantHanging() ? -1 : 1), var18, ForgeDirection.UP, (IPlantable)this)) {
                    var20 = 1.0f;
                    if (var19.isFertile(world, var17, y - (this.isPlantHanging() ? -1 : 1), var18)) {
                        var20 = 3.0f;
                    }
                }
                if (var17 != x || var18 != z) {
                    var20 /= 4.0f;
                }
                growthFactor += var20;
            }
        }
        if (var16 || var14 && var15) {
            growthFactor /= 2.0f;
        }
        return growthFactor;
    }

    public int func_149645_b() {
        return 1;
    }

    protected abstract int getSeedDamage();

    public int func_149643_k(World par1World, int par2, int par3, int par4) {
        return this.getSeedDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Itemss.plasticPlant;
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            if (((Boolean)this.captureDrops.get()).booleanValue()) {
                ((List)this.capturedDrops.get()).add(stack);
                return;
            }
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
            ItemPlasticPlants.markInactive(entityitem);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int seedDamage = this.getSeedDamage();
        ret.add(new ItemStack(Itemss.plasticPlant, 1, seedDamage));
        if (metadata == 6 || metadata == 13) {
            ret.add(new ItemStack(Itemss.plasticPlant, world.field_73012_v.nextInt(2) + 1, seedDamage));
        }
        return ret;
    }

    public void attemptFarmByAirGrate(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6 || meta == 13) {
            this.func_149642_a(world, x, y, z, this.getDrops(world, x, y, z, 0, 0).get(0));
            world.func_72921_c(x, y, z, world.field_73012_v.nextInt(5), 3);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVect, Vec3 endVect) {
        Block b = world.func_147439_a((int)Math.floor(endVect.field_72450_a), (int)Math.floor(endVect.field_72448_b), (int)Math.floor(endVect.field_72449_c));
        if (b instanceof BlockPressureTube) {
            return null;
        }
        return super.func_149731_a(world, x, y, z, startVect, endVect);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return this.canApplyBonemeal(world.func_72805_g(x, y, z));
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return this.canApplyBonemeal(world.func_72805_g(x, y, z));
    }

    private boolean canApplyBonemeal(int meta) {
        return meta <= 13;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.executeGrowthStep(world, x, y, z, rand);
    }

    private void executeGrowthStep(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6 || meta == 13) {
            world.func_72921_c(x, y, z, 13, 0);
            this.executeFullGrownEffect(world, x, y, z, world.field_73012_v);
        } else {
            int l = meta + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
            if (meta < 6 && l > 6) {
                l = 6;
            } else if (meta > 6 && l > 13) {
                l = 13;
            }
            world.func_72921_c(x, y, z, l, 3);
        }
    }
}

