/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.model.tubemodules.ModelCharging;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.TileEntityCache;
import pneumaticCraft.proxy.CommonProxy;

public class ModuleCharging
extends TubeModule {
    private final IBaseModel model = new ModelCharging();
    private TileEntityCache connectedInventory;

    @Override
    public String getType() {
        return "chargingModule";
    }

    @Override
    public IBaseModel getModel() {
        return this.model;
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return null;
    }

    @Override
    public void update() {
        super.update();
        IInventory inv = this.getConnectedInventory();
        if (inv != null) {
            int[] accessibleSlots = IOHelper.getAccessibleSlotsForInventory(inv, this.dir.getOpposite());
            for (int i = 0; i < (this.upgraded ? 10 : 1) * 10; ++i) {
                boolean charged = false;
                for (int slot : accessibleSlots) {
                    ItemStack chargedItem = inv.func_70301_a(slot);
                    if (chargedItem == null || !(chargedItem.func_77973_b() instanceof IPressurizable)) continue;
                    IPressurizable chargingItem = (IPressurizable)chargedItem.func_77973_b();
                    IAirHandler airHandler = this.pressureTube.getAirHandler();
                    if (chargingItem.getPressure(chargedItem) > airHandler.getPressure(ForgeDirection.UNKNOWN) + 0.01f && chargingItem.getPressure(chargedItem) > 0.0f) {
                        chargingItem.addAir(chargedItem, -1);
                        airHandler.addAir(1, ForgeDirection.UNKNOWN);
                        charged = true;
                        continue;
                    }
                    if (!(chargingItem.getPressure(chargedItem) < airHandler.getPressure(ForgeDirection.UNKNOWN) - 0.01f) || !(chargingItem.getPressure(chargedItem) < chargingItem.maxPressure(chargedItem))) continue;
                    chargingItem.addAir(chargedItem, 1);
                    airHandler.addAir(-1, ForgeDirection.UNKNOWN);
                    charged = true;
                }
                if (!charged) break;
            }
        }
    }

    @Override
    public void onNeighborTileUpdate() {
        this.connectedInventory = null;
    }

    private IInventory getConnectedInventory() {
        if (this.connectedInventory == null) {
            this.connectedInventory = new TileEntityCache(this.pressureTube.world(), this.pressureTube.x() + this.dir.offsetX, this.pressureTube.y() + this.dir.offsetY, this.pressureTube.z() + this.dir.offsetZ);
        }
        return this.connectedInventory.getTileEntity() instanceof IInventory ? (IInventory)this.connectedInventory.getTileEntity() : null;
    }
}

