/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.model.tubemodules.ModelGauge;
import pneumaticCraft.common.block.tubes.TubeModuleRedstoneEmitting;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketUpdatePressureBlock;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.proxy.CommonProxy;

public class ModulePressureGauge
extends TubeModuleRedstoneEmitting {
    private final IBaseModel model = new ModelGauge(this);

    public ModulePressureGauge() {
        this.lowerBound = 0.0f;
        this.higherBound = 7.5f;
    }

    @Override
    public void update() {
        super.update();
        if (!this.pressureTube.world().field_72995_K) {
            if (this.pressureTube.world().func_82737_E() % 20L == 0L) {
                NetworkHandler.sendToAllAround(new PacketUpdatePressureBlock((TileEntityPneumaticBase)this.getTube()), this.getTube().world());
            }
            this.setRedstone(this.getRedstone(this.pressureTube.getAirHandler().getPressure(ForgeDirection.UNKNOWN)));
        }
    }

    private int getRedstone(float pressure) {
        return (int)((pressure - this.lowerBound) / (this.higherBound - this.lowerBound) * 15.0f);
    }

    @Override
    public String getType() {
        return "pressureGaugeModule";
    }

    @Override
    public IBaseModel getModel() {
        return this.model;
    }

    @Override
    public double getWidth() {
        return 0.5;
    }

    @Override
    protected double getHeight() {
        return 0.25;
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(EnumChatFormatting.BLUE + "Formula: Redstone = 2.0 x pressure(bar)");
        curInfo.add("This module emits a redstone signal of which");
        curInfo.add("the strength is dependant on how much pressure");
        curInfo.add("the tube is at.");
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        return super.onActivated(player);
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return CommonProxy.EnumGuiId.PRESSURE_MODULE;
    }
}

