/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.config.AmadronOfferPeriodicConfig;
import pneumaticCraft.common.config.AmadronOfferSettings;
import pneumaticCraft.common.config.AmadronOfferStaticConfig;
import pneumaticCraft.common.config.ISubConfig;
import pneumaticCraft.common.config.ProgWidgetConfig;
import pneumaticCraft.common.item.ItemPlasticPlants;
import pneumaticCraft.lib.Log;

public class Config {
    public static Configuration config;
    public static int villagerMechanicID;
    public static boolean[] configPlantFullGrownEffect;
    public static double[] configPlantGenerationChance;
    public static boolean includePlantsOnBonemeal;
    public static boolean allowDirtBonemealing;
    public static double oilGenerationChance;
    public static boolean shouldDisplayChangeNotification;
    public static boolean stopDroneAI;
    public static boolean disableKeroseneLampFakeAirBlock;
    public static int configCompressedIngotLossRate;
    public static int elevatorBaseBlocksPerBase;
    public static boolean useHelmetModel;
    private static int programmerDifficulty;
    public static boolean enableUpdateChecker;
    public static boolean convertMultipartsToBlocks;
    public static int pneumaticGeneratorEfficiency;
    public static int electricCompressorEfficiency;
    public static int pneumaticEngineEfficiency;
    public static int kineticCompressorEfficiency;
    public static int pneumaticPumpEfficiency;
    public static int fluxCompressorEfficiency;
    public static int pneumaticDynamoEfficiency;
    public static boolean enableElectricCompressorRecipe;
    public static boolean enablePneumaticGeneratorRecipe;
    public static boolean enablePneumaticPumpRecipe;
    public static boolean enableCreeperPlantMaceratorRecipe;
    public static boolean enableHeliumPlantMaceratorRecipe;
    public static boolean enableFlyingFlowerExtractorRecipe;
    public static boolean enablePropulsionPlantExtractorRecipe;
    public static boolean enableCoalToDiamondsRecipe;
    public static boolean enableDroneSuffocationDamage;
    public static boolean enableCreeperDropExplosion;
    public static boolean enableSlimeSeedDrop;
    public static boolean enableCreeperSeedDrop;
    public static boolean enableSquidSeedDrop;
    public static boolean enableEndermanSeedDrop;
    public static boolean enableDungeonLoot;
    public static float configMinigunDamage;
    public static final String[] CATEGORIES;
    public static List<String> NO_MC_RESTART_CATS;
    private static ISubConfig[] subConfigs;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("PneumaticCraft")) {
            Config.init(null);
        }
    }

    public static void init(File configFile) {
        int i;
        if (configFile != null) {
            File oldConfig = new File(configFile.getAbsolutePath().replace("PneumaticCraft", "Minemaarten_PneumaticCraft"));
            if (oldConfig.exists()) {
                configFile = oldConfig;
            }
            config = new Configuration(configFile);
            config.load();
            for (ISubConfig subConfig : subConfigs) {
                File subFolder = new File(configFile.getAbsolutePath().substring(0, configFile.getAbsolutePath().length() - 4) + File.separator);
                subFolder.mkdirs();
                File subFile = new File(subFolder, subConfig.getFolderName() + ".cfg");
                try {
                    subConfig.init(subFile);
                }
                catch (IOException e) {
                    Log.error("Config file " + subConfig.getFolderName() + " failed to create! Unexpected things can happen!");
                    e.printStackTrace();
                }
            }
        }
        boolean foundConfigWithoutOil = !config.hasKey("general", "oil_generation_chance");
        oilGenerationChance = config.get("general", "oil_generation_chance", 15.0, "Chance per chunk in percentage to generate an Oil Lake. Set to 0 for no spawns").getDouble();
        config.addCustomCategoryComment("plant_full-grown_effects", "When true, the plant is allowed to execute its full-grown effect. (When false bonemeal still works though)");
        for (i = 0; i < 16; ++i) {
            Property prop = config.get("plant_full-grown_effects", ItemPlasticPlants.PLANT_NAMES[i], false);
            Config.configPlantFullGrownEffect[i] = prop.getBoolean(false);
            if (!foundConfigWithoutOil || !configPlantFullGrownEffect[i]) continue;
            prop.set(false);
            Config.configPlantFullGrownEffect[i] = false;
            shouldDisplayChangeNotification = true;
        }
        config.addCustomCategoryComment("plant_generation_options", "The percentage chance of plant groups to spawn per chunk. 0 for no spawns, 100 for a group for every chunk");
        for (i = 0; i < 16; ++i) {
            if (!ItemPlasticPlants.NEEDS_GENERATION[i]) continue;
            double defaultValue = 0.0;
            Property prop = config.get("plant_generation_options", ItemPlasticPlants.PLANT_NAMES[i], defaultValue);
            Config.configPlantGenerationChance[i] = prop.getDouble() / 100.0;
            if (!foundConfigWithoutOil || !(configPlantGenerationChance[i] > 0.0)) continue;
            prop.set(0.0);
            Config.configPlantGenerationChance[i] = 0.0;
            shouldDisplayChangeNotification = true;
        }
        Property property = config.get("general", "Compressed Iron Loss Percentage", 20);
        property.comment = "Loss percentage (on average) of Compressed Iron ingots/blocks when exposed to an explosion.";
        configCompressedIngotLossRate = property.getInt();
        property = config.get("general", "Enable Dungeon Loot generation", true);
        property.comment = "Enables the dungeon loot generation of the Nuke Virus and Stop! Worm. Useless items when playing SSP.";
        enableDungeonLoot = property.getBoolean();
        useHelmetModel = config.getBoolean("Use Pneumatic Helmet model", "general", false, "When true, the Pneumatic Helmet will be a model. Warning: this model looks far too good to be in MC");
        programmerDifficulty = config.getInt("Programmer Difficulty", "general", 0, 0, 2, "Defines the difficulty of the programmer shown to the user. 0 = easy, 1 = medium, 2 = advanced");
        property = config.get("general", "Villager Mechanic ID", 125);
        property.comment = "Villager ID used for the Mechanic Villager. Change when ID collides with an other mod which adds villagers.";
        villagerMechanicID = property.getInt();
        property = config.get("general", "Minigun damage", 4.0);
        property.comment = "Damage of the Miniguns. This applies to the Sentry Gun, Handheld Minigun, and Drone-based minigun.";
        configMinigunDamage = (float)property.getDouble();
        property = config.get("Machine_Properties", "Pneumatic Generator (PneumaticCraft --> IC2) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air usage of the Pneumatic Generator. The output, EU, will stay the same.";
        pneumaticGeneratorEfficiency = property.getInt();
        property = config.get("machine_properties", "Electric Compressor (IC2 --> PneumaticCraft) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air production of the Electric Compressor. The input, EU, will stay the same.";
        electricCompressorEfficiency = property.getInt();
        property = config.get("machine_properties", "Pneumatic Engine (PneumaticCraft --> Buildcraft) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air usage of the Pneumatic Engine. The output, MJ, will stay the same.";
        pneumaticEngineEfficiency = property.getInt();
        property = config.get("machine_properties", "Kinetic Compressor (Buildcraft --> PneumaticCraft) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air production of the Kinetic Compressor. The input, MJ, will stay the same.";
        kineticCompressorEfficiency = property.getInt();
        property = config.get("machine_properties", "Pneumatic Dynamo (PneumaticCraft --> RF) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air usage of the Pneumatic Dynamo. The output, RF, will stay the same.";
        pneumaticDynamoEfficiency = property.getInt();
        property = config.get("machine_properties", "Flux Compressor (RF --> PneumaticCraft) efficiency", 40);
        property.comment = "Changing this value will alter the pressurized air production of the Flux Compressor. The input, RF, will stay the same.";
        fluxCompressorEfficiency = property.getInt();
        property = config.get("machine_properties", "Pneumatic Pump (PneumaticCraft --> Hydraulicraft) efficiency", 40);
        property.comment = "Changing this value will alter the hydraulic bar production of the Pneumatic Pump. The input, air, will stay the same.";
        pneumaticPumpEfficiency = property.getInt();
        elevatorBaseBlocksPerBase = config.getInt("Height per Elevator Base", "machine_properties", 4, 1, 256, "The max height of an elevator per stacked Elevator Base.");
        property = config.get("advanced", "Convert Multiparts to Blocks", false);
        property.comment = "ONLY SET TO TRUE WHEN YOU KNOW WHAT YOU'RE DOING. When set to true, this will convert any Pressure Tube in the world that was a FMP to its block variant. Handy when you're about to remove FMP from the instance. This will remove any other parts from the block like covers. Exception are tube modules.";
        convertMultipartsToBlocks = property.getBoolean(true);
        property = config.get("advanced", "Stop Drone AI", false);
        property.comment = "When set to true, Drones will not execute any program. This is useful to set to true when due to a bug Drones are lagging your server or crashing it. Please report the bug if you encounter it.";
        stopDroneAI = property.getBoolean(true);
        property = config.get("advanced", "Disable Kerosene Lamp Fake Air Block", false);
        property.comment = "When set to true, the Kerosene Lamp's fake air blocks won't be registered and therefore removed from the world. Useful if this causes trouble (it shouldn't though)";
        disableKeroseneLampFakeAirBlock = property.getBoolean(true);
        enableUpdateChecker = config.get("general", "Enable Update Checker", true).getBoolean(true);
        enableDroneSuffocationDamage = config.get("general", "Enable Drone Suffocation Damage", true).getBoolean(true);
        enableCreeperDropExplosion = config.getBoolean("Enable Creeper Explosions on seed drop", "general", false, "When true, Creepers when dropping a Creeper Plant Seed will create a tiny explosion.");
        enableCreeperSeedDrop = config.get("general", "Enable Creeper Seed Drops", false).getBoolean(true);
        enableSlimeSeedDrop = config.get("general", "Enable Slime Seed Drops", false).getBoolean(true);
        enableEndermanSeedDrop = config.get("general", "Enable Enderman Seed Drops", false).getBoolean(true);
        enableSquidSeedDrop = config.get("general", "Enable Squid Seed Drops", false).getBoolean(true);
        includePlantsOnBonemeal = config.get("general", "Include Plastic Plants on bonemealing", false).getBoolean(true);
        allowDirtBonemealing = config.get("general", "Allow dirt to be bonemealed for plastic plants", false).getBoolean(true);
        if (foundConfigWithoutOil && (enableCreeperDropExplosion || enableCreeperSeedDrop || enableSlimeSeedDrop || enableEndermanSeedDrop || enableSquidSeedDrop || includePlantsOnBonemeal || allowDirtBonemealing)) {
            allowDirtBonemealing = false;
            includePlantsOnBonemeal = false;
            enableSquidSeedDrop = false;
            enableEndermanSeedDrop = false;
            enableSlimeSeedDrop = false;
            enableCreeperSeedDrop = false;
            enableCreeperDropExplosion = false;
            config.get("general", "Enable Creeper Explosions on seed drop", true, "When true, Creepers when dropping a Creeper Plant Seed will create a tiny explosion.").set(false);
            config.get("general", "Enable Creeper Seed Drops", true).set(false);
            config.get("general", "Enable Slime Seed Drops", true).set(false);
            config.get("general", "Enable Enderman Seed Drops", true).set(false);
            config.get("general", "Enable Squid Seed Drops", true).set(false);
            config.get("general", "Include Plastic Plants on bonemealing", true).set(false);
            config.get("general", "Allow dirt to be bonemealed for plastic plants", true).set(false);
            shouldDisplayChangeNotification = true;
        }
        if (shouldDisplayChangeNotification) {
            Log.warning("Disabled world generation of plants and plant mob drops in the config automatically, oil is turned on as replacement. This is only done once, you can change it as you wish now.");
        }
        enableCoalToDiamondsRecipe = config.get("recipe_enabling", "8 Block of Coal --> 1 Diamond (Pressure Chamber)", true).getBoolean(true);
        enableElectricCompressorRecipe = config.get("recipe_enabling", "Electric Compressor", true).getBoolean(true);
        enablePneumaticGeneratorRecipe = config.get("recipe_enabling", "Pneumatic Generator", true).getBoolean(true);
        enablePneumaticPumpRecipe = config.get("recipe_enabling", "Pneumatic Pump", true).getBoolean(true);
        enableCreeperPlantMaceratorRecipe = config.get("recipe_enabling", "Creeper Plant Seeds --> Gunpowder (IC2 Macerator)", true).getBoolean(true);
        enableHeliumPlantMaceratorRecipe = config.get("recipe_enabling", "Helium Plant Seeds --> Glowstone (IC2 Macerator)", true).getBoolean(true);
        enableFlyingFlowerExtractorRecipe = config.get("recipe_enabling", "Flying Flower Seeds --> Feather (IC2 Extractor)", true).getBoolean(true);
        enablePropulsionPlantExtractorRecipe = config.get("recipe_enabling", "Propulsion Plant Seeds --> Sugar (IC2 Extractor)", true).getBoolean(true);
        PneumaticCraft.proxy.initConfig(config);
        config.save();
    }

    public static void postInit() {
        for (ISubConfig subConfig : subConfigs) {
            try {
                subConfig.postInit();
            }
            catch (IOException e) {
                Log.error("Config file " + subConfig.getFolderName() + " failed to create! Unexpected things can happen!");
                e.printStackTrace();
            }
        }
    }

    public static void setProgrammerDifficulty(int difficulty) {
        config.get("general", "Programmer Difficulty", 0).set(difficulty);
        Config.init(null);
    }

    public static int getProgrammerDifficulty() {
        return programmerDifficulty;
    }

    static {
        configPlantFullGrownEffect = new boolean[16];
        configPlantGenerationChance = new double[16];
        CATEGORIES = new String[]{"general", "plant_full-grown_effects", "plant_generation_options", "machine_properties", "advanced", "recipe_enabling", "third_party_enabling"};
        NO_MC_RESTART_CATS = Arrays.asList("plant_full-grown_effects", "plant_generation_options", "machine_properties");
        subConfigs = new ISubConfig[]{new AmadronOfferSettings(), AmadronOfferStaticConfig.INSTANCE, new AmadronOfferPeriodicConfig(), new ProgWidgetConfig()};
    }
}

