/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.entity.living;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.ChunkPosition;

public class DebugEntry
implements Comparable<DebugEntry> {
    private static int curId;
    private final int id;
    private final int progWidgetId;
    private final String message;
    private final ChunkPosition pos;

    public DebugEntry(String message, int progWidgetId, ChunkPosition pos) {
        this.message = message;
        this.pos = pos != null ? pos : new ChunkPosition(0, 0, 0);
        this.progWidgetId = progWidgetId;
        this.id = curId++;
    }

    public DebugEntry(ByteBuf buf) {
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new ChunkPosition(buf.readInt(), buf.readInt(), buf.readInt());
        this.id = buf.readInt();
        this.progWidgetId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        buf.writeInt(this.pos.field_151329_a);
        buf.writeInt(this.pos.field_151327_b);
        buf.writeInt(this.pos.field_151328_c);
        buf.writeInt(this.id);
        buf.writeInt(this.progWidgetId);
    }

    public String getMessage() {
        return this.message;
    }

    public ChunkPosition getPos() {
        return this.pos;
    }

    public int getProgWidgetId() {
        return this.progWidgetId;
    }

    public int hashcode() {
        return this.id;
    }

    public boolean equals(Object other) {
        return other instanceof DebugEntry ? ((DebugEntry)other).id == this.id : false;
    }

    @Override
    public int compareTo(DebugEntry o) {
        return Integer.compare(this.id, o.id);
    }
}

