/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.fluid;

import java.util.ArrayList;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.fluid.FluidPneumaticCraft;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.ItemPlasticPlants;
import pneumaticCraft.common.item.Itemss;

public class FluidPlastic
extends FluidPneumaticCraft {
    public FluidPlastic(String name) {
        super(name);
        this.setTemperature(423);
    }

    public int getColor(FluidStack plastic) {
        return FluidPlastic.getColorS(plastic);
    }

    public static int getColorS(FluidStack plastic) {
        return plastic.tag != null ? plastic.tag.func_74762_e("color") : 0xFFFFFF;
    }

    private static int[] getColor3(FluidStack plastic) {
        int color = FluidPlastic.getColorS(plastic);
        return new int[]{color >> 16, color >> 8 & 0xFF, color & 0xFF};
    }

    public int getTemperature(FluidStack plastic) {
        return FluidPlastic.getTemperatureS(plastic);
    }

    public static int getTemperatureS(FluidStack plastic) {
        return 424;
    }

    public static void addDye(FluidStack plastic, int dyeMetadata) {
        if (!Fluids.areFluidsEqual(plastic.getFluid(), Fluids.plastic)) {
            throw new IllegalArgumentException("Given fluid stack isn't mixable! " + plastic);
        }
        int dyeColor = ItemDye.field_150922_c[dyeMetadata];
        int[] dyeColors = new int[]{dyeColor >> 16, dyeColor >> 8 & 0xFF, dyeColor & 0xFF};
        int[] plasticColor = FluidPlastic.getColor3(plastic);
        double ratio = 0.2 / (0.2 * ((double)plastic.amount / 1000.0));
        for (int i = 0; i < 3; ++i) {
            plasticColor[i] = (int)(ratio * (double)dyeColors[i] + (1.0 - ratio) * (double)plasticColor[i]);
        }
        if (plastic.tag == null) {
            plastic.tag = new NBTTagCompound();
        }
        plastic.tag.func_74768_a("color", (plasticColor[0] << 16) + (plasticColor[1] << 8) + plasticColor[2]);
    }

    public static FluidStack mixFluid(FluidStack plastic, FluidStack otherPlastic) {
        if (plastic == null) {
            return otherPlastic;
        }
        if (otherPlastic == null) {
            return plastic;
        }
        int[] otherColor = FluidPlastic.getColor3(otherPlastic);
        int[] color = FluidPlastic.getColor3(plastic);
        double ratio = (double)plastic.amount / (double)(plastic.amount + otherPlastic.amount);
        int[] newColor = new int[3];
        for (int i = 0; i < 3; ++i) {
            newColor[i] = (int)(ratio * (double)color[i] + (1.0 - ratio) * (double)otherColor[i]);
        }
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74768_a("color", (newColor[0] << 16) + (newColor[1] << 8) + newColor[2]);
        return new FluidStack(Fluids.plastic, plastic.amount + otherPlastic.amount, newTag);
    }

    public static int getPlasticMeta(FluidStack plastic) {
        int[] dyeColors = ItemDye.field_150922_c;
        int[] plasticColor = FluidPlastic.getColor3(plastic);
        int bestMatching = -1;
        double closestGap = Double.MAX_VALUE;
        ArrayList plasticTypes = new ArrayList();
        ((ItemPlasticPlants)Itemss.plasticPlant).addSubItems(plasticTypes);
        for (ItemStack s : plasticTypes) {
            int i = s.func_77960_j();
            double gap = Math.pow(plasticColor[0] - (dyeColors[i] >> 16), 2.0) + Math.pow(plasticColor[1] - (dyeColors[i] >> 8 & 0xFF), 2.0) + Math.pow(plasticColor[2] - (dyeColors[i] & 0xFF), 2.0);
            if (!(gap < closestGap)) continue;
            closestGap = gap;
            bestMatching = i;
        }
        return bestMatching;
    }
}

