/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.common.config.AmadronOfferSettings;
import pneumaticCraft.common.config.AmadronOfferStaticConfig;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.inventory.ContainerPneumaticBase;
import pneumaticCraft.common.inventory.SlotUntouchable;
import pneumaticCraft.common.item.ItemAmadronTablet;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketAmadronTradeRemoved;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.common.recipes.AmadronOfferManager;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.proxy.CommonProxy;

public class ContainerAmadron
extends ContainerPneumaticBase {
    public static final int ROWS = 4;
    public List<AmadronOffer> offers = new ArrayList<AmadronOffer>(AmadronOfferManager.getInstance().getAllOffers());
    private final InventoryBasic inv = new InventoryBasic("amadron", true, 16);
    @GuiSynced
    private final int[] shoppingItems = new int[8];
    @GuiSynced
    private final int[] shoppingAmounts = new int[8];
    @GuiSynced
    public boolean[] buyableOffers = new boolean[this.offers.size()];
    @GuiSynced
    public EnumProblemState problemState = EnumProblemState.NO_PROBLEMS;
    @GuiSynced
    public int maxOffers = 0;
    @GuiSynced
    public int currentOffers = 0;

    public ContainerAmadron(EntityPlayer player) {
        super(null);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.func_75146_a(new SlotUntouchable((IInventory)this.inv, y * 4 + x * 2, x * 73 + 12, y * 35 + 70));
                this.func_75146_a(new SlotUntouchable((IInventory)this.inv, y * 4 + x * 2 + 1, x * 73 + 57, y * 35 + 70));
            }
        }
        this.addSyncedFields(this);
        Arrays.fill(this.shoppingItems, -1);
        if (!player.field_70170_p.field_72995_K) {
            IInventory inv = ItemAmadronTablet.getItemProvider(player.func_71045_bC());
            IFluidHandler fluidHandler = ItemAmadronTablet.getLiquidProvider(player.func_71045_bC());
            for (int i = 0; i < this.offers.size(); ++i) {
                int amount = ContainerAmadron.capShoppingAmount(this.offers.get(i), 1, inv, fluidHandler, this);
                this.buyableOffers[i] = amount > 0;
            }
            this.problemState = EnumProblemState.NO_PROBLEMS;
            Map<AmadronOffer, Integer> shoppingCart = ItemAmadronTablet.getShoppingCart(player.func_71045_bC());
            for (Map.Entry<AmadronOffer, Integer> cartItem : shoppingCart.entrySet()) {
                int index;
                int offerId = this.offers.indexOf(cartItem.getKey());
                if (offerId < 0 || (index = this.getCartSlot(offerId)) < 0) continue;
                this.shoppingItems[index] = offerId;
                this.shoppingAmounts[index] = cartItem.getValue();
            }
            this.currentOffers = AmadronOfferManager.getInstance().countOffers(player.func_146103_bH().getId().toString());
            this.maxOffers = PneumaticCraftUtils.isPlayerOp(player) ? Integer.MAX_VALUE : AmadronOfferSettings.maxTradesPerPlayer;
        }
    }

    public void func_75141_a(int p_75141_1_, ItemStack p_75141_2_) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75131_a(ItemStack[] p_75131_1_) {
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Itemss.amadronTablet) {
            IPressurizable pressurizable = (IPressurizable)Itemss.amadronTablet;
            pressurizable.addAir(player.func_71045_bC(), -1);
            if (pressurizable.getPressure(player.func_71045_bC()) > 0.0f) {
                return true;
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.tab.problems.notEnoughPressure", new Object[0]));
        }
        return false;
    }

    public void clearStacks() {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            this.inv.func_70299_a(i, null);
        }
    }

    public void setStack(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        return null;
    }

    public void clickOffer(int offerId, int mouseButton, boolean sneaking, EntityPlayer player) {
        this.problemState = EnumProblemState.NO_PROBLEMS;
        int cartSlot = this.getCartSlot(offerId);
        if (cartSlot >= 0) {
            if (mouseButton == 2) {
                this.shoppingAmounts[cartSlot] = 0;
            } else if (sneaking) {
                if (mouseButton == 0) {
                    int n = cartSlot;
                    this.shoppingAmounts[n] = this.shoppingAmounts[n] / 2;
                } else {
                    AmadronOfferCustom custom;
                    AmadronOffer offer = this.offers.get(offerId);
                    if (offer instanceof AmadronOfferCustom && (custom = (AmadronOfferCustom)offer).getPlayerId().equals(player.func_146103_bH().getId().toString()) && AmadronOfferManager.getInstance().removeStaticOffer(custom)) {
                        if (AmadronOfferSettings.notifyOfTradeRemoval) {
                            NetworkHandler.sendToAll(new PacketAmadronTradeRemoved(custom));
                        }
                        custom.returnStock();
                        try {
                            AmadronOfferStaticConfig.INSTANCE.writeToFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        player.func_71053_j();
                    }
                    int n = cartSlot;
                    this.shoppingAmounts[n] = this.shoppingAmounts[n] * 2;
                    if (this.shoppingAmounts[cartSlot] == 0) {
                        this.shoppingAmounts[cartSlot] = 1;
                    }
                }
            } else if (mouseButton == 0) {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] - 1;
            } else {
                int n = cartSlot;
                this.shoppingAmounts[n] = this.shoppingAmounts[n] + 1;
            }
            if (this.shoppingAmounts[cartSlot] <= 0) {
                this.shoppingAmounts[cartSlot] = 0;
                this.shoppingItems[cartSlot] = -1;
            } else {
                this.shoppingAmounts[cartSlot] = this.capShoppingAmount(offerId, this.shoppingAmounts[cartSlot], player);
                this.shoppingItems[cartSlot] = this.shoppingAmounts[cartSlot] > 0 ? offerId : -1;
            }
        }
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (guiID == 1) {
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                EntityDrone drone;
                if (this.shoppingItems[i] < 0) continue;
                AmadronOffer offer = this.offers.get(this.shoppingItems[i]);
                ChunkPosition itemPos = ItemAmadronTablet.getItemProvidingLocation(player.func_71045_bC());
                World itemWorld = null;
                if (itemPos == null) {
                    itemPos = new ChunkPosition((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    itemWorld = player.field_70170_p;
                } else {
                    itemWorld = PneumaticCraftUtils.getWorldForDimension(ItemAmadronTablet.getItemProvidingDimension(player.func_71045_bC()));
                }
                ChunkPosition liquidPos = ItemAmadronTablet.getLiquidProvidingLocation(player.func_71045_bC());
                World liquidWorld = null;
                if (liquidPos != null) {
                    liquidWorld = PneumaticCraftUtils.getWorldForDimension(ItemAmadronTablet.getLiquidProvidingDimension(player.func_71045_bC()));
                }
                if ((drone = ContainerAmadron.retrieveOrderItems(offer, this.shoppingAmounts[i], itemWorld, itemPos, liquidWorld, liquidPos)) == null) continue;
                drone.setHandlingOffer(offer, this.shoppingAmounts[i], player.func_71045_bC(), player.func_70005_c_());
            }
            Arrays.fill(this.shoppingAmounts, 0);
            Arrays.fill(this.shoppingItems, -1);
        } else if (guiID == 2) {
            player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.AMADRON_ADD_TRADE.ordinal(), player.field_70170_p, 0, 0, 0);
        }
    }

    public static EntityDrone retrieveOrderItems(AmadronOffer offer, int times, World itemWorld, ChunkPosition itemPos, World liquidWorld, ChunkPosition liquidPos) {
        if (offer.getInput() instanceof ItemStack) {
            ItemStack stack;
            if (itemWorld == null || itemPos == null) {
                return null;
            }
            ItemStack queryingItems = (ItemStack)offer.getInput();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int amount = queryingItems.field_77994_a * times; amount > 0; amount -= stack.field_77994_a) {
                stack = queryingItems.func_77946_l();
                stack.field_77994_a = Math.min(amount, stack.func_77976_d());
                stacks.add(stack);
            }
            return (EntityDrone)PneumaticRegistry.getInstance().retrieveItemsAmazonStyle(itemWorld, itemPos.field_151329_a, itemPos.field_151327_b, itemPos.field_151328_c, stacks.toArray(new ItemStack[stacks.size()]));
        }
        if (liquidWorld == null || liquidPos == null) {
            return null;
        }
        FluidStack queryingFluid = ((FluidStack)offer.getInput()).copy();
        queryingFluid.amount *= times;
        return (EntityDrone)PneumaticRegistry.getInstance().retrieveFluidAmazonStyle(liquidWorld, liquidPos.field_151329_a, liquidPos.field_151327_b, liquidPos.field_151328_c, queryingFluid);
    }

    public int capShoppingAmount(int offerId, int wantedAmount, EntityPlayer player) {
        IInventory inv = ItemAmadronTablet.getItemProvider(player.func_71045_bC());
        IFluidHandler fluidHandler = ItemAmadronTablet.getLiquidProvider(player.func_71045_bC());
        return ContainerAmadron.capShoppingAmount(this.offers.get(offerId), wantedAmount, inv, fluidHandler, this);
    }

    public static int capShoppingAmount(AmadronOffer offer, int wantedAmount, IInventory inv, IFluidHandler fluidHandler, ContainerAmadron container) {
        return ContainerAmadron.capShoppingAmount(offer, wantedAmount, inv, inv, fluidHandler, fluidHandler, container);
    }

    public static int capShoppingAmount(AmadronOffer offer, int wantedAmount, IInventory inputInv, IInventory outputInv, IFluidHandler inputFluidHandler, IFluidHandler outputFluidHandler, ContainerAmadron container) {
        int maxAmount;
        if (container != null && offer.getStock() >= 0 && wantedAmount > offer.getStock()) {
            wantedAmount = offer.getStock();
            container.problemState = EnumProblemState.OUT_OF_STOCK;
        }
        if (offer.getInput() instanceof ItemStack) {
            if (inputInv != null) {
                ItemStack searchingItem = (ItemStack)offer.getInput();
                int count = 0;
                for (int i = 0; i < inputInv.func_70302_i_(); ++i) {
                    if (inputInv.func_70301_a(i) == null || !inputInv.func_70301_a(i).func_77969_a(searchingItem) || !ItemStack.func_77970_a((ItemStack)inputInv.func_70301_a(i), (ItemStack)searchingItem)) continue;
                    count += inputInv.func_70301_a((int)i).field_77994_a;
                }
                maxAmount = count / ((ItemStack)offer.getInput()).field_77994_a;
                if (wantedAmount > maxAmount) {
                    if (container != null) {
                        container.problemState = EnumProblemState.NOT_ENOUGH_ITEMS;
                    }
                    wantedAmount = maxAmount;
                }
            } else if (outputInv == null) {
                wantedAmount = 0;
                if (container != null) {
                    container.problemState = EnumProblemState.NO_ITEM_PROVIDER;
                }
            }
        } else if (inputFluidHandler != null) {
            FluidStack searchingFluid = ((FluidStack)offer.getInput()).copy();
            searchingFluid.amount = Integer.MAX_VALUE;
            FluidStack extracted = inputFluidHandler.drain(ForgeDirection.UP, searchingFluid, false);
            maxAmount = 0;
            if (extracted != null) {
                maxAmount = extracted.amount / ((FluidStack)offer.getInput()).amount;
            }
            if (wantedAmount > maxAmount) {
                if (container != null) {
                    container.problemState = EnumProblemState.NOT_ENOUGH_FLUID;
                }
                wantedAmount = maxAmount;
            }
        } else if (outputFluidHandler == null) {
            wantedAmount = 0;
            if (container != null) {
                container.problemState = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        if (offer.getOutput() instanceof ItemStack) {
            if (outputInv != null) {
                ItemStack providingItem = ((ItemStack)offer.getOutput()).func_77946_l();
                providingItem.field_77994_a *= wantedAmount;
                ItemStack remainder = IOHelper.insert(outputInv, providingItem.func_77946_l(), 0, true);
                if (remainder != null && wantedAmount > (maxAmount = (providingItem.field_77994_a - remainder.field_77994_a) / ((ItemStack)offer.getOutput()).field_77994_a)) {
                    wantedAmount = maxAmount;
                    if (container != null) {
                        container.problemState = EnumProblemState.NOT_ENOUGH_ITEM_SPACE;
                    }
                }
            } else if (inputInv == null) {
                wantedAmount = 0;
                if (container != null) {
                    container.problemState = EnumProblemState.NO_ITEM_PROVIDER;
                }
            }
        } else if (outputFluidHandler != null) {
            FluidStack providingFluid = ((FluidStack)offer.getOutput()).copy();
            providingFluid.amount *= wantedAmount;
            int amountFilled = outputFluidHandler.fill(ForgeDirection.UP, providingFluid, false);
            maxAmount = amountFilled / ((FluidStack)offer.getOutput()).amount;
            if (wantedAmount > maxAmount) {
                wantedAmount = maxAmount;
                if (container != null) {
                    container.problemState = EnumProblemState.NOT_ENOUGH_FLUID_SPACE;
                }
            }
        } else if (inputFluidHandler == null) {
            wantedAmount = 0;
            if (container != null) {
                container.problemState = EnumProblemState.NO_FLUID_PROVIDER;
            }
        }
        return wantedAmount;
    }

    public int getCartSlot(int offerId) {
        int freeSlot = -1;
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] == offerId) {
                return i;
            }
            if (freeSlot != -1 || this.shoppingItems[i] != -1) continue;
            freeSlot = i;
        }
        return freeSlot;
    }

    public int getShoppingCartAmount(AmadronOffer offer) {
        int offerId = this.offers.indexOf(offer);
        for (int i = 0; i < this.shoppingItems.length; ++i) {
            if (this.shoppingItems[i] != offerId) continue;
            return this.shoppingAmounts[i];
        }
        return 0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Itemss.amadronTablet) {
            HashMap<AmadronOffer, Integer> shoppingCart = new HashMap<AmadronOffer, Integer>();
            for (int i = 0; i < this.shoppingItems.length; ++i) {
                if (this.shoppingItems[i] < 0) continue;
                shoppingCart.put(this.offers.get(this.shoppingItems[i]), this.shoppingAmounts[i]);
            }
            ItemAmadronTablet.setShoppingCart(player.func_71045_bC(), shoppingCart);
        }
    }

    public static enum EnumProblemState {
        NO_PROBLEMS("noProblems"),
        NO_ITEM_PROVIDER("noItemProvider"),
        NO_FLUID_PROVIDER("noFluidProvider"),
        NOT_ENOUGH_ITEM_SPACE("notEnoughItemSpace"),
        NOT_ENOUGH_FLUID_SPACE("notEnoughFluidSpace"),
        NOT_ENOUGH_ITEMS("notEnoughItems"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        OUT_OF_STOCK("outOfStock");

        private final String locKey;

        private EnumProblemState(String locKey) {
            this.locKey = locKey;
        }

        public String getLocalizationKey() {
            return "gui.tab.problems.amadron." + this.locKey;
        }
    }
}

