/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.item.IAmadronInterface;
import pneumaticCraft.common.item.ItemPressurizable;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSyncAmadronOffers;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.common.recipes.AmadronOfferManager;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.proxy.CommonProxy;

public class ItemAmadronTablet
extends ItemPressurizable
implements IAmadronInterface {
    public ItemAmadronTablet(String textureLocation, int maxAir, int volume) {
        super(textureLocation, maxAir, volume);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NetworkHandler.sendTo(new PacketSyncAmadronOffers(AmadronOfferManager.getInstance().getAllOffers()), (EntityPlayerMP)player);
            player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.AMADRON.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack tablet, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidHandler) {
            if (!world.field_72995_K) {
                ItemAmadronTablet.setLiquidProvidingLocation(tablet, x, y, z, world.field_73011_w.field_76574_g);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.amadronTable.setLiquidProvidingLocation", new Object[]{x, y, z, world.field_73011_w.field_76574_g, world.field_73011_w.func_80007_l()}));
            }
        } else if (te instanceof IInventory) {
            if (!world.field_72995_K) {
                ItemAmadronTablet.setItemProvidingLocation(tablet, x, y, z, world.field_73011_w.field_76574_g);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.amadronTable.setItemProvidingLocation", new Object[]{x, y, z, world.field_73011_w.field_76574_g, world.field_73011_w.func_80007_l()}));
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean par4) {
        int dim;
        super.func_77624_a(stack, player, infoList, par4);
        ChunkPosition pos = ItemAmadronTablet.getItemProvidingLocation(stack);
        if (pos != null) {
            dim = ItemAmadronTablet.getItemProvidingDimension(stack);
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.itemLocation", (Object[])new Object[]{pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, dim}));
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.selectItemLocation", (Object[])new Object[0]));
        }
        pos = ItemAmadronTablet.getLiquidProvidingLocation(stack);
        if (pos != null) {
            dim = ItemAmadronTablet.getLiquidProvidingDimension(stack);
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.fluidLocation", (Object[])new Object[]{pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, dim}));
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.amadronTablet.selectFluidLocation", (Object[])new Object[0]));
        }
    }

    public static IInventory getItemProvider(ItemStack tablet) {
        ChunkPosition pos = ItemAmadronTablet.getItemProvidingLocation(tablet);
        if (pos != null) {
            int dimension = ItemAmadronTablet.getItemProvidingDimension(tablet);
            TileEntity te = PneumaticCraftUtils.getTileEntity(pos, dimension);
            return IOHelper.getInventoryForTE(te);
        }
        return null;
    }

    public static ChunkPosition getItemProvidingLocation(ItemStack tablet) {
        NBTTagCompound compound = tablet.func_77978_p();
        if (compound != null) {
            int x = compound.func_74762_e("itemX");
            int y = compound.func_74762_e("itemY");
            int z = compound.func_74762_e("itemZ");
            if (x != 0 || y != 0 || z != 0) {
                return new ChunkPosition(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static int getItemProvidingDimension(ItemStack tablet) {
        return tablet.func_77942_o() ? tablet.func_77978_p().func_74762_e("itemDim") : 0;
    }

    public static void setItemProvidingLocation(ItemStack tablet, int x, int y, int z, int dimensionId) {
        NBTUtil.setInteger(tablet, "itemX", x);
        NBTUtil.setInteger(tablet, "itemY", y);
        NBTUtil.setInteger(tablet, "itemZ", z);
        NBTUtil.setInteger(tablet, "itemDim", dimensionId);
    }

    public static IFluidHandler getLiquidProvider(ItemStack tablet) {
        int dimension;
        TileEntity te;
        ChunkPosition pos = ItemAmadronTablet.getLiquidProvidingLocation(tablet);
        if (pos != null && (te = PneumaticCraftUtils.getTileEntity(pos, dimension = ItemAmadronTablet.getLiquidProvidingDimension(tablet))) instanceof IFluidHandler) {
            return (IFluidHandler)te;
        }
        return null;
    }

    public static ChunkPosition getLiquidProvidingLocation(ItemStack tablet) {
        NBTTagCompound compound = tablet.func_77978_p();
        if (compound != null) {
            int x = compound.func_74762_e("liquidX");
            int y = compound.func_74762_e("liquidY");
            int z = compound.func_74762_e("liquidZ");
            if (x != 0 || y != 0 || z != 0) {
                return new ChunkPosition(x, y, z);
            }
            return null;
        }
        return null;
    }

    public static int getLiquidProvidingDimension(ItemStack tablet) {
        return tablet.func_77942_o() ? tablet.func_77978_p().func_74762_e("liquidDim") : 0;
    }

    public static void setLiquidProvidingLocation(ItemStack tablet, int x, int y, int z, int dimensionId) {
        NBTUtil.setInteger(tablet, "liquidX", x);
        NBTUtil.setInteger(tablet, "liquidY", y);
        NBTUtil.setInteger(tablet, "liquidZ", z);
        NBTUtil.setInteger(tablet, "liquidDim", dimensionId);
    }

    public static Map<AmadronOffer, Integer> getShoppingCart(ItemStack tablet) {
        HashMap<AmadronOffer, Integer> offers = new HashMap<AmadronOffer, Integer>();
        if (tablet.func_77942_o() && tablet.func_77978_p().func_74764_b("shoppingCart")) {
            NBTTagList list = tablet.func_77978_p().func_150295_c("shoppingCart", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                offers.put(tag.func_74764_b("inStock") ? AmadronOfferCustom.loadFromNBT(tag) : AmadronOffer.loadFromNBT(tag), tag.func_74762_e("amount"));
            }
        }
        return offers;
    }

    public static void setShoppingCart(ItemStack tablet, Map<AmadronOffer, Integer> cart) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<AmadronOffer, Integer> entry : cart.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            entry.getKey().writeToNBT(tag);
            tag.func_74768_a("amount", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        NBTUtil.setCompoundTag(tablet, "shoppingCart", (NBTBase)list);
    }
}

