/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.item.ItemPressurizable;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.minigun.Minigun;

public class ItemMinigun
extends ItemPressurizable {
    private final Minigun minigun = new MinigunItem();

    public ItemMinigun(int maxAir, int volume) {
        super(null, maxAir, volume);
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, EntityPlayer p_77615_3_, int p_77615_4_) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentItem) {
        super.func_77663_a(stack, world, entity, slot, currentItem);
        EntityPlayer player = (EntityPlayer)entity;
        this.getMinigun(stack, player);
        if (!currentItem) {
            this.minigun.setMinigunSoundCounter(-1);
            this.minigun.setMinigunSpeed(0.0);
            this.minigun.setMinigunActivated(false);
            this.minigun.setMinigunTriggerTimeOut(0);
        }
        this.minigun.update(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (world.field_72995_K && currentItem && this.minigun.getMinigunSpeed() > 0.0) {
            this.suppressSwitchAnimation();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void suppressSwitchAnimation() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer renderer = mc.field_71460_t.field_78516_c;
        renderer.func_78441_a();
        renderer.field_78454_c = 1.0f;
        renderer.field_78451_d = 1.0f;
    }

    public Minigun getMinigun(ItemStack stack, EntityPlayer player) {
        this.minigun.setItemStack(stack).setAmmo(this.getAmmo(player)).setPlayer(player).setPressurizable(this, 20).setWorld(player.field_70170_p);
        return this.minigun;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean usedAmmo;
        ItemStack ammo;
        if (!world.field_72995_K && (ammo = this.getAmmo(player)) != null && (usedAmmo = this.getMinigun(stack, player).tryFireMinigun(null))) {
            player.field_71071_by.func_146026_a(Itemss.gunAmmo);
        }
        return stack;
    }

    private ItemStack getAmmo(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != Itemss.gunAmmo) continue;
            return stack;
        }
        return null;
    }

    private class MinigunItem
    extends Minigun {
        public MinigunItem() {
            super(false);
        }

        @Override
        public boolean isMinigunActivated() {
            return NBTUtil.getBoolean(this.stack, "activated");
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            NBTUtil.setBoolean(this.stack, "activated", activated);
        }

        @Override
        public void setAmmoColorStack(ItemStack ammo) {
            if (ammo != null) {
                NBTTagCompound tag = new NBTTagCompound();
                ammo.func_77955_b(tag);
                NBTUtil.setCompoundTag(this.stack, "ammoColorStack", (NBTBase)tag);
            } else {
                NBTUtil.removeTag(this.stack, "ammoColorStack");
            }
        }

        @Override
        public int getAmmoColor() {
            ItemStack ammo = null;
            if (NBTUtil.hasTag(this.stack, "ammoColorStack")) {
                NBTTagCompound tag = NBTUtil.getCompoundTag(this.stack, "ammoColorStack");
                ammo = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            return this.getAmmoColor(ammo);
        }

        @Override
        public void playSound(String soundName, float volume, float pitch) {
            this.world.func_72956_a((Entity)this.player, soundName, volume, pitch);
        }

        @Override
        public double getMinigunSpeed() {
            return NBTUtil.getDouble(this.stack, "speed");
        }

        @Override
        public void setMinigunSpeed(double minigunSpeed) {
            NBTUtil.setDouble(this.stack, "speed", minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return NBTUtil.getInteger(this.stack, "triggerTimeout");
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            NBTUtil.setInteger(this.stack, "triggerTimeout", minigunTriggerTimeOut);
        }

        @Override
        public int getMinigunSoundCounter() {
            return NBTUtil.getInteger(this.stack, "soundCounter");
        }

        @Override
        public void setMinigunSoundCounter(int minigunSoundCounter) {
            NBTUtil.setInteger(this.stack, "soundCounter", minigunSoundCounter);
        }

        @Override
        public double getMinigunRotation() {
            return NBTUtil.getDouble(this.stack, "rotation");
        }

        @Override
        public void setMinigunRotation(double minigunRotation) {
            NBTUtil.setDouble(this.stack, "rotation", minigunRotation);
        }

        @Override
        public double getOldMinigunRotation() {
            return NBTUtil.getDouble(this.stack, "oldRotation");
        }

        @Override
        public void setOldMinigunRotation(double oldMinigunRotation) {
            NBTUtil.setDouble(this.stack, "oldRotation", oldMinigunRotation);
        }
    }
}

