/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.client.render.item.RenderItemPneumaticHelmet;
import pneumaticCraft.client.render.pneumaticArmor.RenderCoordWireframe;
import pneumaticCraft.common.DateEventHandler;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.IChargingStationGUIHolderItem;
import pneumaticCraft.common.item.ItemPneumatic;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;
import pneumaticCraft.proxy.CommonProxy;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IRepairable", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft")})
public class ItemPneumaticArmor
extends ItemArmor
implements IPressurizable,
IChargingStationGUIHolderItem,
IRepairable,
IRevealer,
IGoggles,
IVisDiscountGear {
    private final String textureLocation;
    private final int volume;

    public ItemPneumaticArmor(String textureLocation, ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, int par4, int volume, int maxAir) {
        super(par2EnumArmorMaterial, par3, par4);
        this.textureLocation = textureLocation;
        this.volume = volume;
        this.func_77656_e(maxAir);
        this.func_77637_a(PneumaticCraft.tabPneumaticCraft);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("pneumaticcraft:" + this.textureLocation);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "pneumaticcraft:textures/armor/pneumatic_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack((Item)this));
        ItemStack chargedStack = new ItemStack((Item)this);
        this.addAir(chargedStack, 120000);
        subItems.add(chargedStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack iStack, EntityPlayer player, List textList, boolean par4) {
        float pressure = this.getPressure(iStack);
        textList.add((pressure < 0.5f ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GREEN) + "Pressure: " + (double)Math.round((double)pressure * 10.0) / 10.0 + " bar");
        ItemStack[] inventoryStacks = ItemPneumaticArmor.getUpgradeStacks(iStack);
        boolean isArmorEmpty = true;
        for (ItemStack stack : inventoryStacks) {
            if (stack == null) continue;
            isArmorEmpty = false;
            break;
        }
        if (isArmorEmpty) {
            textList.add("Insert in Charging Station to install upgrades");
        } else {
            RenderCoordWireframe coordHandler;
            textList.add("Upgrades installed:");
            PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, inventoryStacks);
            ItemStack searchedStack = ItemPneumaticArmor.getSearchedStack(iStack);
            if (searchedStack != null) {
                for (int i = 0; i < textList.size(); ++i) {
                    if (!((String)textList.get(i)).contains("Item Search")) continue;
                    textList.set(i, textList.get(i) + " (searching " + searchedStack.func_82833_r() + ")");
                    break;
                }
            }
            if ((coordHandler = ItemPneumaticArmor.getCoordTrackLocation(iStack)) != null) {
                for (int i = 0; i < textList.size(); ++i) {
                    if (!((String)textList.get(i)).contains("Coordinate Tracker")) continue;
                    textList.set(i, textList.get(i) + " (tracking " + coordHandler.x + ", " + coordHandler.y + ", " + coordHandler.z + " in " + coordHandler.worldObj.field_73011_w.func_80007_l() + ")");
                    break;
                }
            }
        }
        ItemPneumatic.addTooltip(iStack, player, textList);
    }

    public static ItemStack[] getUpgradeStacks(ItemStack iStack) {
        NBTTagList itemList;
        NBTTagCompound tag = NBTUtil.getCompoundTag(iStack, "UpgradeInventory");
        ItemStack[] inventoryStacks = new ItemStack[9];
        if (tag != null && (itemList = tag.func_150295_c("Items", 10)) != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound slotEntry = itemList.func_150305_b(i);
                byte j = slotEntry.func_74771_c("Slot");
                if (j < 0 || j >= 9) continue;
                inventoryStacks[j] = ItemStack.func_77949_a((NBTTagCompound)slotEntry);
            }
        }
        return inventoryStacks;
    }

    public static int getUpgrades(int upgradeDamage, ItemStack iStack) {
        ItemStack[] stacks;
        int upgrades = 0;
        for (ItemStack stack : stacks = ItemPneumaticArmor.getUpgradeStacks(iStack)) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != upgradeDamage) continue;
            upgrades += stack.field_77994_a;
        }
        return upgrades;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getSearchedStack() {
        return ItemPneumaticArmor.getSearchedStack(PneumaticCraft.proxy.getPlayer().func_82169_q(3));
    }

    public static ItemStack getSearchedStack(ItemStack helmetStack) {
        if (helmetStack == null || !NBTUtil.hasTag(helmetStack, "SearchStack")) {
            return null;
        }
        NBTTagCompound tag = NBTUtil.getCompoundTag(helmetStack, "SearchStack");
        if (tag.func_74762_e("itemID") == -1) {
            return null;
        }
        return new ItemStack(Item.func_150899_d((int)tag.func_74762_e("itemID")), 1, tag.func_74762_e("itemDamage"));
    }

    @SideOnly(value=Side.CLIENT)
    public static RenderCoordWireframe getCoordTrackLocation(ItemStack helmetStack) {
        if (helmetStack == null || !NBTUtil.hasTag(helmetStack, "CoordTracker")) {
            return null;
        }
        NBTTagCompound tag = NBTUtil.getCompoundTag(helmetStack, "CoordTracker");
        if (tag.func_74762_e("y") == -1 || FMLClientHandler.instance().getClient().field_71441_e.field_73011_w.field_76574_g != tag.func_74762_e("dimID")) {
            return null;
        }
        return new RenderCoordWireframe((World)FMLClientHandler.instance().getClient().field_71441_e, tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    @SideOnly(value=Side.CLIENT)
    public static String getEntityFilter(ItemStack helmetStack) {
        if (helmetStack == null || !NBTUtil.hasTag(helmetStack, "entityFilter")) {
            return "";
        }
        return NBTUtil.getString(helmetStack, "entityFilter");
    }

    public static void setEntityFilter(ItemStack helmetStack, String filter) {
        if (helmetStack != null) {
            NBTUtil.setString(helmetStack, "entityFilter", filter);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public float getPressure(ItemStack iStack) {
        int oldVolume;
        int volume = ItemPneumaticArmor.getUpgrades(0, iStack) * 5000 + 12000;
        if (volume < (oldVolume = NBTUtil.getInteger(iStack, "volume"))) {
            int currentAir = NBTUtil.getInteger(iStack, "air");
            currentAir = currentAir * volume / oldVolume;
            NBTUtil.setInteger(iStack, "air", currentAir);
        }
        NBTUtil.setInteger(iStack, "volume", volume);
        return (float)NBTUtil.getInteger(iStack, "air") / (float)volume;
    }

    public boolean hasSufficientPressure(ItemStack iStack) {
        return this.getPressure(iStack) > 0.0f;
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        int oldAir = NBTUtil.getInteger(iStack, "air");
        NBTUtil.setInteger(iStack, "air", Math.max(oldAir + amount, 0));
    }

    @Override
    public CommonProxy.EnumGuiId getGuiID() {
        return CommonProxy.EnumGuiId.PNEUMATIC_HELMET;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (armorSlot == 0 && (Config.useHelmetModel || DateEventHandler.isIronManEvent())) {
            RenderItemPneumaticHelmet.INSTANCE.render(entityLiving);
            RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
            ModelBiped model = armorSlot == 2 ? render.field_77111_i : render.field_77108_b;
            model.field_78116_c.field_78806_j = false;
            return model;
        }
        return null;
    }

    private boolean hasThaumcraftUpgradeAndPressure(ItemStack stack) {
        return this.hasSufficientPressure(stack) && ItemPneumaticArmor.getUpgrades(10, stack) > 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return this.hasThaumcraftUpgradeAndPressure(stack) ? 5 : 0;
    }

    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return this.hasThaumcraftUpgradeAndPressure(itemstack);
    }

    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return this.hasThaumcraftUpgradeAndPressure(itemstack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack iStack) {
        super.onArmorTick(world, player, iStack);
        if (!world.field_72995_K && NBTUtil.hasTag(iStack, "Inventory") && iStack.func_77978_p().func_74781_a("Inventory") instanceof NBTTagCompound) {
            Log.info("Converting 'Inventory' tag to 'UpgradeInventory' in Pneumatic items");
            iStack.func_77978_p().func_74782_a("UpgradeInventory", iStack.func_77978_p().func_74781_a("Inventory"));
            iStack.func_77978_p().func_82580_o("Inventory");
        }
    }
}

