/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.text.WordUtils;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.item.ItemPneumatic;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketNotifyVariablesRemote;
import pneumaticCraft.common.remote.GlobalVariableManager;
import pneumaticCraft.common.tileentity.TileEntitySecurityStation;
import pneumaticCraft.proxy.CommonProxy;

public class ItemRemote
extends ItemPneumatic {
    public ItemRemote(String texture) {
        super(texture);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.openGui(player, stack);
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack remote, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && !player.func_70093_af() && this.isAllowedToEdit(player, remote) && (te = world.func_147438_o(x, y, z)) instanceof TileEntitySecurityStation) {
            if (((TileEntitySecurityStation)te).doesAllowPlayer(player)) {
                NBTTagCompound tag = remote.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    remote.func_77982_d(tag);
                }
                tag.func_74768_a("securityX", x);
                tag.func_74768_a("securityY", y);
                tag.func_74768_a("securityZ", z);
                tag.func_74768_a("securityDimension", world.field_73011_w.field_76574_g);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("gui.remote.boundSecurityStation", new Object[]{x, y, z}));
                return true;
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("gui.remote.cantBindSecurityStation", new Object[0]));
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack remote, EntityPlayer player, List curInfo, boolean moreInfo) {
        super.func_77624_a(remote, player, curInfo, moreInfo);
        curInfo.add(I18n.func_135052_a((String)"gui.remote.tooltip.sneakRightClickToEdit", (Object[])new Object[0]));
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null && tag.func_74764_b("securityX")) {
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            for (String s : WordUtils.wrap((String)I18n.func_135052_a((String)"gui.remote.tooltip.boundToSecurityStation", (Object[])new Object[]{dimensionId, x, y, z}), (int)40).split(System.getProperty("line.separator"))) {
                curInfo.add(s);
            }
        } else {
            for (String s : WordUtils.wrap((String)I18n.func_135052_a((String)"gui.remote.tooltip.rightClickToBind", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))) {
                curInfo.add(s);
            }
        }
    }

    private void openGui(EntityPlayer player, ItemStack remote) {
        if (player.func_70093_af()) {
            if (this.isAllowedToEdit(player, remote)) {
                player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.REMOTE_EDITOR.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                NetworkHandler.sendTo(new PacketNotifyVariablesRemote(GlobalVariableManager.getInstance().getAllActiveVariableNames()), (EntityPlayerMP)player);
            }
        } else {
            player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.REMOTE.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public static boolean hasSameSecuritySettings(ItemStack remote1, ItemStack remote2) {
        NBTTagCompound tag1 = remote1.func_77978_p();
        NBTTagCompound tag2 = remote2.func_77978_p();
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        int x1 = tag1.func_74762_e("securityX");
        int y1 = tag1.func_74762_e("securityY");
        int z1 = tag1.func_74762_e("securityZ");
        int dimension1 = tag1.func_74762_e("securityDimension");
        int x2 = tag2.func_74762_e("securityX");
        int y2 = tag2.func_74762_e("securityY");
        int z2 = tag2.func_74762_e("securityZ");
        int dimension2 = tag2.func_74762_e("securityDimension");
        return x1 == x2 && y1 == y2 && z1 == z2 && dimension1 == dimension2;
    }

    private boolean isAllowedToEdit(EntityPlayer player, ItemStack remote) {
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null && tag.func_74764_b("securityX")) {
            TileEntity te;
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            WorldServer world = null;
            for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
                if (w.field_73011_w.field_76574_g != dimensionId) continue;
                world = w;
                break;
            }
            if (world != null && (te = world.func_147438_o(x, y, z)) instanceof TileEntitySecurityStation) {
                boolean canAccess = ((TileEntitySecurityStation)te).doesAllowPlayer(player);
                if (!canAccess) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("gui.remote.noEditRights", new Object[]{x, y, z}));
                }
                return canAccess;
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack remote, World worl, Entity entity, int slot, boolean holdingItem) {
        NBTTagCompound tag;
        if (!worl.field_72995_K && (tag = remote.func_77978_p()) != null && tag.func_74764_b("securityX")) {
            TileEntity te;
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            WorldServer world = null;
            for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
                if (w.field_73011_w.field_76574_g != dimensionId) continue;
                world = w;
                break;
            }
            if (world != null && !((te = world.func_147438_o(x, y, z)) instanceof TileEntitySecurityStation)) {
                tag.func_82580_o("securityX");
                tag.func_82580_o("securityY");
                tag.func_82580_o("securityZ");
                tag.func_82580_o("securityDimension");
            }
        }
    }
}

