/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.network.LocationIntPacket;

public class PacketCoordTrackUpdate
extends LocationIntPacket<PacketCoordTrackUpdate> {
    int dimensionID;

    public PacketCoordTrackUpdate() {
    }

    public PacketCoordTrackUpdate(World world, int x, int y, int z) {
        super(x, y, z);
        this.dimensionID = world.field_73011_w.field_76574_g;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.dimensionID);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.dimensionID = buffer.readInt();
    }

    @Override
    public void handleClientSide(PacketCoordTrackUpdate message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketCoordTrackUpdate message, EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70440_f(3);
        if (stack != null) {
            NBTTagCompound tag = NBTUtil.getCompoundTag(stack, "CoordTracker");
            tag.func_74768_a("dimID", message.dimensionID);
            tag.func_74768_a("x", message.x);
            tag.func_74768_a("y", message.y);
            tag.func_74768_a("z", message.z);
        }
    }
}

