/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import pneumaticCraft.common.inventory.ContainerLogistics;
import pneumaticCraft.common.inventory.SyncedField;
import pneumaticCraft.common.network.IDescSynced;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.network.PacketUpdateGui;
import pneumaticCraft.common.semiblock.SemiBlockManager;

public class PacketDescription
extends LocationIntPacket<PacketDescription> {
    private byte[] types;
    private Object[] values;
    private NBTTagCompound extraData;
    private IDescSynced.Type type;

    public PacketDescription() {
    }

    public PacketDescription(IDescSynced te) {
        super(te.getX(), te.getY(), te.getZ());
        this.type = te.getSyncType();
        this.values = new Object[te.getDescriptionFields().size()];
        this.types = new byte[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = te.getDescriptionFields().get(i).getValue();
            this.types[i] = PacketUpdateGui.getType(te.getDescriptionFields().get(i));
        }
        this.extraData = new NBTTagCompound();
        te.writeToPacket(this.extraData);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            buf.writeByte((int)this.types[i]);
            PacketUpdateGui.writeField(buf, this.values[i], this.types[i]);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.extraData);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = IDescSynced.Type.values()[buf.readByte()];
        int dataAmount = buf.readInt();
        this.types = new byte[dataAmount];
        this.values = new Object[dataAmount];
        for (int i = 0; i < dataAmount; ++i) {
            this.types[i] = buf.readByte();
            this.values[i] = PacketUpdateGui.readField(buf, this.types[i]);
        }
        this.extraData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static Object getSyncableForType(LocationIntPacket message, EntityPlayer player, IDescSynced.Type type) {
        switch (type) {
            case TILE_ENTITY: {
                return message.getTileEntity(player.field_70170_p);
            }
            case SEMI_BLOCK: {
                if (message.x == 0 && message.y == 0 && message.z == 0) {
                    Container container = player.field_71070_bA;
                    if (!(container instanceof ContainerLogistics)) break;
                    return ((ContainerLogistics)container).logistics;
                }
                return SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(player.field_70170_p, message.x, message.y, message.z);
            }
        }
        return null;
    }

    @Override
    public void handleClientSide(PacketDescription message, EntityPlayer player) {
        Object syncable;
        if (player.field_70170_p.func_72899_e(message.x, message.y, message.z) && (syncable = PacketDescription.getSyncableForType(message, player, message.type)) instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)syncable;
            List<SyncedField> descFields = descSynced.getDescriptionFields();
            if (descFields != null && descFields.size() == message.types.length) {
                for (int i = 0; i < descFields.size(); ++i) {
                    descFields.get(i).setValue(message.values[i]);
                }
            }
            descSynced.readFromPacket(message.extraData);
            descSynced.onDescUpdate();
        }
    }

    @Override
    public void handleServerSide(PacketDescription message, EntityPlayer player) {
    }
}

