/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;

public class PacketProgrammerUpdate
extends LocationIntPacket<PacketProgrammerUpdate> {
    private NBTTagCompound progWidgets;

    public PacketProgrammerUpdate() {
    }

    public PacketProgrammerUpdate(TileEntityProgrammer te) {
        super(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        this.progWidgets = new NBTTagCompound();
        te.writeProgWidgetsToNBT(this.progWidgets);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        try {
            new PacketBuffer(buffer).func_150786_a(this.progWidgets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        try {
            this.progWidgets = new PacketBuffer(buffer).func_150793_b();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleClientSide(PacketProgrammerUpdate message, EntityPlayer player) {
        this.handleServerSide((PacketProgrammerUpdate)null, player);
    }

    @Override
    public void handleServerSide(PacketProgrammerUpdate message, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof TileEntityProgrammer) {
            ((TileEntityProgrammer)te).readProgWidgetsFromNBT(message.progWidgets);
            ((TileEntityProgrammer)te).saveToHistory();
            if (!player.field_70170_p.field_72995_K) {
                this.updateOtherWatchingPlayers((TileEntityProgrammer)te, player);
            }
        }
    }

    private void updateOtherWatchingPlayers(TileEntityProgrammer te, EntityPlayer changingPlayer) {
        List players = changingPlayer.field_70170_p.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)(this.x - 5), (double)(this.y - 5), (double)(this.z - 5), (double)(this.x + 6), (double)(this.y + 6), (double)(this.z + 6)));
        for (EntityPlayerMP player : players) {
            if (player == changingPlayer) continue;
            NetworkHandler.sendTo(new PacketProgrammerUpdate(te), player);
        }
    }
}

