/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.network.AbstractPacket;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.common.recipes.AmadronOfferManager;

public class PacketSyncAmadronOffers
extends AbstractPacket<PacketSyncAmadronOffers> {
    private Collection<AmadronOffer> offers = new ArrayList<AmadronOffer>();

    public PacketSyncAmadronOffers() {
    }

    public PacketSyncAmadronOffers(Collection<AmadronOffer> offers) {
        this.offers = offers;
    }

    public void fromBytes(ByteBuf buf) {
        int offerCount = buf.readInt();
        for (int i = 0; i < offerCount; ++i) {
            if (buf.readBoolean()) {
                this.offers.add(AmadronOfferCustom.loadFromBuf(buf));
                continue;
            }
            this.offers.add(new AmadronOffer(PacketSyncAmadronOffers.getFluidOrItemStack(buf), PacketSyncAmadronOffers.getFluidOrItemStack(buf)));
        }
    }

    public static Object getFluidOrItemStack(ByteBuf buf) {
        if (buf.readByte() == 0) {
            return ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        return new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.offers.size());
        for (AmadronOffer offer : this.offers) {
            buf.writeBoolean(offer instanceof AmadronOfferCustom);
            PacketSyncAmadronOffers.writeFluidOrItemStack(offer.getInput(), buf);
            PacketSyncAmadronOffers.writeFluidOrItemStack(offer.getOutput(), buf);
            if (!(offer instanceof AmadronOfferCustom)) continue;
            ((AmadronOfferCustom)offer).writeToBuf(buf);
        }
    }

    public static void writeFluidOrItemStack(Object object, ByteBuf buf) {
        if (object instanceof ItemStack) {
            buf.writeByte(0);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)object));
        } else {
            buf.writeByte(1);
            FluidStack stack = (FluidStack)object;
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stack.getFluid().getName());
            buf.writeInt(stack.amount);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
        }
    }

    @Override
    public void handleClientSide(PacketSyncAmadronOffers message, EntityPlayer player) {
        AmadronOfferManager.getInstance().setOffers(message.offers);
    }

    @Override
    public void handleServerSide(PacketSyncAmadronOffers message, EntityPlayer player) {
    }
}

