/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;

public abstract class PacketUpdateTubeModule<REQ extends PacketUpdateTubeModule>
extends LocationIntPacket<REQ> {
    protected ForgeDirection moduleSide;

    public PacketUpdateTubeModule() {
    }

    public PacketUpdateTubeModule(TubeModule module) {
        super(module.getTube().x(), module.getTube().y(), module.getTube().z());
        this.moduleSide = module.getDirection();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte((int)((byte)this.moduleSide.ordinal()));
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.moduleSide = ForgeDirection.getOrientation((int)buffer.readByte());
    }

    @Override
    public void handleClientSide(REQ message, EntityPlayer player) {
        this.handleServerSide(message, player);
    }

    @Override
    public void handleServerSide(REQ message, EntityPlayer player) {
        TubeModule module;
        TileEntityPressureTube te = ModInteractionUtils.getInstance().getTube(player.field_70170_p.func_147438_o(((PacketUpdateTubeModule)message).x, ((PacketUpdateTubeModule)message).y, ((PacketUpdateTubeModule)message).z));
        if (te != null && (module = te.modules[((PacketUpdateTubeModule)message).moduleSide.ordinal()]) != null) {
            this.onModuleUpdate(module, message, player);
            if (!player.field_70170_p.field_72995_K) {
                NetworkHandler.sendToAllAround(message, player.field_70170_p);
            }
        }
    }

    protected abstract void onModuleUpdate(TubeModule var1, REQ var2, EntityPlayer var3);
}

