/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetCondition;
import pneumaticCraft.client.gui.widget.GuiCheckBox;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.DroneAIDig;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetCondition;
import pneumaticCraft.common.progwidgets.ProgWidgetItemFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetBlockCondition
extends ProgWidgetCondition {
    private boolean checkingForAir;
    private boolean checkingForLiquids;

    @Override
    public String getWidgetString() {
        return "conditionBlock";
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetItemFilter.class, ProgWidgetString.class};
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(ChunkPosition pos) {
                if (ProgWidgetBlockCondition.this.checkingForAir && this.drone.getWorld().func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
                    return true;
                }
                if (ProgWidgetBlockCondition.this.checkingForLiquids && PneumaticCraftUtils.isBlockLiquid(this.drone.getWorld().func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c))) {
                    return true;
                }
                if (!ProgWidgetBlockCondition.this.checkingForAir && !ProgWidgetBlockCondition.this.checkingForLiquids || ProgWidgetBlockCondition.this.getConnectedParameters()[1] != null) {
                    return DroneAIDig.isBlockValidForFilter((IBlockAccess)this.drone.getWorld(), this.drone, pos, this.widget);
                }
                return false;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCondition(this, guiProgrammer){

            @Override
            public void func_73866_w_() {
                super.func_73866_w_();
                this.addWidget(new GuiCheckBox(500, this.guiLeft + 5, this.guiTop + 60, -16777216, I18n.func_135052_a((String)"gui.progWidget.conditionBlock.checkForAir", (Object[])new Object[0])).setChecked(ProgWidgetBlockCondition.this.checkingForAir).setTooltip(I18n.func_135052_a((String)"gui.progWidget.conditionBlock.checkForAir.tooltip", (Object[])new Object[0])));
                this.addWidget(new GuiCheckBox(501, this.guiLeft + 5, this.guiTop + 72, -16777216, I18n.func_135052_a((String)"gui.progWidget.conditionBlock.checkForLiquids", (Object[])new Object[0])).setChecked(ProgWidgetBlockCondition.this.checkingForLiquids).setTooltip(I18n.func_135052_a((String)"gui.progWidget.conditionBlock.checkForLiquids.tooltip", (Object[])new Object[0])));
            }

            @Override
            protected boolean requiresNumber() {
                return false;
            }

            @Override
            protected boolean isSidedWidget() {
                return false;
            }

            @Override
            public void actionPerformed(IGuiWidget widget) {
                if (widget.getID() == 500) {
                    ProgWidgetBlockCondition.this.checkingForAir = !ProgWidgetBlockCondition.this.checkingForAir;
                }
                if (widget.getID() == 501) {
                    ProgWidgetBlockCondition.this.checkingForLiquids = !ProgWidgetBlockCondition.this.checkingForLiquids;
                } else {
                    super.actionPerformed(widget);
                }
            }
        };
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_BLOCK;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("checkingForAir", this.checkingForAir);
        tag.func_74757_a("checkingForLiquids", this.checkingForLiquids);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.checkingForAir = tag.func_74767_n("checkingForAir");
        this.checkingForLiquids = tag.func_74767_n("checkingForLiquids");
    }
}

