/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetCondition;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IJump;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetInventoryBase;
import pneumaticCraft.common.progwidgets.ProgWidgetJump;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.lib.Log;

public abstract class ProgWidgetCondition
extends ProgWidgetInventoryBase
implements ICondition,
IJump {
    private DroneAIBlockCondition evaluator;
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.HIGHER_THAN_EQUALS;

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        this.evaluator = this.getEvaluator(drone, widget);
        return this.evaluator;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[this.getParameters().length - 1] == null && this.getConnectedParameters()[this.getParameters().length * 2 - 1] == null) {
            curInfo.add("gui.progWidget.condition.error.noFlowControl");
        }
    }

    @Override
    public abstract Class<? extends IProgWidget>[] getParameters();

    protected abstract DroneAIBlockCondition getEvaluator(IDroneBase var1, IProgWidget var2);

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (this.evaluator != null) {
            boolean evaluation = this.evaluate(drone, this);
            if (evaluation) {
                drone.addDebugEntry("gui.progWidget.condition.evaluatedTrue");
            } else {
                drone.addDebugEntry("gui.progWidget.condition.evaluatedFalse");
            }
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, this, evaluation);
        }
        Log.error("Shouldn't be happening! ProgWidgetCondition");
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.evaluator.getResult();
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().length - 1];
        IProgWidget widget2 = this.getConnectedParameters()[this.getParameters().length * 2 - 1];
        ProgWidgetString textWidget = widget != null ? (ProgWidgetString)widget : null;
        ProgWidgetString textWidget2 = widget2 != null ? (ProgWidgetString)widget2 : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        if (textWidget2 != null) {
            locations.add(textWidget2.string);
        }
        return locations;
    }

    @Override
    public int getRequiredCount() {
        return this.getCount();
    }

    @Override
    public void setRequiredCount(int count) {
        this.setCount(count);
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("isAndFunction", this.isAndFunction);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.func_74767_n("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCondition(this, guiProgrammer);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        String anyAll = I18n.func_135052_a((String)(this.isAndFunction() ? "gui.progWidget.condition.all" : "gui.progWidget.condition.any"), (Object[])new Object[0]);
        return anyAll + " " + this.getOperator().toString() + " " + this.getRequiredCount();
    }

    @Override
    public int getCraftingColorIndex() {
        return 6;
    }
}

