/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetConditionBase;

public abstract class ProgWidgetDroneEvaluation
extends ProgWidgetConditionBase
implements ICondition {
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.HIGHER_THAN_EQUALS;
    private int requiredCount = 1;

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        int count = this.getCount(drone, widget);
        return this.getOperator() == ICondition.Operator.EQUALS ? count == this.getRequiredCount() : count >= this.getRequiredCount();
    }

    protected abstract int getCount(IDroneBase var1, IProgWidget var2);

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        if (widget instanceof ProgWidgetDroneEvaluation) {
            return null;
        }
        return new EntityAIBase(){

            public boolean func_75250_a() {
                return false;
            }
        };
    }

    @Override
    public int getRequiredCount() {
        return this.requiredCount;
    }

    @Override
    public void setRequiredCount(int count) {
        this.requiredCount = count;
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("isAndFunction", this.isAndFunction);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
        tag.func_74768_a("requiredCount", this.requiredCount);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.func_74767_n("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
        this.requiredCount = tag.func_74762_e("requiredCount");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCondition(this, guiProgrammer){

            @Override
            protected boolean isUsingAndOr() {
                return false;
            }
        };
    }

    @Override
    public String getExtraStringInfo() {
        String anyAll = I18n.func_135052_a((String)(this.isAndFunction() ? "gui.progWidget.condition.all" : "gui.progWidget.condition.any"), (Object[])new Object[0]);
        return anyAll + " " + this.getOperator().toString() + " " + this.getRequiredCount();
    }
}

