/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetCondition;
import pneumaticCraft.common.progwidgets.ProgWidgetItemFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetItemInventoryCondition
extends ProgWidgetCondition {
    @Override
    public String getWidgetString() {
        return "conditionItemInventory";
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetItemFilter.class, ProgWidgetString.class};
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(ChunkPosition pos) {
                IInventory inv = IOHelper.getInventoryForTE(this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
                if (inv != null) {
                    int count = 0;
                    Set<Integer> accessibleSlots = PneumaticCraftUtils.getAccessibleSlotsForInventoryAndSides(inv, ((ISidedWidget)((Object)this.widget)).getSides());
                    for (Integer i : accessibleSlots) {
                        ItemStack stack = inv.func_70301_a(i.intValue());
                        if (stack == null || !this.widget.isItemValidForFilters(stack)) continue;
                        count += stack.field_77994_a;
                    }
                    return ((ICondition)((Object)this.widget)).getOperator() == ICondition.Operator.EQUALS ? count == ((ICondition)((Object)this.widget)).getRequiredCount() : count >= ((ICondition)((Object)this.widget)).getRequiredCount();
                }
                return false;
            }
        };
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM_INVENTORY;
    }
}

