/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetCondition;
import pneumaticCraft.common.progwidgets.ProgWidgetLiquidFilter;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.common.util.FluidUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetLiquidInventoryCondition
extends ProgWidgetCondition {
    @Override
    public String getWidgetString() {
        return "conditionLiquidInventory";
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetLiquidFilter.class, ProgWidgetString.class};
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(ChunkPosition pos) {
                TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                int count = 0;
                if (te instanceof IFluidHandler) {
                    ArrayList<FluidStack> visitedStacks = new ArrayList<FluidStack>();
                    IFluidHandler inv = (IFluidHandler)te;
                    for (int i = 0; i < 6; ++i) {
                        FluidTankInfo[] info;
                        if (!((ISidedWidget)((Object)this.widget)).getSides()[i] || (info = inv.getTankInfo(ForgeDirection.getOrientation((int)i))) == null) continue;
                        for (FluidTankInfo inf : info) {
                            if (inf.fluid == null || visitedStacks.contains(visitedStacks) || !ProgWidgetLiquidFilter.isLiquidValid(inf.fluid.getFluid(), this.widget, 1)) continue;
                            visitedStacks.add(inf.fluid);
                            count += inf.fluid.amount;
                        }
                    }
                } else {
                    Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)this.drone.getWorld().func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
                    if (fluid != null && ProgWidgetLiquidFilter.isLiquidValid(fluid, this.widget, 1) && FluidUtils.isSourceBlock(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
                        count += 1000;
                    }
                }
                return ((ICondition)((Object)this.widget)).getOperator() == ICondition.Operator.EQUALS ? count == ((ICondition)((Object)this.widget)).getRequiredCount() : count >= ((ICondition)((Object)this.widget)).getRequiredCount();
            }
        };
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_LIQUID_INVENTORY;
    }
}

