/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.config.AmadronOfferPeriodicConfig;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.inventory.ContainerAmadron;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;

public class AmadronOfferManager {
    private static AmadronOfferManager CLIENT_INSTANCE = new AmadronOfferManager();
    private static AmadronOfferManager SERVER_INSTANCE = new AmadronOfferManager();
    private final LinkedHashSet<AmadronOffer> staticOffers = new LinkedHashSet();
    private final List<AmadronOffer> periodicOffers = new ArrayList<AmadronOffer>();
    private final LinkedHashSet<AmadronOffer> selectedPeriodicOffers = new LinkedHashSet();
    private final LinkedHashSet<AmadronOffer> allOffers = new LinkedHashSet();

    public static AmadronOfferManager getInstance() {
        return FMLCommonHandler.instance().getSide() == Side.SERVER ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public Collection<AmadronOffer> getStaticOffers() {
        return this.staticOffers;
    }

    public Collection<AmadronOffer> getPeriodicOffers() {
        return this.periodicOffers;
    }

    public Collection<AmadronOffer> getAllOffers() {
        return this.allOffers;
    }

    public boolean addStaticOffer(AmadronOffer offer) {
        this.allOffers.add(offer);
        return this.staticOffers.add(offer);
    }

    public boolean removeStaticOffer(AmadronOffer offer) {
        this.allOffers.remove(offer);
        return this.staticOffers.remove(offer);
    }

    public boolean addPeriodicOffer(AmadronOffer offer) {
        if (this.periodicOffers.contains(offer)) {
            return false;
        }
        this.periodicOffers.add(offer);
        return true;
    }

    public void removePeriodicOffer(AmadronOffer offer) {
        this.periodicOffers.remove(offer);
    }

    public boolean hasOffer(AmadronOffer offer) {
        return this.allOffers.contains(offer);
    }

    public void recompileOffers() {
        this.allOffers.clear();
        this.allOffers.addAll(this.staticOffers);
        this.allOffers.addAll(this.selectedPeriodicOffers);
    }

    @SideOnly(value=Side.CLIENT)
    public void setOffers(Collection<AmadronOffer> newOffers) {
        this.allOffers.clear();
        this.allOffers.addAll(newOffers);
    }

    public AmadronOffer get(AmadronOffer offer) {
        for (AmadronOffer o : this.allOffers) {
            if (!o.equals(offer)) continue;
            return o;
        }
        return null;
    }

    public int countOffers(String playerId) {
        int count = 0;
        for (AmadronOffer offer : this.allOffers) {
            if (!(offer instanceof AmadronOfferCustom) || !((AmadronOfferCustom)offer).getPlayerId().equals(playerId)) continue;
            ++count;
        }
        return count;
    }

    public void tryRestockCustomOffers() {
        for (AmadronOffer offer : this.allOffers) {
            if (!(offer instanceof AmadronOfferCustom)) continue;
            AmadronOfferCustom custom = (AmadronOfferCustom)offer;
            TileEntity input = custom.getProvidingTileEntity();
            TileEntity output = custom.getReturningTileEntity();
            int possiblePickups = ContainerAmadron.capShoppingAmount(custom.invert(), 50, input instanceof IInventory ? (IInventory)input : null, output instanceof IInventory ? (IInventory)output : null, input instanceof IFluidHandler ? (IFluidHandler)input : null, output instanceof IFluidHandler ? (IFluidHandler)output : null, null);
            if (possiblePickups > 0) {
                ChunkPosition pos = new ChunkPosition(input.field_145851_c, input.field_145848_d, input.field_145849_e);
                EntityDrone drone = ContainerAmadron.retrieveOrderItems(custom, possiblePickups, input.func_145831_w(), pos, input.func_145831_w(), pos);
                if (drone != null) {
                    drone.setHandlingOffer(custom.copy(), possiblePickups, null, "Restock");
                }
            }
            custom.invert();
            custom.payout();
        }
    }

    public void shufflePeriodicOffers() {
        Random rand = new Random();
        this.allOffers.removeAll(this.selectedPeriodicOffers);
        this.selectedPeriodicOffers.clear();
        int toBeSelected = Math.min(AmadronOfferPeriodicConfig.offersPer, this.periodicOffers.size());
        while (this.selectedPeriodicOffers.size() < toBeSelected) {
            this.selectedPeriodicOffers.add(this.periodicOffers.get(rand.nextInt(this.periodicOffers.size())));
        }
        this.allOffers.addAll(this.selectedPeriodicOffers);
    }
}

