/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes.programs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import pneumaticCraft.common.recipes.programs.AssemblyProgram;
import pneumaticCraft.common.recipes.programs.ProgramDrill;
import pneumaticCraft.common.recipes.programs.ProgramLaser;
import pneumaticCraft.common.tileentity.TileEntityAssemblyController;
import pneumaticCraft.common.tileentity.TileEntityAssemblyDrill;
import pneumaticCraft.common.tileentity.TileEntityAssemblyIOUnit;
import pneumaticCraft.common.tileentity.TileEntityAssemblyLaser;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController controller, TileEntityAssemblyPlatform platform, TileEntityAssemblyIOUnit ioUnitImport, TileEntityAssemblyIOUnit ioUnitExport, TileEntityAssemblyDrill drill, TileEntityAssemblyLaser laser) {
        boolean useAir = true;
        if (platform.getHeldStack() != null) {
            if (this.canItemBeDrilled(platform.getHeldStack())) {
                drill.goDrilling();
            } else if (drill.isIdle() && this.canItemBeLasered(platform.getHeldStack())) {
                laser.startLasering();
            } else if (drill.isIdle() && laser.isIdle()) {
                useAir = ioUnitExport.pickupItem(null);
            }
        } else if (!ioUnitExport.isIdle()) {
            useAir = ioUnitExport.pickupItem(null);
        } else {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            recipes.addAll(this.getRecipeList());
            recipes.addAll(new ProgramDrill().getRecipeList());
            recipes.addAll(new ProgramLaser().getRecipeList());
            useAir = ioUnitImport.pickupItem(recipes);
        }
        return useAir;
    }

    private boolean canItemBeLasered(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.laserRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    private boolean canItemBeDrilled(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.drillRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public List<AssemblyRecipe> getRecipeList() {
        return AssemblyRecipe.drillLaserRecipes;
    }
}

