/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty;

import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeTile;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cofh.api.item.IToolHammer;
import cpw.mods.fml.common.Optional;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.block.IPneumaticWrenchable;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.block.BlockPressureTube;
import pneumaticCraft.common.block.tubes.IPneumaticPosProvider;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.thirdparty.fmp.FMP;
import pneumaticCraft.common.thirdparty.fmp.PartPressureTube;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;

public class ModInteractionUtilImplementation
extends ModInteractionUtils {
    @Override
    @Optional.Method(modid="BuildCraft|Core")
    protected boolean isBCWrench(Item item) {
        return item instanceof IToolWrench;
    }

    @Override
    @Optional.Method(modid="CoFHCore")
    protected boolean isTEWrench(Item item) {
        return item instanceof IToolHammer;
    }

    @Override
    @Optional.Method(modid="BuildCraft|Core")
    public ItemStack exportStackToBCPipe(TileEntity te, ItemStack stack, ForgeDirection side) {
        if (this.isBCPipe(te)) {
            int amount = ((IPipeTile)te).injectItem(stack, true, side);
            stack.field_77994_a -= amount;
            if (stack.field_77994_a <= 0) {
                stack = null;
            }
        }
        return stack;
    }

    @Override
    @Optional.Method(modid="BuildCraft|Core")
    public boolean isBCPipe(TileEntity te) {
        return te instanceof IPipeTile && ((IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM;
    }

    @Override
    @Optional.Method(modid="ThermalExpansion")
    public ItemStack exportStackToTEPipe(TileEntity te, ItemStack stack, ForgeDirection side) {
        return stack;
    }

    @Override
    @Optional.Method(modid="ThermalExpansion")
    public boolean isTEPipe(TileEntity te) {
        return false;
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public IPneumaticMachine getMachine(TileEntity te) {
        if (te instanceof TileMultipart) {
            return FMP.getMultiPart((TileMultipart)te, IPneumaticMachine.class);
        }
        return super.getMachine(te);
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public IPneumaticWrenchable getWrenchable(TileEntity te) {
        if (te instanceof TileMultipart) {
            return FMP.getMultiPart((TileMultipart)te, IPneumaticWrenchable.class);
        }
        return super.getWrenchable(te);
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public boolean isMultipart(TileEntity te) {
        return te instanceof TileMultipart;
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public boolean isMultipartWiseConnected(Object part, ForgeDirection dir) {
        return ((PartPressureTube)part).passesOcclusionTest(dir);
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public void sendDescriptionPacket(IPneumaticPosProvider te) {
        if (te instanceof TMultiPart) {
            ((TMultiPart)te).sendDescUpdate();
        } else {
            super.sendDescriptionPacket(te);
        }
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public TileEntityPressureTube getTube(Object potentialTube) {
        if (potentialTube instanceof PartPressureTube) {
            return ((PartPressureTube)potentialTube).getTube();
        }
        if (potentialTube instanceof TileMultipart) {
            PartPressureTube tube = FMP.getMultiPart((TileMultipart)potentialTube, PartPressureTube.class);
            return tube != null ? tube.getTube() : null;
        }
        return super.getTube(potentialTube);
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public void removeTube(TileEntity te) {
        if (te instanceof TileMultipart) {
            PartPressureTube tube = FMP.getMultiPart((TileMultipart)te, PartPressureTube.class);
            if (tube != null) {
                List<ItemStack> drops = BlockPressureTube.getModuleDrops(tube.getTube());
                for (ItemStack drop : drops) {
                    EntityItem entity = new EntityItem(te.func_145831_w(), (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
                    entity.func_92058_a(drop);
                    te.func_145831_w().func_72838_d((Entity)entity);
                }
                ((TileMultipart)te).remPart((TMultiPart)tube);
            }
        } else {
            super.removeTube(te);
        }
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public boolean occlusionTest(AxisAlignedBB aabb, TileEntity te) {
        if (te instanceof TileMultipart) {
            return ((TileMultipart)te).occlusionTest(((TileMultipart)te).partList(), (TMultiPart)new NormallyOccludedPart(new Cuboid6(aabb)));
        }
        return super.occlusionTest(aabb, te);
    }
}

