/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty;

import codechicken.multipart.TMultiPart;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.IGuiHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.thirdparty.Chisel;
import pneumaticCraft.common.thirdparty.DramaSplash;
import pneumaticCraft.common.thirdparty.IRegistryListener;
import pneumaticCraft.common.thirdparty.IThirdParty;
import pneumaticCraft.common.thirdparty.NotEnoughKeys;
import pneumaticCraft.common.thirdparty.ae2.AE2;
import pneumaticCraft.common.thirdparty.bloodmagic.BloodMagic;
import pneumaticCraft.common.thirdparty.buildcraft.BuildCraft;
import pneumaticCraft.common.thirdparty.cofh.CoFHCore;
import pneumaticCraft.common.thirdparty.computercraft.ComputerCraft;
import pneumaticCraft.common.thirdparty.computercraft.OpenComputers;
import pneumaticCraft.common.thirdparty.ee3.EE3;
import pneumaticCraft.common.thirdparty.enderio.EnderIO;
import pneumaticCraft.common.thirdparty.fmp.FMPLoader;
import pneumaticCraft.common.thirdparty.forestry.Forestry;
import pneumaticCraft.common.thirdparty.hydraulicraft.Hydraulicraft;
import pneumaticCraft.common.thirdparty.ic2.IC2;
import pneumaticCraft.common.thirdparty.igwmod.IGWMod;
import pneumaticCraft.common.thirdparty.mfr.MFR;
import pneumaticCraft.common.thirdparty.openblocks.OpenBlocks;
import pneumaticCraft.common.thirdparty.thaumcraft.Thaumcraft;
import pneumaticCraft.common.thirdparty.waila.Waila;
import pneumaticCraft.lib.Log;

public class ThirdPartyManager
implements IGuiHandler {
    private static ThirdPartyManager INSTANCE = new ThirdPartyManager();
    private final List<IThirdParty> thirdPartyMods = new ArrayList<IThirdParty>();
    public static boolean computerCraftLoaded;

    public static ThirdPartyManager instance() {
        return INSTANCE;
    }

    public void index() {
        HashMap<String, Class<EnderIO>> thirdPartyClasses = new HashMap<String, Class<EnderIO>>();
        try {
            thirdPartyClasses.put("IC2", IC2.class);
            thirdPartyClasses.put("BuildCraft|Core", BuildCraft.class);
            thirdPartyClasses.put("IGWMod", IGWMod.class);
            thirdPartyClasses.put("ComputerCraft", ComputerCraft.class);
            if (!Loader.isModLoaded((String)"ComputerCraft")) {
                thirdPartyClasses.put("OpenComputers|Core", OpenComputers.class);
            }
            thirdPartyClasses.put("ForgeMultipart", FMPLoader.class);
            thirdPartyClasses.put("Waila", Waila.class);
            thirdPartyClasses.put("HydCraft", Hydraulicraft.class);
            thirdPartyClasses.put("Thaumcraft", Thaumcraft.class);
            thirdPartyClasses.put("AWWayofTime", BloodMagic.class);
            thirdPartyClasses.put("appliedenergistics2", AE2.class);
            thirdPartyClasses.put("chisel", Chisel.class);
            thirdPartyClasses.put("Forestry", Forestry.class);
            thirdPartyClasses.put("MineFactoryReloaded", MFR.class);
            thirdPartyClasses.put("OpenBlocks", OpenBlocks.class);
            thirdPartyClasses.put("CoFHCore", CoFHCore.class);
            thirdPartyClasses.put("notenoughkeys", NotEnoughKeys.class);
            thirdPartyClasses.put("EE3", EE3.class);
            thirdPartyClasses.put("EnderIO", EnderIO.class);
            DramaSplash.newDrama();
        }
        catch (Throwable e) {
            Log.error("A class loader loaded a class where MineMaarten didn't expect it to do so! Please report, as third party content is broken.");
            e.printStackTrace();
        }
        ArrayList<String> enabledThirdParty = new ArrayList<String>();
        Config.config.addCustomCategoryComment("third_party_enabling", "With these options you can disable third party content by mod. Useful if something in the mod changes and causes crashes.");
        for (String string : thirdPartyClasses.keySet()) {
            if (!Config.config.get("Third_Party_Enabling", string, true).getBoolean()) continue;
            enabledThirdParty.add(string);
        }
        Config.config.save();
        for (Map.Entry entry : thirdPartyClasses.entrySet()) {
            if (!enabledThirdParty.contains(entry.getKey()) || !Loader.isModLoaded((String)((String)entry.getKey()))) continue;
            try {
                this.thirdPartyMods.add((IThirdParty)((Class)entry.getValue()).newInstance());
            }
            catch (Throwable e) {
                Log.error("Failed to instantiate third party handler!");
                e.printStackTrace();
            }
        }
    }

    public void onItemRegistry(Item item) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onItemRegistry(item);
        }
    }

    public void onBlockRegistry(Block block) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onBlockRegistry(block);
        }
    }

    public void preInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.preInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PreInit phase!");
                e.printStackTrace();
            }
        }
    }

    public void init() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.init();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the Init phase!");
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.postInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PostInit phase!");
                e.printStackTrace();
            }
        }
    }

    public void clientSide() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientSide();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side!");
                e.printStackTrace();
            }
        }
    }

    public void clientInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side on the init!");
                e.printStackTrace();
            }
        }
    }

    @Optional.Method(modid="ForgeMultipart")
    public TMultiPart getPart(String partName) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof FMPLoader)) continue;
            return ((FMPLoader)thirdParty).fmp.createPart(partName, false);
        }
        return null;
    }

    @Optional.Method(modid="ForgeMultipart")
    public void registerPart(String partName, Class<? extends TMultiPart> multipart) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof FMPLoader)) continue;
            ((FMPLoader)thirdParty).fmp.registerPart(partName, multipart);
            return;
        }
        throw new IllegalStateException("No FMP found!");
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            Object obj;
            if (!(thirdParty instanceof IGuiHandler) || (obj = ((IGuiHandler)thirdParty).getServerGuiElement(ID, player, world, x, y, z)) == null) continue;
            return obj;
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            Object obj;
            if (!(thirdParty instanceof IGuiHandler) || (obj = ((IGuiHandler)thirdParty).getClientGuiElement(ID, player, world, x, y, z)) == null) continue;
            return obj;
        }
        return null;
    }
}

